/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity;

import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import java.util.ConcurrentModificationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileEntityBehaviour {
    public SmartTileEntity tileEntity;
    private int lazyTickRate;
    private int lazyTickCounter;

    public TileEntityBehaviour(SmartTileEntity te) {
        this.tileEntity = te;
        this.setLazyTickRate(10);
    }

    public abstract BehaviourType<?> getType();

    public void initialize() {
    }

    public void tick() {
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
    }

    public boolean isSafeNBT() {
        return false;
    }

    public ItemRequirement getRequiredItems() {
        return ItemRequirement.NONE;
    }

    public void onBlockChanged(BlockState oldState) {
    }

    public void onNeighborChanged(BlockPos neighborPos) {
    }

    public void remove() {
    }

    public void destroy() {
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void lazyTick() {
    }

    public BlockPos getPos() {
        return this.tileEntity.m_58899_();
    }

    public Level getWorld() {
        return this.tileEntity.m_58904_();
    }

    public static <T extends TileEntityBehaviour> T get(BlockGetter reader, BlockPos pos, BehaviourType<T> type) {
        BlockEntity te;
        try {
            te = reader.m_7702_(pos);
        }
        catch (ConcurrentModificationException e) {
            te = null;
        }
        return TileEntityBehaviour.get(te, type);
    }

    public static <T extends TileEntityBehaviour> void destroy(BlockGetter reader, BlockPos pos, BehaviourType<T> type) {
        T behaviour = TileEntityBehaviour.get(reader.m_7702_(pos), type);
        if (behaviour != null) {
            ((TileEntityBehaviour)behaviour).destroy();
        }
    }

    public static <T extends TileEntityBehaviour> T get(BlockEntity te, BehaviourType<T> type) {
        if (te == null) {
            return null;
        }
        if (!(te instanceof SmartTileEntity)) {
            return null;
        }
        SmartTileEntity ste = (SmartTileEntity)te;
        return ste.getBehaviour(type);
    }
}

