/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction;

import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionHandler;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EdgeInteractionRenderer {
    public static void tick() {
        boolean positive;
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (target == null || !(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        LocalPlayer player = mc.f_91074_;
        ItemStack heldItem = player.m_21205_();
        if (player.m_6144_()) {
            return;
        }
        EdgeInteractionBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)world, pos, EdgeInteractionBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (behaviour.requiredItem.orElse(heldItem.m_41720_()) != heldItem.m_41720_()) {
            return;
        }
        Direction face = result.m_82434_();
        List<Direction> connectiveSides = EdgeInteractionHandler.getConnectiveSides((Level)world, pos, face, behaviour);
        if (connectiveSides.isEmpty()) {
            return;
        }
        Direction closestEdge = connectiveSides.get(0);
        double bestDistance = Double.MAX_VALUE;
        Vec3 center = VecHelper.getCenterOf((Vec3i)pos);
        for (Direction direction : connectiveSides) {
            double distance = Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82546_(target.m_82450_().m_82546_(center)).m_82553_();
            if (distance > bestDistance) continue;
            bestDistance = distance;
            closestEdge = direction;
        }
        AABB bb = EdgeInteractionHandler.getBB(pos, closestEdge);
        boolean hit = bb.m_82390_(target.m_82450_());
        ValueBox box = new ValueBox(TextComponent.f_131282_, bb.m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_())), pos);
        Vec3 textOffset = Vec3.f_82478_;
        boolean bl = positive = closestEdge.m_122421_() == Direction.AxisDirection.POSITIVE;
        if (positive) {
            textOffset = face.m_122434_().m_122479_() ? (closestEdge.m_122434_().m_122478_() ? textOffset.m_82520_(0.0, -128.0, 0.0) : textOffset.m_82520_(-128.0, 0.0, 0.0)) : textOffset.m_82520_(-128.0, 0.0, 0.0);
        }
        box.offsetLabel(textOffset).withColors(8022572, 12033380).passive(!hit);
        CreateClient.OUTLINER.showValueBox("edge", box).lineWidth(0.015625f).withFaceTexture(hit ? AllSpecialTextures.THIN_CHECKERED : null).highlightFace(face);
    }
}

