/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.filtering;

import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringCountUpdatePacket;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilteringBehaviour
extends TileEntityBehaviour {
    public static BehaviourType<FilteringBehaviour> TYPE = new BehaviourType();
    ValueBoxTransform slotPositioning;
    boolean showCount;
    Vec3 textShift;
    private ItemStack filter = ItemStack.f_41583_;
    public int count;
    private Consumer<ItemStack> callback;
    private Supplier<Boolean> isActive;
    private Supplier<Boolean> showCountPredicate;
    int scrollableValue;
    int ticksUntilScrollPacket;
    boolean forceClientState;
    boolean recipeFilter;
    boolean fluidFilter;

    public FilteringBehaviour(SmartTileEntity te, ValueBoxTransform slot) {
        super(te);
        this.slotPositioning = slot;
        this.showCount = false;
        this.callback = stack -> {};
        this.isActive = () -> true;
        this.textShift = Vec3.f_82478_;
        this.count = 0;
        this.ticksUntilScrollPacket = -1;
        this.showCountPredicate = () -> this.showCount;
        this.recipeFilter = false;
        this.fluidFilter = false;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128365_("Filter", (Tag)this.getFilter().serializeNBT());
        nbt.m_128405_("FilterAmount", this.count);
        if (clientPacket && this.forceClientState) {
            nbt.m_128379_("ForceScrollable", true);
            this.forceClientState = false;
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        this.filter = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Filter"));
        this.count = nbt.m_128451_("FilterAmount");
        if (nbt.m_128441_("ForceScrollable")) {
            this.scrollableValue = this.count;
            this.ticksUntilScrollPacket = -1;
        }
        super.read(nbt, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.getWorld().f_46443_) {
            return;
        }
        if (this.ticksUntilScrollPacket == -1) {
            return;
        }
        if (this.ticksUntilScrollPacket > 0) {
            --this.ticksUntilScrollPacket;
            return;
        }
        AllPackets.channel.sendToServer((Object)new FilteringCountUpdatePacket(this.getPos(), this.scrollableValue));
        this.ticksUntilScrollPacket = -1;
    }

    public FilteringBehaviour withCallback(Consumer<ItemStack> filterCallback) {
        this.callback = filterCallback;
        return this;
    }

    public FilteringBehaviour forRecipes() {
        this.recipeFilter = true;
        return this;
    }

    public FilteringBehaviour forFluids() {
        this.fluidFilter = true;
        return this;
    }

    public FilteringBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public FilteringBehaviour showCountWhen(Supplier<Boolean> condition) {
        this.showCountPredicate = condition;
        return this;
    }

    public FilteringBehaviour showCount() {
        this.showCount = true;
        return this;
    }

    public FilteringBehaviour moveText(Vec3 shift) {
        this.textShift = shift;
        return this;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.scrollableValue = this.count;
    }

    public void setFilter(Direction face, ItemStack stack) {
        this.setFilter(stack);
    }

    public void setFilter(ItemStack stack) {
        boolean confirm = ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.filter);
        this.filter = stack.m_41777_();
        this.callback.accept(this.filter);
        this.count = !confirm ? 0 : (this.filter.m_41720_() instanceof FilterItem ? 0 : Math.min(stack.m_41613_(), stack.m_41741_()));
        this.forceClientState = true;
        this.tileEntity.m_6596_();
        this.tileEntity.sendData();
    }

    @Override
    public void destroy() {
        if (this.filter.m_41720_() instanceof FilterItem) {
            Vec3 pos = VecHelper.getCenterOf((Vec3i)this.getPos());
            Level world = this.getWorld();
            world.m_7967_((Entity)new ItemEntity(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.filter.m_41777_()));
        }
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        Item filterItem = this.filter.m_41720_();
        if (filterItem instanceof FilterItem) {
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, filterItem);
        }
        return ItemRequirement.NONE;
    }

    public ItemStack getFilter(Direction side) {
        return this.getFilter();
    }

    public ItemStack getFilter() {
        return this.filter.m_41777_();
    }

    public boolean isCountVisible() {
        return this.showCountPredicate.get();
    }

    public boolean test(ItemStack stack) {
        return !this.isActive() || this.filter.m_41619_() || FilterItem.test(this.tileEntity.m_58904_(), stack, this.filter);
    }

    public boolean test(FluidStack stack) {
        return !this.isActive() || this.filter.m_41619_() || FilterItem.test(this.tileEntity.m_58904_(), stack, this.filter);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean testHit(Vec3 hit) {
        BlockState state = this.tileEntity.m_58900_();
        Vec3 localHit = hit.m_82546_(Vec3.m_82528_((Vec3i)this.tileEntity.m_58899_()));
        return this.slotPositioning.testHit(state, localHit);
    }

    public int getAmount() {
        return this.count;
    }

    public boolean anyAmount() {
        return this.count == 0;
    }

    public boolean isActive() {
        return this.isActive.get();
    }
}

