/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.google.common.base.Predicates;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.CapManipulationBehaviourBase;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InvManipulationBehaviour
extends CapManipulationBehaviourBase<IItemHandler, InvManipulationBehaviour> {
    public static BehaviourType<InvManipulationBehaviour> TYPE = new BehaviourType();
    public static BehaviourType<InvManipulationBehaviour> EXTRACT = new BehaviourType();
    public static BehaviourType<InvManipulationBehaviour> INSERT = new BehaviourType();
    private BehaviourType<InvManipulationBehaviour> behaviourType;

    public static InvManipulationBehaviour forExtraction(SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        return new InvManipulationBehaviour(EXTRACT, te, target);
    }

    public static InvManipulationBehaviour forInsertion(SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        return new InvManipulationBehaviour(INSERT, te, target);
    }

    public InvManipulationBehaviour(SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        this(TYPE, te, target);
    }

    private InvManipulationBehaviour(BehaviourType<InvManipulationBehaviour> type, SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        super(te, target);
        this.behaviourType = type;
    }

    @Override
    protected Capability<IItemHandler> capability() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public ItemStack extract() {
        return this.extract(this.getAmountFromFilter());
    }

    public ItemStack extract(int amount) {
        return this.extract(amount, (Predicate<ItemStack>)Predicates.alwaysTrue());
    }

    public ItemStack extract(int amount, Predicate<ItemStack> filter) {
        return this.extract(amount, filter, ItemStack::m_41741_);
    }

    public ItemStack extract(int amount, Predicate<ItemStack> filter, Function<ItemStack, Integer> amountThreshold) {
        boolean shouldSimulate = this.simulateNext;
        this.simulateNext = false;
        if (this.getWorld().f_46443_) {
            return ItemStack.f_41583_;
        }
        IItemHandler inventory = (IItemHandler)this.targetCapability.orElse(null);
        if (inventory == null) {
            return ItemStack.f_41583_;
        }
        Predicate<ItemStack> test = this.getFilterTest(filter);
        ItemStack simulatedItems = InvManipulationBehaviour.extractAmountOrThresh(inventory, test, amount, amountThreshold, true);
        if (shouldSimulate || simulatedItems.m_41619_()) {
            return simulatedItems;
        }
        return InvManipulationBehaviour.extractAmountOrThresh(inventory, test, amount, amountThreshold, false);
    }

    private static ItemStack extractAmountOrThresh(IItemHandler inventory, Predicate<ItemStack> test, int amount, Function<ItemStack, Integer> amountThreshold, boolean shouldSimulate) {
        if (amount == -1) {
            return ItemHelper.extract(inventory, test, amountThreshold, shouldSimulate);
        }
        return ItemHelper.extract(inventory, test, amount, shouldSimulate);
    }

    public ItemStack insert(ItemStack stack) {
        boolean shouldSimulate = this.simulateNext;
        this.simulateNext = false;
        IItemHandler inventory = (IItemHandler)this.targetCapability.orElse(null);
        if (inventory == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)shouldSimulate);
    }

    protected Predicate<ItemStack> getFilterTest(Predicate<ItemStack> customFilter) {
        Predicate<ItemStack> test = customFilter;
        FilteringBehaviour filter = this.tileEntity.getBehaviour(FilteringBehaviour.TYPE);
        if (filter != null) {
            test = customFilter.and(filter::test);
        }
        return test;
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }
}

