/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.ghost;

import com.jozufozu.flywheel.util.VirtualEmptyModelData;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.ghost.GhostBlockParams;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import org.lwjgl.system.MemoryStack;

public abstract class GhostBlockRenderer {
    private static final GhostBlockRenderer transparent = new TransparentGhostBlockRenderer();
    private static final GhostBlockRenderer standard = new DefaultGhostBlockRenderer();

    public static GhostBlockRenderer transparent() {
        return transparent;
    }

    public static GhostBlockRenderer standard() {
        return standard;
    }

    public abstract void render(PoseStack var1, SuperRenderTypeBuffer var2, GhostBlockParams var3);

    private static class TransparentGhostBlockRenderer
    extends GhostBlockRenderer {
        private TransparentGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, GhostBlockParams params) {
            ms.m_85836_();
            Minecraft mc = Minecraft.m_91087_();
            BlockRenderDispatcher dispatcher = mc.m_91289_();
            BakedModel model = dispatcher.m_110910_(params.state);
            RenderType layer = RenderType.m_110466_();
            VertexConsumer vb = buffer.getEarlyBuffer(layer);
            BlockPos pos = params.pos;
            ms.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            ms.m_85837_(0.5, 0.5, 0.5);
            ms.m_85841_(0.85f, 0.85f, 0.85f);
            ms.m_85837_(-0.5, -0.5, -0.5);
            this.renderModel(params, ms.m_85850_(), vb, params.state, model, 1.0f, 1.0f, 1.0f, LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)pos), OverlayTexture.f_118083_, (IModelData)VirtualEmptyModelData.INSTANCE);
            ms.m_85849_();
        }

        public void renderModel(GhostBlockParams params, PoseStack.Pose entry, VertexConsumer vb, @Nullable BlockState state, BakedModel model, float p_228804_5_, float p_228804_6_, float p_228804_7_, int p_228804_8_, int p_228804_9_, IModelData modelData) {
            Random random = new Random();
            for (Direction direction : Direction.values()) {
                random.setSeed(42L);
                TransparentGhostBlockRenderer.renderQuad(params, entry, vb, p_228804_5_, p_228804_6_, p_228804_7_, model.getQuads(state, direction, random, modelData), p_228804_8_, p_228804_9_);
            }
            random.setSeed(42L);
            TransparentGhostBlockRenderer.renderQuad(params, entry, vb, p_228804_5_, p_228804_6_, p_228804_7_, model.getQuads(state, (Direction)null, random, modelData), p_228804_8_, p_228804_9_);
        }

        private static void renderQuad(GhostBlockParams params, PoseStack.Pose p_228803_0_, VertexConsumer p_228803_1_, float p_228803_2_, float p_228803_3_, float p_228803_4_, List<BakedQuad> p_228803_5_, int p_228803_6_, int p_228803_7_) {
            Float alpha = Float.valueOf(params.alphaSupplier.get().floatValue() * 0.75f * PlacementHelpers.getCurrentAlpha());
            for (BakedQuad bakedquad : p_228803_5_) {
                float f2;
                float f1;
                float f;
                if (bakedquad.m_111304_()) {
                    f = Mth.m_14036_((float)p_228803_2_, (float)0.0f, (float)1.0f);
                    f1 = Mth.m_14036_((float)p_228803_3_, (float)0.0f, (float)1.0f);
                    f2 = Mth.m_14036_((float)p_228803_4_, (float)0.0f, (float)1.0f);
                } else {
                    f = 1.0f;
                    f1 = 1.0f;
                    f2 = 1.0f;
                }
                TransparentGhostBlockRenderer.quad(alpha.floatValue(), p_228803_1_, p_228803_0_, bakedquad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, f, f1, f2, new int[]{p_228803_6_, p_228803_6_, p_228803_6_, p_228803_6_}, p_228803_7_);
            }
        }

        static void quad(float alpha, VertexConsumer vb, PoseStack.Pose p_227890_1_, BakedQuad p_227890_2_, float[] p_227890_3_, float p_227890_4_, float p_227890_5_, float p_227890_6_, int[] p_227890_7_, int p_227890_8_) {
            int[] aint = p_227890_2_.m_111303_();
            Vec3i Vector3i = p_227890_2_.m_111306_().m_122436_();
            Vector3f vector3f = new Vector3f((float)Vector3i.m_123341_(), (float)Vector3i.m_123342_(), (float)Vector3i.m_123343_());
            Matrix4f matrix4f = p_227890_1_.m_85861_();
            vector3f.m_122249_(p_227890_1_.m_85864_());
            int vertexSize = DefaultVertexFormat.f_85811_.m_86017_();
            int j = aint.length / vertexSize;
            try (MemoryStack memorystack = MemoryStack.stackPush();){
                ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
                IntBuffer intbuffer = bytebuffer.asIntBuffer();
                for (int k = 0; k < j; ++k) {
                    ((Buffer)intbuffer).clear();
                    intbuffer.put(aint, k * vertexSize, vertexSize);
                    float f = bytebuffer.getFloat(0);
                    float f1 = bytebuffer.getFloat(4);
                    float f2 = bytebuffer.getFloat(8);
                    float r = p_227890_3_[k] * p_227890_4_;
                    float g = p_227890_3_[k] * p_227890_5_;
                    float b = p_227890_3_[k] * p_227890_6_;
                    int l = vb.applyBakedLighting(p_227890_7_[k], bytebuffer);
                    float f9 = bytebuffer.getFloat(16);
                    float f10 = bytebuffer.getFloat(20);
                    Vector4f vector4f = new Vector4f(f, f1, f2, 1.0f);
                    vector4f.m_123607_(matrix4f);
                    vb.applyBakedNormals(vector3f, bytebuffer, p_227890_1_.m_85864_());
                    vb.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), r, g, b, alpha, f9, f10, p_227890_8_, l, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
                }
            }
        }
    }

    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, GhostBlockParams params) {
            ms.m_85836_();
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            BakedModel model = dispatcher.m_110910_(params.state);
            RenderType layer = ItemBlockRenderTypes.m_109284_((BlockState)params.state, (boolean)false);
            VertexConsumer vb = buffer.getEarlyBuffer(layer);
            BlockPos pos = params.pos;
            ms.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            dispatcher.m_110937_().renderModel(ms.m_85850_(), vb, params.state, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, (IModelData)VirtualEmptyModelData.INSTANCE);
            ms.m_85849_();
        }
    }
}

