/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.worldWrappers;

import com.jozufozu.flywheel.backend.IFlywheelWorld;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedChunkProvider;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class PlacementSimulationWorld
extends WrappedWorld
implements IFlywheelWorld {
    public Map<BlockPos, BlockState> blocksAdded;
    public Map<BlockPos, BlockEntity> tesAdded;
    public Set<SectionPos> spannedSections;
    public LevelLightEngine lighter;
    public WrappedChunkProvider chunkProvider;
    private final BlockPos.MutableBlockPos scratch = new BlockPos.MutableBlockPos();

    public PlacementSimulationWorld(Level wrapped) {
        this(wrapped, new WrappedChunkProvider());
    }

    public PlacementSimulationWorld(Level wrapped, WrappedChunkProvider chunkProvider) {
        super(wrapped, chunkProvider);
        this.chunkProvider = chunkProvider.setWorld(this);
        this.spannedSections = new HashSet<SectionPos>();
        this.lighter = new LevelLightEngine((LightChunkGetter)chunkProvider, true, false);
        this.blocksAdded = new HashMap<BlockPos, BlockState>();
        this.tesAdded = new HashMap<BlockPos, BlockEntity>();
    }

    @Override
    public LevelLightEngine m_5518_() {
        return this.lighter;
    }

    public void updateLightSources() {
        for (Map.Entry<BlockPos, BlockState> entry : this.blocksAdded.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            int light = state.getLightEmission((BlockGetter)this, pos);
            if (light <= 0) continue;
            this.lighter.m_142519_(pos, light);
        }
    }

    public void setTileEntities(Collection<BlockEntity> tileEntities) {
        this.tesAdded.clear();
        tileEntities.forEach(te -> this.tesAdded.put(te.m_58899_(), (BlockEntity)te));
    }

    public void clear() {
        this.blocksAdded.clear();
    }

    @Override
    public boolean m_7731_(BlockPos pos, BlockState newState, int flags) {
        this.blocksAdded.put(pos, newState);
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)pos);
        if (this.spannedSections.add(sectionPos)) {
            this.lighter.m_6191_(sectionPos, false);
        }
        if ((flags & 0x80) == 0) {
            this.lighter.m_142202_(pos);
        }
        return true;
    }

    public boolean m_46597_(BlockPos pos, BlockState state) {
        return this.m_7731_(pos, state, 0);
    }

    @Override
    public BlockEntity m_7702_(BlockPos pos) {
        return this.tesAdded.get(pos);
    }

    @Override
    public boolean m_7433_(BlockPos pos, Predicate<BlockState> condition) {
        return condition.test(this.m_8055_(pos));
    }

    public boolean m_46749_(BlockPos pos) {
        return true;
    }

    public boolean isAreaLoaded(BlockPos center, int range) {
        return true;
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.m_8055_((BlockPos)this.scratch.m_122178_(x, y, z));
    }

    @Override
    public BlockState m_8055_(BlockPos pos) {
        BlockState state = this.blocksAdded.get(pos);
        if (state != null) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }
}

