/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.worldgen.AllLayerPatterns;
import com.simibubi.create.foundation.worldgen.BiomeFilter;
import com.simibubi.create.foundation.worldgen.ConfigDrivenDecorator;
import com.simibubi.create.foundation.worldgen.ConfigDrivenFeatureEntry;
import com.simibubi.create.foundation.worldgen.LayeredOreFeature;
import com.simibubi.create.foundation.worldgen.VanillaStyleOreFeature;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.FeatureDecorator;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AllWorldFeatures {
    public static final Map<ResourceLocation, ConfigDrivenFeatureEntry> ENTRIES = new HashMap<ResourceLocation, ConfigDrivenFeatureEntry>();
    private static final BiomeFilter OVERWORLD_BIOMES = (r, b) -> b != Biome.BiomeCategory.NETHER && b != Biome.BiomeCategory.THEEND && b != Biome.BiomeCategory.NONE;
    private static final BiomeFilter NETHER_BIOMES = (r, b) -> b == Biome.BiomeCategory.NETHER;
    public static final ConfigDrivenFeatureEntry ZINC_ORE = AllWorldFeatures.register("zinc_ore", 12, 3.0f, OVERWORLD_BIOMES).between(1, 70).withBlocks(Couple.create(AllBlocks.ZINC_ORE, AllBlocks.DEEPSLATE_ZINC_ORE));
    public static final ConfigDrivenFeatureEntry STRIATED_ORES_OVERWORLD = AllWorldFeatures.register("striated_ores_overworld", 32, 0.055555556f, OVERWORLD_BIOMES).between(1, 70).withLayerPattern(AllLayerPatterns.SCORIA).withLayerPattern(AllLayerPatterns.CINNABAR).withLayerPattern(AllLayerPatterns.MAGNETITE).withLayerPattern(AllLayerPatterns.MALACHITE).withLayerPattern(AllLayerPatterns.LIMESTONE).withLayerPattern(AllLayerPatterns.OCHRESTONE);
    public static final ConfigDrivenFeatureEntry STRIATED_ORES_NETHER = AllWorldFeatures.register("striated_ores_nether", 32, 0.083333336f, NETHER_BIOMES).between(40, 90).withLayerPattern(AllLayerPatterns.SCORIA_NETHER).withLayerPattern(AllLayerPatterns.SCORCHIA_NETHER);
    public static final int forcedUpdateVersion = 2;

    private static ConfigDrivenFeatureEntry register(String id, int clusterSize, float frequency, BiomeFilter biomeFilter) {
        ConfigDrivenFeatureEntry configDrivenFeatureEntry = new ConfigDrivenFeatureEntry(id, clusterSize, frequency);
        configDrivenFeatureEntry.biomeFilter = biomeFilter;
        ENTRIES.put(Create.asResource(id), configDrivenFeatureEntry);
        return configDrivenFeatureEntry;
    }

    public static void registerFeatures() {
        ENTRIES.entrySet().forEach(entry -> Registry.m_122961_((Registry)BuiltinRegistries.f_123861_, (String)("create_" + ((ResourceLocation)entry.getKey()).m_135815_()), ((ConfigDrivenFeatureEntry)entry.getValue()).getFeature()));
    }

    public static void reload(BiomeLoadingEvent event) {
        ENTRIES.values().forEach(entry -> {
            if (entry.biomeFilter.test(event.getName(), event.getCategory())) {
                event.getGeneration().m_47842_(GenerationStep.Decoration.UNDERGROUND_ORES, entry.getFeature());
            }
        });
    }

    public static void fillConfig(ForgeConfigSpec.Builder builder) {
        ENTRIES.values().forEach(entry -> {
            builder.push(entry.id);
            entry.addToConfig(builder);
            builder.pop();
        });
    }

    public static void register() {
    }

    public static void registerOreFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{VanillaStyleOreFeature.INSTANCE, LayeredOreFeature.INSTANCE});
    }

    public static void registerDecoratorFeatures(RegistryEvent.Register<FeatureDecorator<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)ConfigDrivenDecorator.INSTANCE);
    }
}

