/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.worldgen.AllWorldFeatures;
import com.simibubi.create.foundation.worldgen.ConfigDrivenFeatureEntry;
import com.simibubi.create.foundation.worldgen.LayerPattern;
import com.simibubi.create.foundation.worldgen.LayeredOreFeature;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.configurations.DecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class ConfigDrivenOreConfiguration
implements FeatureConfiguration,
DecoratorConfiguration {
    public static final Codec<ConfigDrivenOreConfiguration> CODEC = RecordCodecBuilder.create(p_67849_ -> p_67849_.group((App)Codec.list((Codec)OreConfiguration.TargetBlockState.f_161031_).fieldOf("targets").forGetter(p_161027_ -> p_161027_.targetStates), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("discard_chance_on_air_exposure").forGetter(p_161020_ -> Float.valueOf(p_161020_.discardChanceOnAirExposure)), (App)Codec.STRING.fieldOf("key").forGetter(t -> t.key.m_135815_())).apply((Applicative)p_67849_, ConfigDrivenOreConfiguration::new));
    public final List<OreConfiguration.TargetBlockState> targetStates;
    public final float discardChanceOnAirExposure;
    public final ResourceLocation key;

    public ConfigDrivenOreConfiguration(List<OreConfiguration.TargetBlockState> targetStates, float discardChance, String key) {
        this.targetStates = targetStates;
        this.discardChanceOnAirExposure = discardChance;
        this.key = Create.asResource(key);
    }

    public int getSize() {
        return (Integer)this.entry().clusterSize.get();
    }

    public int getMinY() {
        return (Integer)this.entry().minHeight.get();
    }

    public int getMaxY() {
        return (Integer)this.entry().maxHeight.get();
    }

    public List<LayerPattern> getLayers() {
        return LayeredOreFeature.LAYER_PATTERNS.get(this.key);
    }

    public float getFrequency() {
        if (((Boolean)AllConfigs.COMMON.worldGen.disable.get()).booleanValue()) {
            return 0.0f;
        }
        return this.entry().frequency.getF();
    }

    protected ConfigDrivenFeatureEntry entry() {
        return AllWorldFeatures.ENTRIES.get(this.key);
    }
}

