/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory;

import com.magistuarmory.client.proxy.ClientProxy;
import com.magistuarmory.config.ModConfigurations;
import com.magistuarmory.event.EventHandler;
import com.magistuarmory.init.ModItems;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.network.PacketHandler;
import com.magistuarmory.proxy.IProxy;
import com.magistuarmory.server.proxy.ServerProxy;
import java.io.IOException;
import java.util.stream.Collectors;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="magistuarmory")
public class KnightlyArmory {
    public static final String ID = "magistuarmory";
    public static final IProxy PROXY = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    static final Logger LOGGER = LogManager.getLogger();

    public KnightlyArmory() throws IOException {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        PROXY.setup(modEventBus, forgeEventBus);
        modEventBus.addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addLayers);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfigurations.SPEC, "epic-knights.toml");
        PacketHandler.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        for (IHasModelProperty item : ModItems.customizableItems) {
            event.enqueueWork(item::registerModelProperty);
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    public void addLayers(EntityRenderersEvent.AddLayers event) {
        if (PROXY instanceof ClientProxy) {
            ClientProxy.onLateInit(event);
        }
    }
}

