/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.renderer.entity.layer;

import com.magistuarmory.client.renderer.model.ArmorDecorationModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmorDecorationLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends ArmorDecorationModel<T>>
extends RenderLayer<T, M> {
    private final A model;
    private final ResourceLocation BASE_RESOURCE_LOCATION;
    private final String name;

    public ArmorDecorationLayer(RenderLayerParent<T, M> p_i50936_1_, A p_i50936_2_, ResourceLocation texture, String name) {
        super(p_i50936_1_);
        this.model = p_i50936_2_;
        this.BASE_RESOURCE_LOCATION = texture;
        this.name = name;
    }

    public void render(PoseStack p_117096_, MultiBufferSource p_117097_, int p_117098_, T p_117099_, float p_117100_, float p_117101_, float p_117102_, float p_117103_, float p_117104_, float p_117105_) {
        this.renderArmorPiece(p_117096_, p_117097_, p_117099_, EquipmentSlot.CHEST, p_117098_, this.getArmorDecorationModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(p_117096_, p_117097_, p_117099_, EquipmentSlot.LEGS, p_117098_, this.getArmorDecorationModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(p_117096_, p_117097_, p_117099_, EquipmentSlot.FEET, p_117098_, this.getArmorDecorationModel(EquipmentSlot.FEET));
        this.renderArmorPiece(p_117096_, p_117097_, p_117099_, EquipmentSlot.HEAD, p_117098_, this.getArmorDecorationModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack p_117119_, MultiBufferSource p_117120_, T p_117121_, EquipmentSlot p_117122_, int p_117123_, A p_117124_) {
        ArmorItem armoritem;
        ItemStack itemstack = p_117121_.m_6844_(p_117122_);
        if (itemstack.m_41720_() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.m_41720_()).m_40402_() == p_117122_) {
            ((HumanoidModel)this.m_117386_()).m_102872_(p_117124_);
            this.setPartVisibility(p_117124_, p_117122_);
            boolean flag1 = itemstack.m_41790_();
            if (itemstack.m_41737_("BlockEntityTag") != null) {
                List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)itemstack), (ListTag)BannerBlockEntity.m_58487_((ItemStack)itemstack));
                this.renderPatterns(p_117119_, p_117120_, p_117123_, OverlayTexture.f_118083_, list, flag1, p_117124_);
            }
        }
    }

    protected void setPartVisibility(A p_188359_1_, EquipmentSlot p_188359_2_) {
        p_188359_1_.m_8009_(false);
        switch (p_188359_2_) {
            case HEAD: {
                ((ArmorDecorationModel)((Object)p_188359_1_)).f_102808_.f_104207_ = true;
                ((ArmorDecorationModel)((Object)p_188359_1_)).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((ArmorDecorationModel)((Object)p_188359_1_)).f_102810_.f_104207_ = true;
                ((ArmorDecorationModel)((Object)p_188359_1_)).f_102811_.f_104207_ = true;
                ((ArmorDecorationModel)((Object)p_188359_1_)).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: 
            case FEET: {
                ((ArmorDecorationModel)((Object)p_188359_1_)).f_102813_.f_104207_ = true;
                ((ArmorDecorationModel)((Object)p_188359_1_)).f_102814_.f_104207_ = true;
            }
        }
    }

    private void renderModel(PoseStack p_117107_, MultiBufferSource p_117108_, int p_117109_, ArmorItem p_117110_, boolean p_117111_, A p_117112_, boolean p_117113_, float p_117114_, float p_117115_, float p_117116_, @Nullable String p_117117_) {
        this.renderModel(p_117107_, p_117108_, p_117109_, p_117111_, p_117112_, p_117114_, p_117115_, p_117116_, this.getArmorDecorationResource());
    }

    private void renderModel(PoseStack p_117107_, MultiBufferSource p_117108_, int p_117109_, boolean p_117111_, A p_117112_, float p_117114_, float p_117115_, float p_117116_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)p_117108_, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)p_117111_);
        p_117112_.m_7695_(p_117107_, vertexconsumer, p_117109_, OverlayTexture.f_118083_, p_117114_, p_117115_, p_117116_, 1.0f);
    }

    private A getArmorDecorationModel(EquipmentSlot p_241736_1_) {
        return this.model;
    }

    public ResourceLocation getArmorDecorationResource() {
        return this.BASE_RESOURCE_LOCATION;
    }

    public void renderPatterns(PoseStack p_241717_0_, MultiBufferSource p_241717_1_, int p_241717_2_, int p_241717_3_, List<Pair<BannerPattern, DyeColor>> p_241717_7_, boolean hasfoil, A model) {
        this.renderPatterns(p_241717_0_, p_241717_1_, p_241717_2_, p_241717_3_, p_241717_7_, hasfoil, model, 1.0f, 1.0f, 1.0f);
    }

    public void renderPatterns(PoseStack p_241717_0_, MultiBufferSource p_241717_1_, int p_241717_2_, int p_241717_3_, List<Pair<BannerPattern, DyeColor>> p_241717_7_, boolean hasfoil, A model, float f, float f1, float f2) {
        VertexConsumer ivertexbuilder = ItemRenderer.m_115184_((MultiBufferSource)p_241717_1_, (RenderType)RenderType.m_110452_((ResourceLocation)this.getArmorDecorationResource()), (boolean)false, (boolean)hasfoil);
        for (ModelPart part : ((ArmorDecorationModel)((Object)model)).getParts()) {
            part.m_104306_(p_241717_0_, ivertexbuilder, p_241717_2_, p_241717_3_, f, f1, f2, 1.0f);
            for (int i = 0; i < 17 && i < p_241717_7_.size(); ++i) {
                Pair<BannerPattern, DyeColor> pair = p_241717_7_.get(i);
                float[] afloat = ((DyeColor)pair.getSecond()).m_41068_();
                VertexConsumer ivertexbuilder0 = ItemRenderer.m_115184_((MultiBufferSource)p_241717_1_, (RenderType)RenderType.m_110482_((ResourceLocation)new ResourceLocation("magistuarmory", "textures/models/armor/" + this.name + "/" + ((BannerPattern)pair.getFirst()).m_58572_() + ".png")), (boolean)false, (boolean)hasfoil);
                part.m_104306_(p_241717_0_, ivertexbuilder0, p_241717_2_, p_241717_3_, afloat[0], afloat[1], afloat[2], 1.0f);
            }
        }
    }
}

