/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.event;

import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.network.PacketHandler;
import com.magistuarmory.network.PacketLongReachAttack;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    @OnlyIn(value=Dist.CLIENT)
    public static void onMouseEvent(InputEvent.MouseInputEvent ev) {
        if (Minecraft.m_91087_().f_91073_ == null || Minecraft.m_91087_().f_91080_ != null || Minecraft.m_91087_().m_91104_()) {
            return;
        }
        KeyMapping keyAttack = Minecraft.m_91087_().f_91066_.f_92096_;
        if (ev.getButton() == keyAttack.getKey().m_84873_() && ev.getAction() == 1) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer clientPlayerEntity = mc.f_91074_;
            if (clientPlayerEntity == null || clientPlayerEntity.m_21254_()) {
                return;
            }
            ItemStack weapon = clientPlayerEntity.m_21205_();
            if (!(weapon.m_41720_() instanceof MedievalWeaponItem)) {
                return;
            }
            float reach = ((MedievalWeaponItem)weapon.m_41720_()).getReachDistance();
            if (reach <= 5.0f) {
                return;
            }
            HitResult rayTrace = ClientEventHandler.getMouseOver(reach);
            if (!(rayTrace instanceof EntityHitResult)) {
                return;
            }
            EntityHitResult entityRayTrace = (EntityHitResult)rayTrace;
            Entity entityHit = entityRayTrace.m_82443_();
            if (entityHit != null && entityHit.f_19802_ == 0 && entityHit != clientPlayerEntity && entityHit != clientPlayerEntity.m_20202_()) {
                PacketHandler.sendToServer(new PacketLongReachAttack(entityHit.m_142049_()));
            }
        }
    }

    public static HitResult getMouseOver(float reach) {
        Object blockHitResult = null;
        HitResult result = null;
        Minecraft mc = Minecraft.m_91087_();
        Entity viewEntity = mc.m_91288_();
        if (viewEntity != null) {
            AABB expBounds;
            double d0 = reach;
            result = viewEntity.m_19907_(d0, 0.0f, false);
            Vec3 eyePos = viewEntity.m_146892_();
            boolean flag = false;
            double d1 = d0;
            if (mc.f_91074_.m_7500_() && d1 < 6.0) {
                d0 = d1 = 6.0;
            } else if (d0 > (double)reach) {
                flag = true;
            }
            d1 *= d1;
            if (result != null) {
                d1 = result.m_82450_().m_82557_(eyePos);
            }
            Vec3 lookVec = viewEntity.m_20252_(1.0f);
            Vec3 attackVec = eyePos.m_82520_(lookVec.f_82479_ * d0, lookVec.f_82480_ * d0, lookVec.f_82481_ * d0);
            EntityHitResult entityRayTrace = ProjectileUtil.m_37287_((Entity)viewEntity, (Vec3)eyePos, (Vec3)attackVec, (AABB)(expBounds = viewEntity.m_142469_().m_82369_(lookVec.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0)), entity -> !entity.m_5833_() && entity.m_6087_(), (double)d1);
            if (entityRayTrace != null) {
                Vec3 hitVec = entityRayTrace.m_82450_();
                double d2 = eyePos.m_82557_(hitVec);
                if (flag && d2 > (double)(reach * reach)) {
                    result = BlockHitResult.m_82426_((Vec3)hitVec, (Direction)Direction.m_122366_((double)lookVec.f_82479_, (double)lookVec.f_82480_, (double)lookVec.f_82481_), (BlockPos)new BlockPos(hitVec));
                } else if (d2 < d1 || blockHitResult == null) {
                    result = entityRayTrace;
                }
            } else {
                result = BlockHitResult.m_82426_((Vec3)attackVec, (Direction)Direction.m_122366_((double)lookVec.f_82479_, (double)lookVec.f_82480_, (double)lookVec.f_82481_), (BlockPos)new BlockPos(attackVec));
            }
        }
        return result;
    }
}

