/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.event;

import com.magistuarmory.config.ModConfigurations;
import com.magistuarmory.init.ModItems;
import com.magistuarmory.item.MedievalShieldItem;
import com.magistuarmory.item.MedievalWeaponItem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    static final ArmorItem[] rustedHelmets = new ArmorItem[]{ModItems.RUSTEDCHAINMAIL_HELMET, ModItems.RUSTEDNORMAN_HELMET, ModItems.RUSTEDKETTLEHAT, ModItems.RUSTEDBARBUTE, ModItems.RUSTEDGREATHELM};
    static final ArmorItem[] rustedChestplates = new ArmorItem[]{ModItems.RUSTEDCHAINMAIL_CHESTPLATE, ModItems.RUSTEDCRUSADER_CHESTPLATE, ModItems.RUSTEDHALFARMOR_CHESTPLATE};
    static final ArmorItem[] rustedLeggings = new ArmorItem[]{ModItems.RUSTEDCHAINMAIL_LEGGINGS};
    static final ArmorItem[] rustedBoots = new ArmorItem[]{ModItems.RUSTEDCHAINMAIL_BOOTS, ModItems.RUSTEDCRUSADER_BOOTS};
    static final Item[] rustedMeleeWeapons = new Item[]{ModItems.RUSTEDBASTARDSWORD, ModItems.RUSTEDBASTARDSWORD, ModItems.RUSTEDHEAVYMACE};
    static final ArmorItem[] goldenHelmets = new ArmorItem[]{(ArmorItem)Items.f_42476_};
    static final ArmorItem[] goldenChestplates = new ArmorItem[]{(ArmorItem)Items.f_42477_};
    static final ArmorItem[] goldenLeggings = new ArmorItem[]{(ArmorItem)Items.f_42478_};
    static final ArmorItem[] goldenBoots = new ArmorItem[]{(ArmorItem)Items.f_42479_};
    static final ArmorItem[] banditHelmets = new ArmorItem[0];
    static final ArmorItem[] banditChestplates = new ArmorItem[]{ModItems.BRIGANDINE};
    static final ArmorItem[] banditLeggings = new ArmorItem[0];
    static final ArmorItem[] banditBoots = new ArmorItem[]{ModItems.GAMBESONBOOTS};
    static final Item[] goldenMeleeWeapons = new Item[]{ModItems.bastardswords.gold, ModItems.guisarmes.gold, ModItems.shortswords.gold, ModItems.lochaberaxes.gold};
    static final Item[] skeletonWeapons = new Item[]{ModItems.RUSTEDBASTARDSWORD, ModItems.RUSTEDBASTARDSWORD, ModItems.RUSTEDHEAVYMACE};
    static final ArmorItem[] witherHelmets = new ArmorItem[]{ModItems.SALLET, ModItems.MAXIMILIAN_HELMET};
    static final ArmorItem[] witherChestplates = new ArmorItem[]{ModItems.GOTHIC_CHESTPLATE, ModItems.MAXIMILIAN_CHESTPLATE};
    static final ArmorItem[] witherLeggings = new ArmorItem[]{ModItems.GOTHIC_LEGGINGS, ModItems.MAXIMILIAN_LEGGINGS};
    static final ArmorItem[] witherBoots = new ArmorItem[]{ModItems.GOTHIC_BOOTS, ModItems.MAXIMILIAN_BOOTS};
    static final Item[] witherMeleeWeapons = new Item[]{ModItems.zweihanders.steel, ModItems.flamebladedswords.steel, ModItems.lucernhammers.steel};

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent ev) {
        if (ev != null) {
            Entity entity = ev.getEntity();
            float damage = ev.getAmount();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ItemStack activeItem = player.m_21211_();
                if (player.m_21254_() && activeItem.m_41720_() instanceof MedievalShieldItem) {
                    ((MedievalShieldItem)activeItem.m_41720_()).onBlocked(activeItem, damage, player, ev.getSource());
                }
                if (player.m_21254_() && activeItem.m_41720_() instanceof MedievalWeaponItem && ((MedievalWeaponItem)activeItem.m_41720_()).canBlock()) {
                    ((MedievalWeaponItem)activeItem.m_41720_()).onBlocked(activeItem, damage, player, ev.getSource());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent ev) {
        Player player = ev.player;
        if (player.m_6844_(EquipmentSlot.HEAD).m_41619_() && ev.side.isClient() && !player.m_36170_(PlayerModelPart.HAT)) {
            Minecraft.m_91087_().f_91066_.m_168418_(PlayerModelPart.HAT, true);
        }
    }

    @SubscribeEvent
    public static void onEntityEvent(EntityJoinWorldEvent ev) {
        float chance = ((Float)ModConfigurations.put_armor_chance.get()).floatValue();
        if (ev != null && ((Boolean)ModConfigurations.put_armor_on_mobs.get()).booleanValue() && ev.getWorld().m_46791_().equals((Object)Difficulty.HARD)) {
            Entity entity = ev.getEntity();
            if (entity instanceof Zombie && !((Zombie)entity).m_6162_() && !(entity instanceof ZombieVillager) && !(entity instanceof ZombifiedPiglin)) {
                entity.m_8061_(EquipmentSlot.HEAD, EventHandler.getRandomItemStack((Item[])rustedHelmets, chance, new Random()));
                entity.m_8061_(EquipmentSlot.CHEST, EventHandler.getRandomItemStack((Item[])rustedChestplates, chance, new Random()));
                entity.m_8061_(EquipmentSlot.LEGS, EventHandler.getRandomItemStack((Item[])rustedLeggings, chance, new Random()));
                entity.m_8061_(EquipmentSlot.FEET, EventHandler.getRandomItemStack((Item[])rustedBoots, chance, new Random()));
                entity.m_8061_(EquipmentSlot.MAINHAND, EventHandler.getRandomItemStack(rustedMeleeWeapons, chance, new Random()));
            }
            if (entity instanceof PiglinBrute || entity instanceof ZombifiedPiglin) {
                if (new Random().nextInt(2) == 1) {
                    entity.m_8061_(EquipmentSlot.HEAD, EventHandler.getRandomItemStack((Item[])goldenHelmets, chance, new Random()));
                    entity.m_8061_(EquipmentSlot.CHEST, EventHandler.getRandomItemStack((Item[])goldenChestplates, chance, new Random()));
                    entity.m_8061_(EquipmentSlot.LEGS, EventHandler.getRandomItemStack((Item[])goldenLeggings, chance, new Random()));
                    entity.m_8061_(EquipmentSlot.FEET, EventHandler.getRandomItemStack((Item[])goldenBoots, chance, new Random()));
                } else {
                    entity.m_8061_(EquipmentSlot.HEAD, EventHandler.getRandomItemStack((Item[])banditHelmets, chance, new Random()));
                    entity.m_8061_(EquipmentSlot.CHEST, EventHandler.getRandomItemStack((Item[])banditChestplates, chance, new Random()));
                    entity.m_8061_(EquipmentSlot.LEGS, EventHandler.getRandomItemStack((Item[])banditLeggings, chance, new Random()));
                    entity.m_8061_(EquipmentSlot.FEET, EventHandler.getRandomItemStack((Item[])banditBoots, chance, new Random()));
                }
                entity.m_8061_(EquipmentSlot.MAINHAND, EventHandler.getRandomItemStack(goldenMeleeWeapons, chance, new Random(), Items.f_42430_));
            }
            if (entity instanceof Skeleton) {
                entity.m_8061_(EquipmentSlot.HEAD, EventHandler.getRandomItemStack((Item[])rustedHelmets, chance, new Random()));
                entity.m_8061_(EquipmentSlot.CHEST, EventHandler.getRandomItemStack((Item[])rustedChestplates, chance, new Random()));
                entity.m_8061_(EquipmentSlot.LEGS, EventHandler.getRandomItemStack((Item[])rustedLeggings, chance, new Random()));
                entity.m_8061_(EquipmentSlot.FEET, EventHandler.getRandomItemStack((Item[])rustedBoots, chance, new Random()));
                entity.m_8061_(EquipmentSlot.MAINHAND, EventHandler.getRandomItemStack(skeletonWeapons, chance, new Random(), Items.f_42411_));
            }
            if (entity instanceof WitherSkeleton) {
                Random rand0 = new Random();
                entity.m_8061_(EquipmentSlot.HEAD, EventHandler.getRandomItemStack((Item[])witherHelmets, chance, rand0));
                entity.m_8061_(EquipmentSlot.CHEST, EventHandler.getRandomItemStack((Item[])witherChestplates, chance, rand0));
                entity.m_8061_(EquipmentSlot.LEGS, EventHandler.getRandomItemStack((Item[])witherLeggings, chance, rand0));
                entity.m_8061_(EquipmentSlot.FEET, EventHandler.getRandomItemStack((Item[])witherBoots, chance, rand0));
                entity.m_8061_(EquipmentSlot.MAINHAND, EventHandler.getRandomItemStack(witherMeleeWeapons, chance, rand0, Items.f_42425_));
            }
        }
    }

    static ItemStack getRandomItemStack(Item[] items, double chance, Random rand) {
        return EventHandler.getRandomItemStack(items, chance, rand, Items.f_41852_);
    }

    static ItemStack getRandomItemStack(Item[] items, double chance, Random rand, Item defaultItem) {
        if (items.length == 0) {
            return new ItemStack((ItemLike)defaultItem);
        }
        int id = rand.nextInt((int)((double)items.length / chance));
        return id < items.length ? new ItemStack((ItemLike)items[id]) : new ItemStack((ItemLike)defaultItem);
    }
}

