/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.event.ClientEventHandler;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.network.PacketHandler;
import com.magistuarmory.network.PacketLanceCollision;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LanceItem
extends MedievalWeaponItem
implements IHasModelProperty {
    public boolean attacking = false;
    public double velocityProjection = 0.0;
    private int clickedTicks = 0;

    public LanceItem(String unlocName, Item.Properties build, Tier material, float baseAttackDamage, float materialFactor, float baseAttackSpeed, int armorPiercing, float reachDistance) {
        super(unlocName, build, material, baseAttackDamage, materialFactor, baseAttackSpeed, armorPiercing, reachDistance);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        this.setRaised((LivingEntity)p_41433_, !this.isRaised((LivingEntity)p_41433_));
        return super.m_7203_(p_41432_, p_41433_, p_41434_);
    }

    @Override
    public UseAnim m_6164_(ItemStack par1ItemStack) {
        return UseAnim.BOW;
    }

    @Override
    public void m_6883_(ItemStack par1ItemStack, Level world, Entity entity, int par4, boolean par5) {
        if (entity != null && entity instanceof Player) {
            HitResult result;
            Player player = (Player)entity;
            if (world.f_46443_ && player.m_21205_() != null && player.m_21205_().m_41720_() instanceof LanceItem && (result = ClientEventHandler.getMouseOver(this.getReachDistance())) != null && result instanceof EntityHitResult) {
                Entity aim = ((EntityHitResult)result).m_82443_();
                if (player.m_20159_() && aim instanceof LivingEntity && aim.m_6084_() && aim.m_142049_() != player.m_20202_().m_142049_()) {
                    this.collide((LivingEntity)aim, player, world);
                }
            }
            if (this.clickedTicks > 0) {
                --this.clickedTicks;
            }
            if (!this.isRaised((LivingEntity)player) && player.m_36335_().m_41519_((Item)this)) {
                this.setRaised((LivingEntity)player, true);
            }
        }
        super.m_6883_(par1ItemStack, world, entity, par4, par5);
    }

    public void collide(LivingEntity victim, Player player, Level world) {
        if (player == null) {
            return;
        }
        if (world == null) {
            return;
        }
        if (!this.isRaised((LivingEntity)player) && !player.m_36335_().m_41519_((Item)this)) {
            int bonusDamage = (int)this.calcBonusDamage((Entity)player, this.velocityProjection);
            if (player.m_20159_()) {
                this.velocityProjection = this.getVelocityProjection((Entity)player, (Entity)victim);
                if (player.m_20201_() instanceof Horse && this.velocityProjection >= ((Horse)player.m_20201_()).m_21051_(Attributes.f_22279_).m_22135_() || !(player.m_20201_() instanceof Horse) && this.velocityProjection >= 0.233) {
                    PacketHandler.sendToServer(new PacketLanceCollision(victim.m_142049_(), bonusDamage));
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (this.attacking) {
            Vec3 vec = player.m_20252_(1.0f);
            double b = 70.0 * Math.sqrt(Math.max(0.0, this.velocityProjection) / Math.max(0.5, vec.m_82553_() * this.getSummaryMass(entity))) / 5.0;
            if (entity.m_20159_()) {
                entity.m_20201_().m_20256_(entity.m_20201_().m_20184_().m_82520_(vec.f_82479_ * b, vec.f_82480_ * b, vec.f_82481_ * b));
                entity.m_20201_().f_19812_ = true;
                double d = this.clickedTicks > 0 ? 0.3 : 0.0;
                if ((d + 0.6 + 0.2 * entity.m_142469_().m_82399_().m_82546_(player.m_20299_(1.0f).m_82549_(player.m_20252_(this.getReachDistance()))).m_82526_(vec) / vec.m_82553_()) * Math.random() > 1.0) {
                    entity.m_142098_(entity.m_20185_() + vec.f_82479_, entity.m_20186_() + vec.f_82480_, entity.m_20189_() + vec.f_82481_);
                }
            } else {
                entity.m_20256_(entity.m_20184_().m_82520_(vec.f_82479_ * b, vec.f_82480_ * b, vec.f_82481_ * b));
                entity.f_19812_ = true;
            }
            return false;
        }
        if (!this.isRaised((LivingEntity)player) && !player.m_36335_().m_41519_((Item)this)) {
            this.clickedTicks = 15;
        }
        return true;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entityLiving) {
        return true;
    }

    public double calcBonusDamage(Entity player, double velocityProjection) {
        double bonusDamage = 0.0;
        bonusDamage = 5.0 * this.getSummaryMass(player) * velocityProjection;
        return Math.max(0.0, bonusDamage);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent("Rider Only").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)new TextComponent("Left-click before hitting to dismount target").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)new TextComponent("+bonus damage based on mass and speed").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    double getVelocityProjection(Entity entity1, Entity entity2) {
        Vec3 velocity = entity1.m_20159_() ? entity1.m_20201_().m_20184_() : entity1.m_20184_();
        Vec3 vec = entity1.m_20252_(1.0f);
        if (vec.m_82556_() == 0.0) {
            return 0.0;
        }
        return velocity.m_82526_(vec) / vec.m_82553_();
    }

    public double getSummaryMass(Entity entityIn) {
        Entity entity = entityIn;
        double summaryMass = this.getMass(entity);
        while (entity.m_20159_()) {
            entity = entity.m_20202_();
            summaryMass += this.getMass(entity);
        }
        entity = entityIn;
        while (entity.m_6688_() != null) {
            entity = entity.m_6688_();
            summaryMass += this.getMass(entity);
        }
        return summaryMass;
    }

    public double getMass(Entity entity) {
        double mass = 0.0;
        AABB box = entity.m_142469_();
        if (box != null) {
            mass += (box.f_82291_ - box.f_82288_) * (box.f_82292_ - box.f_82289_) * (box.f_82293_ - box.f_82290_);
        }
        for (ItemStack armorPiece : entity.m_6168_()) {
            if (armorPiece.m_41619_() || !(armorPiece.m_41720_() instanceof ArmorItem)) continue;
            mass += (double)((float)((ArmorItem)armorPiece.m_41720_()).m_40404_() + ((ArmorItem)armorPiece.m_41720_()).m_40405_()) / 20.0;
        }
        return mass;
    }

    public void onBroken(Player player) {
        if (player.m_21205_() != null && player.m_21205_().m_41720_() == this) {
            player.m_36176_(new ItemStack((ItemLike)Items.f_42398_), true);
            player.m_5496_(SoundEvents.f_12018_, 1.0f, 1.0f);
        }
    }

    public boolean isRaised(@Nullable LivingEntity entityIn) {
        if (entityIn == null) {
            return false;
        }
        ItemStack stack = entityIn.m_21205_();
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            return nbt.m_128441_("raised") && nbt.m_128454_("raised") == 1L;
        }
        return false;
    }

    public void setRaised(LivingEntity entityIn, boolean raisedIn) {
        ItemStack stack = entityIn.m_21205_();
        CompoundTag nbt = !stack.m_41782_() ? new CompoundTag() : this.getShareTag(stack);
        nbt.m_128356_("raised", raisedIn ? 1L : 0L);
        stack.m_41751_(nbt);
    }

    public void setAttackDamage(float attackDamageIn) {
        this.f_43266_ = attackDamageIn;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("magistuarmory", "raised"), (ItemPropertyFunction)new ItemPropertyFunction(){

            public float m_141951_(ItemStack p_174676_, @Nullable ClientLevel p_174677_, @Nullable LivingEntity p_174678_, int p_174679_) {
                return LanceItem.this.isRaised(p_174678_) ? 1.0f : 0.0f;
            }
        });
    }
}

