/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.KnightlyArmory;
import com.magistuarmory.client.proxy.ClientProxy;
import com.magistuarmory.client.renderer.model.item.AbstractModelBase;
import com.magistuarmory.client.renderer.tileentity.HeraldyItemStackRenderer;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.item.ModItemTier;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.ToolAction;

public class MedievalShieldItem
extends ShieldItem
implements IHasModelProperty {
    private int durability;
    private LazyLoadedValue<Ingredient> repairItem = new LazyLoadedValue(() -> Ingredient.m_43911_((Tag)ItemTags.f_13168_));
    private boolean paintable;
    public AbstractModelBase model;
    private HeraldyItemStackRenderer renderer;
    private float maxBlockDamage;
    private float weight;
    private String shieldName;
    private String materialName;

    public MedievalShieldItem(String shieldName, Item.Properties build, ModItemTier material, int durability, float weigth, float maxBlockDamage, boolean paintable) {
        super(build.m_41503_(durability));
        this.setRegistryName(material.getMaterialName() + "_" + shieldName);
        this.shieldName = shieldName;
        this.materialName = material.getMaterialName();
        this.durability = durability;
        this.paintable = paintable;
        this.maxBlockDamage = maxBlockDamage + material.m_6631_();
        this.weight = weigth + material.m_6631_();
        if (KnightlyArmory.PROXY instanceof ClientProxy) {
            this.renderer = (HeraldyItemStackRenderer)((ClientProxy)KnightlyArmory.PROXY).getShieldRenderer(this.materialName, shieldName);
        }
    }

    public String getShieldName() {
        return this.shieldName;
    }

    public void m_7373_(ItemStack p_43094_, @Nullable Level p_43095_, List<Component> p_43096_, TooltipFlag p_43097_) {
        p_43096_.add((Component)new TextComponent(this.getMaxBlockDamage() + " max damage block").m_130940_(ChatFormatting.BLUE));
        p_43096_.add((Component)new TextComponent(this.getWeight() + "kg weight").m_130940_(ChatFormatting.BLUE));
        if (this.weight >= 10.0f) {
            p_43096_.add((Component)new TextComponent("Slow movement speed").m_130940_(ChatFormatting.RED));
        }
        BannerItem.m_40542_((ItemStack)p_43094_, p_43096_);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.getWeight() < 10.0f || !(entityIn instanceof LivingEntity) || ((LivingEntity)entityIn).m_21205_() != stack && ((LivingEntity)entityIn).m_21205_() != stack) {
            return;
        }
        ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1, false, false, false));
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    private float getWeight() {
        return this.weight;
    }

    public String m_5671_(ItemStack p_43109_) {
        return this.m_5524_();
    }

    public int m_8105_(ItemStack p_43107_) {
        return (int)(12000.0f * this.weight);
    }

    public boolean m_6832_(ItemStack p_40392_, ItemStack p_40393_) {
        return ((Ingredient)this.repairItem.m_13971_()).test(p_40393_);
    }

    public boolean isPaintable() {
        return this.paintable;
    }

    public AbstractModelBase getModel() {
        return this.model;
    }

    public HeraldyItemStackRenderer getRenderer() {
        return this.renderer;
    }

    public float getMaxBlockDamage() {
        return this.maxBlockDamage;
    }

    public MedievalShieldItem setRepairItem(Supplier<Ingredient> repairItem) {
        this.repairItem = new LazyLoadedValue(repairItem);
        return this;
    }

    public void onBlocked(ItemStack stack, float damage, Player player, DamageSource source) {
        LivingEntity attacker;
        float armorPiercingFactor = 1.0f;
        if (source.m_7639_() instanceof LivingEntity && (attacker = (LivingEntity)source.m_7639_()).m_21205_().m_41720_() instanceof MedievalWeaponItem) {
            armorPiercingFactor += (float)((MedievalWeaponItem)attacker.m_21205_().m_41720_()).armorPiercing / 100.0f;
        }
        if (damage > this.getMaxBlockDamage()) {
            stack.m_41721_(this.durability);
            stack.m_41622_((int)(armorPiercingFactor * 0.2f * (float)stack.m_41776_()), (LivingEntity)player, p_40992_ -> p_40992_.m_21166_(EquipmentSlot.MAINHAND));
            float damage1 = damage - this.getMaxBlockDamage();
            float damage2 = CombatRules.m_19272_((float)damage1, (float)player.m_21230_(), (float)((float)player.m_21133_(Attributes.f_22285_)));
            player.m_6469_(DamageSource.f_19318_, damage2);
            return;
        }
        stack.m_41622_((int)(armorPiercingFactor * damage), (LivingEntity)player, p_40992_ -> p_40992_.m_21166_(EquipmentSlot.MAINHAND));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return MedievalShieldItem.this.renderer;
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("blocking"), (p_174590_, p_174591_, p_174592_, p_174593_) -> p_174592_ != null && p_174592_.m_6117_() && p_174592_.m_21211_() == p_174590_ ? 1.0f : 0.0f);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction entity) {
        return true;
    }
}

