/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.magistuarmory.effects.LacerationEffect;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.ModItemTier;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;

public class MedievalWeaponItem
extends SwordItem
implements IHasModelProperty {
    protected float f_43266_;
    private float attackSpeed;
    protected float currentAttackDamage;
    private float currentAttackSpeed;
    private float decreasedAttackDamage;
    private float decreasedAttackSpeed;
    private boolean isSilver = false;
    private boolean isFlamebladed = false;
    protected int armorPiercing = 0;
    private float reachDistance = 0.0f;
    protected int twoHanded = 0;
    private float maxBlockDamage = 0.0f;
    private float weight = 1.0f;
    private boolean canBlock = false;
    private boolean blockingPriority = false;

    public MedievalWeaponItem(String unlocName, Item.Properties build, Tier material, float baseAttackDamage, float materialFactor, float baseAttackSpeed, int armorPiercing, float reachDistance) {
        this(unlocName, build, material, baseAttackDamage, materialFactor, baseAttackSpeed);
        this.armorPiercing = armorPiercing;
        this.reachDistance = reachDistance;
    }

    public MedievalWeaponItem(String unlocName, Item.Properties build, Tier material, float baseAttackDamage, float materialFactor, float baseAttackSpeed) {
        super(material, 0, 0.0f, build);
        this.setRegistryName(unlocName);
        this.f_43266_ = baseAttackDamage + materialFactor * material.m_6631_();
        this.attackSpeed = baseAttackSpeed;
        this.currentAttackDamage = this.f_43266_;
        this.currentAttackSpeed = this.attackSpeed;
        if (this.m_43314_().equals(ModItemTier.SILVER)) {
            this.isSilver = true;
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getAttackDamage(), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public boolean m_7579_(ItemStack p_77644_1_, LivingEntity p_77644_2_, LivingEntity p_77644_3_) {
        if (this.isSilver && p_77644_2_.m_6336_().equals(MobType.f_21641_)) {
            p_77644_2_.m_6469_(DamageSource.f_19319_, this.getAttackDamage() + 3.0f);
        }
        if (this.isFlamebladed && !(p_77644_2_ instanceof Creeper)) {
            float damage = CombatRules.m_19272_((float)this.f_43266_, (float)p_77644_2_.m_21230_(), (float)((float)p_77644_2_.m_21133_(Attributes.f_22285_)));
            p_77644_2_.m_7292_(new MobEffectInstance((MobEffect)LacerationEffect.LACERATION.setDamage(damage), 300, 1, true, true, true));
        }
        if (this.armorPiercing != 0 && p_77644_2_.m_21230_() > 0) {
            float piercedArmor = p_77644_2_.m_21230_() * (1 - this.armorPiercing / 100);
            float baseDamage = CombatRules.m_19272_((float)this.f_43266_, (float)p_77644_2_.m_21230_(), (float)((float)p_77644_2_.m_21133_(Attributes.f_22285_)));
            float totalDamage = (float)((double)this.f_43266_ * (1.0 - Math.min(20.0, Math.max((double)(piercedArmor / 5.0f), (double)piercedArmor - (double)this.f_43266_ / (p_77644_2_.m_21133_(Attributes.f_22285_) / 4.0 + 2.0))) / 25.0));
            float bonusDamage = totalDamage - baseDamage;
            p_77644_2_.m_6469_(DamageSource.m_19370_((LivingEntity)p_77644_3_).m_19380_(), bonusDamage);
        }
        return super.m_7579_(p_77644_1_, p_77644_2_, p_77644_3_);
    }

    public void m_6883_(ItemStack par1ItemStack, Level world, Entity entityIn, int par4, boolean par5) {
        boolean flag = false;
        if (this.twoHanded > 0 && entityIn instanceof LivingEntity && !((LivingEntity)entityIn).m_21206_().m_41720_().equals(Items.f_41852_)) {
            if (this.currentAttackDamage != this.decreasedAttackDamage) {
                this.currentAttackDamage = this.decreasedAttackDamage;
                flag = true;
            }
            if (this.currentAttackDamage != this.decreasedAttackSpeed) {
                this.currentAttackSpeed = this.decreasedAttackSpeed;
                flag = true;
            }
        } else {
            if (this.currentAttackDamage != this.f_43266_) {
                this.currentAttackDamage = this.f_43266_;
                flag = true;
            }
            if (this.currentAttackDamage != this.attackSpeed) {
                this.currentAttackSpeed = this.attackSpeed;
                flag = true;
            }
        }
        if (flag) {
            ItemStack itemstack = ((LivingEntity)entityIn).m_21205_();
            for (EquipmentSlot entityequipmentslot : EquipmentSlot.values()) {
                ((LivingEntity)entityIn).m_21204_().m_22161_(itemstack.m_41638_(entityequipmentslot));
                ((LivingEntity)entityIn).m_21204_().m_22178_(itemstack.m_41638_(entityequipmentslot));
            }
        }
        if (this.canBlock() && entityIn instanceof LivingEntity) {
            this.blockingPriority = !(((LivingEntity)entityIn).m_21205_().m_41720_() instanceof ShieldItem) && !(((LivingEntity)entityIn).m_21206_().m_41720_() instanceof ShieldItem);
        }
        super.m_6883_(par1ItemStack, world, entityIn, par4, par5);
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        if (this.isSilver) {
            p_41423_.add((Component)new TextComponent("+2 damage against undead").m_130940_(ChatFormatting.GREEN));
        }
        if (this.isFlamebladed) {
            p_41423_.add((Component)new TextComponent("Inflicts non-healing wounds").m_130940_(ChatFormatting.BLUE));
        }
        if (this.armorPiercing != 0) {
            p_41423_.add((Component)new TextComponent(this.armorPiercing + "% armor piercing").m_130940_(ChatFormatting.BLUE));
        }
        if (this.reachDistance != 0.0f) {
            p_41423_.add((Component)new TextComponent("+" + this.reachDistance + " reach distance").m_130940_(ChatFormatting.BLUE));
        }
        if (this.twoHanded == 1) {
            p_41423_.add((Component)new TextComponent("Two-Handed I").m_130940_(ChatFormatting.BLUE));
        } else if (this.twoHanded > 1) {
            p_41423_.add((Component)new TextComponent("Two-Handed II").m_130940_(ChatFormatting.BLUE));
        }
        if (this.canBlock()) {
            p_41423_.add((Component)new TextComponent(this.getMaxBlockDamage() + " max damage block").m_130940_(ChatFormatting.BLUE));
        }
        p_41423_.add((Component)new TextComponent(this.getWeight() + "kg weight").m_130940_(ChatFormatting.BLUE));
    }

    public MedievalWeaponItem setFlamebladed() {
        this.isFlamebladed = true;
        return this;
    }

    public MedievalWeaponItem setTwoHanded(int level) {
        this.twoHanded = level;
        this.decreasedAttackDamage = 12.0f * this.f_43266_ / (5.0f * (float)level + 10.0f);
        this.decreasedAttackSpeed = 14.0f * (this.attackSpeed + 4.0f) / (15.0f * (float)level + 5.0f) - 4.0f;
        return this;
    }

    public MedievalWeaponItem setBlocking(float weight, float maxBlockDamage) {
        this.weight = weight;
        this.maxBlockDamage = maxBlockDamage;
        this.canBlock = true;
        return this;
    }

    public float getAttackDamage() {
        return this.currentAttackDamage;
    }

    public float getAttackSpeed() {
        return this.currentAttackSpeed;
    }

    public float getReachDistance() {
        return this.reachDistance + 5.0f;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_77659_1_, Player p_77659_2_, InteractionHand p_77659_3_) {
        if (this.canBlock() && this.blockingPriority) {
            ItemStack itemstack = p_77659_2_.m_21120_(p_77659_3_);
            p_77659_2_.m_6672_(p_77659_3_);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return super.m_7203_(p_77659_1_, p_77659_2_, p_77659_3_);
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return this.canBlock() ? (int)(500.0f / this.getWeight()) : 0;
    }

    public UseAnim m_6164_(ItemStack p_77661_1_) {
        return this.canBlock() && this.blockingPriority ? UseAnim.BLOCK : super.m_6164_(p_77661_1_);
    }

    public void onBlocked(ItemStack stack, float damage, Player player, DamageSource source) {
        if (this.canBlock()) {
            LivingEntity attacker;
            float armorPiercingFactor = 1.0f;
            if (source.m_7639_() instanceof LivingEntity && (attacker = (LivingEntity)source.m_7639_()).m_21205_().m_41720_() instanceof MedievalWeaponItem) {
                armorPiercingFactor += (float)((MedievalWeaponItem)attacker.m_21205_().m_41720_()).armorPiercing / 100.0f;
            }
            if (source.m_19372_()) {
                player.m_6469_(DamageSource.f_19318_, damage);
                return;
            }
            if (!this.haveBlocked(new Random(), source)) {
                float damage2 = CombatRules.m_19272_((float)damage, (float)player.m_21230_(), (float)((float)player.m_21133_(Attributes.f_22285_)));
                player.m_6469_(DamageSource.f_19318_, damage2);
                return;
            }
            if (damage > this.getMaxBlockDamage()) {
                stack.m_41622_((int)(armorPiercingFactor * 0.2f * (float)stack.m_41776_()), (LivingEntity)player, p_220044_0_ -> p_220044_0_.m_21166_(EquipmentSlot.MAINHAND));
                float damage1 = damage - this.getMaxBlockDamage();
                float damage2 = CombatRules.m_19272_((float)damage1, (float)player.m_21230_(), (float)((float)player.m_21133_(Attributes.f_22285_)));
                player.m_6469_(DamageSource.f_19318_, damage2);
                return;
            }
            stack.m_41622_((int)(armorPiercingFactor * damage), (LivingEntity)player, p_220044_0_ -> p_220044_0_.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    public float getMaxBlockDamage() {
        return this.maxBlockDamage;
    }

    public float getWeight() {
        return this.weight;
    }

    public boolean canBlock() {
        return this.canBlock;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModelProperty() {
        if (this.canBlock()) {
            ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("blocking"), (p_174590_, p_174591_, p_174592_, p_174593_) -> p_174592_ != null && p_174592_.m_6117_() && p_174592_.m_21211_() == p_174590_ ? 1.0f : 0.0f);
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction entity) {
        return this.canBlock();
    }

    boolean haveBlocked(Random rand, DamageSource source) {
        return !source.m_19360_() && (float)rand.nextInt(14) > this.getWeight();
    }
}

