/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.network;

import com.magistuarmory.item.LanceItem;
import io.netty.channel.ChannelHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

@ChannelHandler.Sharable
public class PacketLanceCollision {
    private int entityId;
    private int bonusDamage;

    public PacketLanceCollision(int entityId, int bonusDamage) {
        this.entityId = entityId;
        this.bonusDamage = bonusDamage;
    }

    public static PacketLanceCollision read(FriendlyByteBuf buf) {
        return new PacketLanceCollision(buf.readInt(), buf.readInt());
    }

    public static void write(PacketLanceCollision message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.writeInt(message.bonusDamage);
    }

    public static void handleServerSide(PacketLanceCollision message, ServerPlayer player) {
        if (message == null || player == null) {
            return;
        }
        Entity victim = player.f_19853_.m_6815_(message.entityId);
        if (!(victim instanceof LivingEntity)) {
            return;
        }
        ItemStack weapon = player.m_6844_(EquipmentSlot.MAINHAND);
        if (weapon.m_41619_()) {
            return;
        }
        if (weapon.m_41720_() instanceof LanceItem) {
            if (weapon.m_41773_() >= weapon.m_41776_() - 1) {
                ((LanceItem)weapon.m_41720_()).onBroken((Player)player);
            } else if (!player.m_7500_() && ((LivingEntity)victim).m_21230_() >= 18) {
                weapon.m_41721_(weapon.m_41773_() + (int)((0.6 + (double)(message.bonusDamage / 20)) * Math.random() * (double)weapon.m_41776_()));
            }
            ((LanceItem)weapon.m_41720_()).attacking = true;
            player.m_5706_(victim);
            victim.m_6469_(DamageSource.f_19318_, ((LanceItem)weapon.m_41720_()).getAttackDamage() + (float)message.bonusDamage);
            if (weapon.m_41720_() instanceof LanceItem) {
                ((LanceItem)weapon.m_41720_()).attacking = false;
            }
            for (ItemStack itemStack : player.m_150109_().f_35974_) {
                ((LanceItem)weapon.m_41720_()).setRaised((LivingEntity)player, true);
                player.m_36335_().m_41524_(itemStack.m_41720_(), (int)(40.0f / (4.0f + ((LanceItem)weapon.m_41720_()).getAttackSpeed())));
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            if (weapon.m_41773_() >= weapon.m_41776_()) {
                ((LanceItem)weapon.m_41720_()).onBroken((Player)player);
                weapon.m_41764_(0);
            }
        }
    }

    public static class Handler {
        public static void handle(PacketLanceCollision packet, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
                context.enqueueWork(() -> PacketLanceCollision.handleServerSide(packet, context.getSender()));
            }
            context.setPacketHandled(true);
        }
    }
}

