/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.network;

import com.magistuarmory.item.MedievalWeaponItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PacketLongReachAttack {
    private int entityId;

    public PacketLongReachAttack(int entityId) {
        this.entityId = entityId;
    }

    public static PacketLongReachAttack read(FriendlyByteBuf buf) {
        return new PacketLongReachAttack(buf.readInt());
    }

    public static void write(PacketLongReachAttack message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
    }

    public static void handleServerSide(PacketLongReachAttack message, ServerPlayer player) {
        if (message == null || player == null) {
            return;
        }
        Entity victim = player.f_19853_.m_6815_(message.entityId);
        if (victim == null) {
            return;
        }
        ItemStack weapon = player.m_6844_(EquipmentSlot.MAINHAND);
        if (weapon.m_41619_()) {
            return;
        }
        if (weapon.m_41720_() instanceof MedievalWeaponItem) {
            double distanceSquared;
            double reachSquared;
            float reachDistance = ((MedievalWeaponItem)weapon.m_41720_()).getReachDistance();
            if (reachDistance > 5.0f && (reachSquared = (double)(reachDistance * reachDistance)) >= (distanceSquared = player.m_20280_(victim))) {
                player.m_5706_(victim);
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            player.m_36334_();
        }
    }

    public static void handleClientSide(PacketLongReachAttack message, Player paramPlayer) {
    }

    public static class Handler {
        public static void handle(PacketLongReachAttack message, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
                context.enqueueWork(() -> PacketLongReachAttack.handleServerSide(message, context.getSender()));
            }
            context.setPacketHandled(true);
        }
    }
}

