/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.config;

import fr.raksrinana.fallingtree.fabric.config.AdjacentStopMode;
import fr.raksrinana.fallingtree.fabric.config.BreakMode;
import fr.raksrinana.fallingtree.fabric.config.BreakOrder;
import fr.raksrinana.fallingtree.fabric.config.ConfigCache;
import fr.raksrinana.fallingtree.fabric.config.DetectionMode;
import fr.raksrinana.fallingtree.fabric.config.MaxSizeAction;
import fr.raksrinana.fallingtree.fabric.config.validator.BlockId;
import fr.raksrinana.fallingtree.fabric.config.validator.Min;
import fr.raksrinana.fallingtree.fabric.config.validator.MinMax;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_2248;

public class TreeConfiguration {
    @ConfigEntry.Gui.Tooltip(count=5)
    @Comment(value="Additional list of blocks considered as logs and that will be destroyed by the mod. \nINFO: Blocks marked with the log tag will already be whitelisted.")
    @BlockId
    public List<String> whitelistedLogs = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=3)
    @Comment(value="List of blocks that should not be considered as logs. \nINFO: This wins over the whitelist.")
    @BlockId
    public List<String> blacklistedLogs = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=5)
    @Comment(value="Additional list of blocks considered as leaves (decay naturally). \nINFO: Blocks marked with the leaves tag will already be whitelisted.")
    @BlockId
    public List<String> whitelistedLeaves = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="Additional list of blocks considered as leaves but that doesn't decay (need to be broken by tool).")
    @BlockId
    public List<String> whitelistedNonDecayLeaves = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=3)
    @Comment(value="List of blocks that should not be considered as leaves. \nINFO: This wins over the whitelist.")
    @BlockId
    public List<String> blacklistedLeaves = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=7)
    @Comment(value="How to break the tree. \nINSTANTANEOUS will break it in one go. \nSHIFT_DOWN will make the tree fall down as you cut it, so you still have to break x blocks but don't have to climb the tree for them.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public BreakMode breakMode = BreakMode.INSTANTANEOUS;
    @ConfigEntry.Gui.Tooltip(count=9)
    @Comment(value="What part of the tree should be cut. \nWHOLE_TREE will break the whole tree. \nABOVE_CUT will break only blocks that are connected from above the cut point. \nABOVE_Y will break only blocks that are above the y value of the cut point.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public DetectionMode detectionMode = DetectionMode.WHOLE_TREE;
    @ConfigEntry.Gui.Tooltip(count=3)
    @Comment(value="The maximum number of blocks to scan when trying to detect a tree. If there's more than this value the tree won't be cut.")
    @Min(value=1)
    public int maxScanSize = 500;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="The maximum size of a tree. If there's more logs than this value the max size action will be applied.")
    @Min(value=1)
    public int maxSize = 100;
    @ConfigEntry.Gui.Tooltip(count=4)
    @Comment(value="What to do when the max size of a tree is reached. \nABORT: Tree won't be cut. \nCUT: Tree will still be cut leaving some of it untouched.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public MaxSizeAction maxSizeAction = MaxSizeAction.ABORT;
    @ConfigEntry.Gui.Tooltip(count=6)
    @Comment(value="In what order logs are broken. \nThis only makes sense if maxSize < maxScanSize. \nFURTHEST_FIRST: The furthest log will be broken first. \nCLOSEST_FIRST: The closest log will be broken first. \nINFO: Only in INSTANTANEOUS mode.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public BreakOrder breakOrder = BreakOrder.FURTHEST_FIRST;
    @ConfigEntry.Gui.Tooltip(count=4)
    @Comment(value="The minimum amount of leaves that needs to be around the top most log in order for the mod to consider it a tree.\nINFO: Only in INSTANTANEOUS mode.")
    @MinMax(min=0, max=5)
    public int minimumLeavesAroundRequired = 1;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="When set to true, the mod be applied when cutting trunks.")
    public boolean treeBreaking = true;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true, leaves that should naturally break will be broken instantly.")
    public boolean leavesBreaking = true;
    @ConfigEntry.Gui.Tooltip(count=8)
    @Comment(value="Radius to force break leaves. If another tree is still holding the leaves they'll still be broken. If the leaves are persistent (placed by player) they'll also be destroyed. \nThe radius is applied from one of the top most log blocks. \nINFO: break_leaves must be activated for this to take effect. \nINFO: Only in INSTANTANEOUS mode.")
    @MinMax(min=0, max=10)
    public int leavesBreakingForceRadius = 0;
    @ConfigEntry.Gui.Tooltip(count=4)
    @Comment(value="When set to true this allow to have any kind of log in a tree trunk. \nOtherwise (false) the trunk will be considered as being only one kind of log.")
    public boolean allowMixedLogs = false;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true nether tree warts (leaves) will be broken along with the trunk.")
    public boolean breakNetherTreeWarts = true;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true nether tree warts (leaves) will be broken with only one hit. \nINFO: Only in SHIFT_DOWN mode.")
    public boolean instantlyBreakWarts = false;
    @ConfigEntry.Gui.Tooltip(count=5)
    @Comment(value="This defines the area in which the tree is searched. If any branch is going out of this area it won't be cut. \nThis value is the radius of the area. \ni.e. Setting a value of 2 will result on an area of 3x3 centered on the log broken. \nIf this value is set to a negative number then no area restriction will be applied.")
    public int searchAreaRadius = -1;
    @ConfigEntry.Gui.Tooltip(count=9)
    @Comment(value="List the blocks that can be against the tree. If something else is adjacent then the tree won't be cut. \nINFO: Use adjacentStopMode to define how we stop the search for the tree.")
    @BlockId
    public List<String> whitelistedAdjacentBlocks = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=9)
    @Comment(value="What to do when an non whitelisted adjacent block is found. \nSTOP_ALL will stop the search and nothing will be cut. \nSTOP_BRANCH will stop the current branch only. The rest of the tree will be cut.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public AdjacentStopMode adjacentStopMode = AdjacentStopMode.STOP_ALL;

    public Collection<class_2248> getBlacklistedLeaveBlocks() {
        return ConfigCache.getInstance().getBlacklistedLeaves(this::getBlacklistedLeaves);
    }

    public Collection<class_2248> getBlacklistedLogBlocks() {
        return ConfigCache.getInstance().getBlacklistedLogs(this::getBlacklistedLogs);
    }

    public Collection<class_2248> getWhitelistedLeaveBlocks() {
        return ConfigCache.getInstance().getWhitelistedLeaves(this::getWhitelistedLeaves);
    }

    public Collection<class_2248> getWhitelistedNonDecayLeaveBlocks() {
        return ConfigCache.getInstance().getWhitelistedNonDecayLeaves(this::getWhitelistedNonDecayLeaves);
    }

    public Collection<class_2248> getWhitelistedAdjacentBlockBLocks() {
        return ConfigCache.getInstance().getWhitelistedAdjacentBlocks(this::getWhitelistedAdjacentBlocks);
    }

    public Collection<class_2248> getWhitelistedLogBlocks() {
        return ConfigCache.getInstance().getWhitelistedLogs(this::getWhitelistedLogs);
    }

    public List<String> getWhitelistedLogs() {
        return this.whitelistedLogs;
    }

    public List<String> getBlacklistedLogs() {
        return this.blacklistedLogs;
    }

    public List<String> getWhitelistedLeaves() {
        return this.whitelistedLeaves;
    }

    public List<String> getWhitelistedNonDecayLeaves() {
        return this.whitelistedNonDecayLeaves;
    }

    public List<String> getBlacklistedLeaves() {
        return this.blacklistedLeaves;
    }

    public BreakMode getBreakMode() {
        return this.breakMode;
    }

    public DetectionMode getDetectionMode() {
        return this.detectionMode;
    }

    public int getMaxScanSize() {
        return this.maxScanSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public MaxSizeAction getMaxSizeAction() {
        return this.maxSizeAction;
    }

    public BreakOrder getBreakOrder() {
        return this.breakOrder;
    }

    public int getMinimumLeavesAroundRequired() {
        return this.minimumLeavesAroundRequired;
    }

    public boolean isTreeBreaking() {
        return this.treeBreaking;
    }

    public boolean isLeavesBreaking() {
        return this.leavesBreaking;
    }

    public int getLeavesBreakingForceRadius() {
        return this.leavesBreakingForceRadius;
    }

    public boolean isAllowMixedLogs() {
        return this.allowMixedLogs;
    }

    public boolean isBreakNetherTreeWarts() {
        return this.breakNetherTreeWarts;
    }

    public boolean isInstantlyBreakWarts() {
        return this.instantlyBreakWarts;
    }

    public int getSearchAreaRadius() {
        return this.searchAreaRadius;
    }

    public List<String> getWhitelistedAdjacentBlocks() {
        return this.whitelistedAdjacentBlocks;
    }

    public AdjacentStopMode getAdjacentStopMode() {
        return this.adjacentStopMode;
    }
}

