/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.config;

import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.utils.FallingTreeUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConfigCache {
    private static ConfigCache INSTANCE;
    private Set<Item> toolsBlacklist;
    private Set<Item> toolsWhitelist;
    private Set<Block> leavesBlacklist;
    private Set<Block> logsBlacklist;
    private Set<Block> leavesWhitelist;
    private Set<Block> leavesNonDecayWhitelist;
    private Set<Block> logsWhitelist;
    private Set<Block> adjacentBlocksWhitelist;
    private Set<Block> adjacentBlocksBase;
    private Set<Block> defaultLogs;

    public void invalidate() {
        this.toolsBlacklist = null;
        this.toolsWhitelist = null;
        this.leavesBlacklist = null;
        this.leavesWhitelist = null;
        this.leavesNonDecayWhitelist = null;
        this.logsBlacklist = null;
        this.logsWhitelist = null;
        this.adjacentBlocksWhitelist = null;
        this.adjacentBlocksBase = null;
        this.defaultLogs = null;
    }

    public Collection<Item> getToolsWhitelisted(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.toolsWhitelist)) {
            this.toolsWhitelist = FallingTreeUtils.getAsItems(collectionSupplier.get());
        }
        return this.toolsWhitelist;
    }

    public Collection<Item> getToolsBlacklisted(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.toolsBlacklist)) {
            this.toolsBlacklist = FallingTreeUtils.getAsItems(collectionSupplier.get());
        }
        return this.toolsBlacklist;
    }

    public Collection<Block> getBlacklistedLeaves(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.leavesBlacklist)) {
            this.leavesBlacklist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.leavesBlacklist;
    }

    public Collection<Block> getBlacklistedLogs(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.logsBlacklist)) {
            this.logsBlacklist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.logsBlacklist;
    }

    public Collection<Block> getWhitelistedLeaves(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.leavesWhitelist)) {
            this.leavesWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.leavesWhitelist;
    }

    public Collection<Block> getWhitelistedAdjacentBlocks(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.adjacentBlocksWhitelist)) {
            this.adjacentBlocksWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.adjacentBlocksWhitelist;
    }

    public Collection<Block> getDefaultLogs() {
        if (Objects.isNull(this.defaultLogs)) {
            this.defaultLogs = BlockTags.f_13106_.m_6497_().stream().filter(block -> Optional.ofNullable(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block)).map(ResourceLocation::m_135815_).map(name -> name.startsWith("stripped")).orElse(false) == false).collect(Collectors.toSet());
        }
        return this.defaultLogs;
    }

    public Collection<Block> getAdjacentBlocksBase() {
        if (Objects.isNull(this.adjacentBlocksBase)) {
            this.adjacentBlocksBase = new HashSet<Block>();
            this.adjacentBlocksBase.add(Blocks.f_50016_);
            this.adjacentBlocksBase.addAll(BlockTags.f_13035_.m_6497_());
            this.adjacentBlocksBase.addAll(this.getDefaultLogs());
            this.adjacentBlocksBase.addAll(this.getWhitelistedLogs(Config.COMMON.getTrees()::getWhitelistedLogs));
            this.adjacentBlocksBase.addAll(this.getWhitelistedLeaves(Config.COMMON.getTrees()::getWhitelistedLeaves));
            this.adjacentBlocksBase.addAll(this.getWhitelistedNonDecayLeaves(Config.COMMON.getTrees()::getWhitelistedNonDecayLeaves));
            this.adjacentBlocksBase.removeAll(this.getBlacklistedLogs(Config.COMMON.getTrees()::getBlacklistedLogs));
            this.adjacentBlocksBase.removeAll(this.getBlacklistedLeaves(Config.COMMON.getTrees()::getBlacklistedLeaves));
        }
        return this.adjacentBlocksBase;
    }

    public Collection<Block> getWhitelistedLogs(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.logsWhitelist)) {
            this.logsWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.logsWhitelist;
    }

    public Collection<Block> getWhitelistedNonDecayLeaves(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.leavesNonDecayWhitelist)) {
            this.leavesNonDecayWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.leavesNonDecayWhitelist;
    }

    public static ConfigCache getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new ConfigCache();
        }
        return INSTANCE;
    }
}

