/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.config.cloth;

import com.google.common.collect.Lists;
import fr.raksrinana.fallingtree.forge.config.AdjacentStopMode;
import fr.raksrinana.fallingtree.forge.config.BreakMode;
import fr.raksrinana.fallingtree.forge.config.BreakOrder;
import fr.raksrinana.fallingtree.forge.config.CommonConfig;
import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.config.ConfigCache;
import fr.raksrinana.fallingtree.forge.config.DamageRounding;
import fr.raksrinana.fallingtree.forge.config.DetectionMode;
import fr.raksrinana.fallingtree.forge.config.MaxSizeAction;
import fr.raksrinana.fallingtree.forge.config.NotificationMode;
import fr.raksrinana.fallingtree.forge.config.ToolConfiguration;
import fr.raksrinana.fallingtree.forge.config.TreeConfiguration;
import java.lang.invoke.CallSite;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fmlclient.ConfigGuiHandler;

public class ClothConfigHook {
    private static final Pattern MINECRAFT_ID_PATTERN = Pattern.compile("#?[a-z0-9_.-]+:[a-z0-9/._-]+");

    public void load() {
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((minecraft, screen) -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle((Component)new TextComponent("FallingTree"));
            this.fillConfigScreen(builder);
            builder.setSavingRunnable(() -> ConfigCache.getInstance().invalidate());
            return builder.build();
        }));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigScreen(ConfigBuilder builder) {
        CommonConfig config = Config.COMMON;
        BooleanListEntry reverseSneakingEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName(null, "reverseSneaking")), config.isReverseSneaking()).setDefaultValue(false).setTooltip(this.getTooltips(null, "reverseSneaking", 2)).setSaveConsumer(config::setReverseSneaking).build();
        BooleanListEntry breakInCreativeEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName(null, "breakInCreative")), config.isBreakInCreative()).setDefaultValue(false).setTooltip(this.getTooltips(null, "breakInCreative", 2)).setSaveConsumer(config::setBreakInCreative).build();
        EnumListEntry notificationModeEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName(null, "notificationMode")), NotificationMode.class, (Enum)config.getNotificationMode()).setDefaultValue((Enum)NotificationMode.ACTION_BAR).setTooltip(this.getTooltips(null, "notificationMode", 5)).setSaveConsumer(config::setNotificationMode).build();
        ConfigCategory general = builder.getOrCreateCategory((Component)new TranslatableComponent("text.autoconfig.fallingtree.category.default"));
        general.addEntry((AbstractConfigListEntry)reverseSneakingEntry);
        general.addEntry((AbstractConfigListEntry)breakInCreativeEntry);
        general.addEntry((AbstractConfigListEntry)notificationModeEntry);
        this.fillTreesConfigScreen(builder);
        this.fillToolsConfigScreen(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void fillTreesConfigScreen(ConfigBuilder builder) {
        TreeConfiguration config = Config.COMMON.getTrees();
        EnumListEntry breakModeEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("trees", "breakMode")), BreakMode.class, (Enum)config.getBreakMode()).setDefaultValue((Enum)BreakMode.INSTANTANEOUS).setTooltip(this.getTooltips("trees", "breakMode", 7)).setSaveConsumer(config::setBreakMode).build();
        EnumListEntry detectionModeEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("trees", "detectionMode")), DetectionMode.class, (Enum)config.getDetectionMode()).setDefaultValue((Enum)DetectionMode.WHOLE_TREE).setTooltip(this.getTooltips("trees", "detectionMode", 9)).setSaveConsumer(config::setDetectionMode).build();
        StringListListEntry whitelistedLogsEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "whitelistedLogs")), config.getWhitelistedLogs()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "whitelistedLogs", 5)).setSaveConsumer(config::setWhitelistedLogs).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        StringListListEntry blacklistedLogsEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "blacklistedLogs")), config.getBlacklistedLogs()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "blacklistedLogs", 3)).setSaveConsumer(config::setBlacklistedLogs).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        StringListListEntry whitelistedLeavesEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "whitelistedLeaves")), config.getWhitelistedLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "whitelistedLeaves", 5)).setSaveConsumer(config::setWhitelistedLeaves).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        StringListListEntry whitelistedNonDecayLeavesEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "whitelistedNonDecayLeaves")), config.getWhitelistedNonDecayLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "whitelistedNonDecayLeaves", 2)).setSaveConsumer(config::setWhitelistedNonDecayLeaves).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        StringListListEntry blacklistedLeavesEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "blacklistedLeaves")), config.getBlacklistedLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "blacklistedLeaves", 3)).setSaveConsumer(config::setBlacklistedLeaves).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        IntegerListEntry maxScanSizeEntry = builder.entryBuilder().startIntField((Component)new TranslatableComponent(this.getFieldName("trees", "maxScanSize")), config.getMaxScanSize()).setDefaultValue(500).setMin(1).setTooltip(this.getTooltips("trees", "maxScanSize", 3)).setSaveConsumer(config::setMaxScanSize).build();
        IntegerListEntry maxSizeEntry = builder.entryBuilder().startIntField((Component)new TranslatableComponent(this.getFieldName("trees", "maxSize")), config.getMaxSize()).setDefaultValue(100).setMin(1).setTooltip(this.getTooltips("trees", "maxSize", 2)).setSaveConsumer(config::setMaxSize).build();
        EnumListEntry maxSizeActionEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("trees", "maxSizeAction")), MaxSizeAction.class, (Enum)config.getMaxSizeAction()).setDefaultValue((Enum)MaxSizeAction.ABORT).setTooltip(this.getTooltips("trees", "maxSizeAction", 4)).setSaveConsumer(config::setMaxSizeAction).build();
        EnumListEntry breakOrderEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("trees", "breakOrder")), BreakOrder.class, (Enum)config.getBreakOrder()).setDefaultValue((Enum)BreakOrder.FURTHEST_FIRST).setTooltip(this.getTooltips("trees", "breakOrder", 4)).setSaveConsumer(config::setBreakOrder).build();
        BooleanListEntry treeBreakingEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "treeBreaking")), config.isTreeBreaking()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "treeBreaking", 1)).setSaveConsumer(config::setTreeBreaking).build();
        BooleanListEntry leavesBreakingEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "leavesBreaking")), config.isLeavesBreaking()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "leavesBreaking", 2)).setSaveConsumer(config::setLeavesBreaking).build();
        IntegerListEntry leavesBreakingForceRadiusEntry = builder.entryBuilder().startIntField((Component)new TranslatableComponent(this.getFieldName("trees", "leavesBreakingForceRadius")), config.getLeavesBreakingForceRadius()).setDefaultValue(0).setMin(0).setMax(10).setTooltip(this.getTooltips("trees", "leavesBreakingForceRadius", 8)).setSaveConsumer(config::setLeavesBreakingForceRadius).build();
        IntegerListEntry minimumLeavesAroundRequiredEntry = builder.entryBuilder().startIntField((Component)new TranslatableComponent(this.getFieldName("trees", "minimumLeavesAroundRequired")), config.getMinimumLeavesAroundRequired()).setDefaultValue(1).setMin(0).setMax(5).setTooltip(this.getTooltips("trees", "minimumLeavesAroundRequired", 4)).setSaveConsumer(config::setMinimumLeavesAroundRequired).build();
        BooleanListEntry allowMixedLogsEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "allowMixedLogs")), config.isAllowMixedLogs()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "allowMixedLogs", 4)).setSaveConsumer(config::setAllowMixedLogs).build();
        BooleanListEntry breakNetherTreeWartsEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "breakNetherTreeWarts")), config.isBreakNetherTreeWarts()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "breakNetherTreeWarts", 2)).setSaveConsumer(config::setBreakNetherTreeWarts).build();
        BooleanListEntry instantlyBreakWartsEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "instantlyBreakWarts")), config.isInstantlyBreakWarts()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "instantlyBreakWarts", 2)).setSaveConsumer(config::setInstantlyBreakWarts).build();
        IntegerListEntry searchAreaRadiusEntry = builder.entryBuilder().startIntField((Component)new TranslatableComponent(this.getFieldName("trees", "searchAreaRadius")), config.getSearchAreaRadius()).setDefaultValue(-1).setTooltip(this.getTooltips("trees", "searchAreaRadius", 5)).setSaveConsumer(config::setSearchAreaRadius).build();
        StringListListEntry whitelistedAdjacentBlocks = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "whitelistedAdjacentBlocks")), config.getWhitelistedAdjacentBlocks()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "whitelistedAdjacentBlocks", 9)).setSaveConsumer(config::setWhitelistedAdjacentBlocks).setCellErrorSupplier(ClothConfigHook.getMinecraftBlockIdCellError()).build();
        EnumListEntry adjacentStopModeEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("trees", "adjacentStopMode")), AdjacentStopMode.class, (Enum)config.getAdjacentStopMode()).setDefaultValue((Enum)AdjacentStopMode.STOP_ALL).setTooltip(this.getTooltips("trees", "adjacentStopMode", 9)).setSaveConsumer(config::setAdjacentStopMode).build();
        ConfigCategory tools = builder.getOrCreateCategory((Component)new TranslatableComponent("text.autoconfig.fallingtree.category.trees"));
        tools.addEntry((AbstractConfigListEntry)breakModeEntry);
        tools.addEntry((AbstractConfigListEntry)detectionModeEntry);
        tools.addEntry((AbstractConfigListEntry)whitelistedLogsEntry);
        tools.addEntry((AbstractConfigListEntry)blacklistedLogsEntry);
        tools.addEntry((AbstractConfigListEntry)whitelistedLeavesEntry);
        tools.addEntry((AbstractConfigListEntry)whitelistedNonDecayLeavesEntry);
        tools.addEntry((AbstractConfigListEntry)blacklistedLeavesEntry);
        tools.addEntry((AbstractConfigListEntry)maxScanSizeEntry);
        tools.addEntry((AbstractConfigListEntry)maxSizeEntry);
        tools.addEntry((AbstractConfigListEntry)maxSizeActionEntry);
        tools.addEntry((AbstractConfigListEntry)breakOrderEntry);
        tools.addEntry((AbstractConfigListEntry)treeBreakingEntry);
        tools.addEntry((AbstractConfigListEntry)leavesBreakingEntry);
        tools.addEntry((AbstractConfigListEntry)leavesBreakingForceRadiusEntry);
        tools.addEntry((AbstractConfigListEntry)minimumLeavesAroundRequiredEntry);
        tools.addEntry((AbstractConfigListEntry)allowMixedLogsEntry);
        tools.addEntry((AbstractConfigListEntry)breakNetherTreeWartsEntry);
        tools.addEntry((AbstractConfigListEntry)instantlyBreakWartsEntry);
        tools.addEntry((AbstractConfigListEntry)searchAreaRadiusEntry);
        tools.addEntry((AbstractConfigListEntry)whitelistedAdjacentBlocks);
        tools.addEntry((AbstractConfigListEntry)adjacentStopModeEntry);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void fillToolsConfigScreen(ConfigBuilder builder) {
        ToolConfiguration config = Config.COMMON.getTools();
        BooleanListEntry ignoreToolsEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("tools", "ignoreTools")), config.isIgnoreTools()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "ignoreTools", 4)).setSaveConsumer(config::setIgnoreTools).build();
        StringListListEntry whitelistedEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("tools", "whitelisted")), config.getWhitelisted()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("tools", "whitelisted", 3)).setSaveConsumer(config::setWhitelisted).setCellErrorSupplier(ClothConfigHook.getMinecraftItemIdCellError()).build();
        StringListListEntry blacklistedEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("tools", "blacklisted")), config.getBlacklisted()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("tools", "blacklisted", 3)).setSaveConsumer(config::setBlacklisted).setCellErrorSupplier(ClothConfigHook.getMinecraftItemIdCellError()).build();
        DoubleListEntry damageMultiplicandEntry = builder.entryBuilder().startDoubleField((Component)new TranslatableComponent(this.getFieldName("tools", "damageMultiplicand")), config.getDamageMultiplicand()).setDefaultValue(1.0).setMin(0.0).setMax(100.0).setTooltip(this.getTooltips("tools", "damageMultiplicand", 7)).setSaveConsumer(config::setDamageMultiplicand).build();
        EnumListEntry damageRoundingEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("tools", "damageRounding")), DamageRounding.class, (Enum)config.getDamageRounding()).setDefaultValue((Enum)DamageRounding.ROUND_DOWN).setTooltip(this.getTooltips("tools", "damageRounding", 8)).setSaveConsumer(config::setDamageRounding).build();
        DoubleListEntry speedMultiplicandEntry = builder.entryBuilder().startDoubleField((Component)new TranslatableComponent(this.getFieldName("tools", "speedMultiplicand")), config.getSpeedMultiplicand()).setDefaultValue(0.0).setMin(0.0).setMax(50.0).setTooltip(this.getTooltips("tools", "speedMultiplicand", 15)).setSaveConsumer(config::setSpeedMultiplicand).build();
        BooleanListEntry preserveEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("tools", "preserve")), config.isPreserve()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "preserve", 3)).setSaveConsumer(config::setPreserve).build();
        ConfigCategory tools = builder.getOrCreateCategory((Component)new TranslatableComponent("text.autoconfig.fallingtree.category.tools"));
        tools.addEntry((AbstractConfigListEntry)ignoreToolsEntry);
        tools.addEntry((AbstractConfigListEntry)whitelistedEntry);
        tools.addEntry((AbstractConfigListEntry)blacklistedEntry);
        tools.addEntry((AbstractConfigListEntry)damageMultiplicandEntry);
        tools.addEntry((AbstractConfigListEntry)damageRoundingEntry);
        tools.addEntry((AbstractConfigListEntry)speedMultiplicandEntry);
        tools.addEntry((AbstractConfigListEntry)preserveEntry);
    }

    private String getFieldName(String category, String fieldName) {
        return Optional.ofNullable(category).filter(c -> !c.isBlank()).map(c -> "text.autoconfig.fallingtree.option." + c + "." + fieldName).orElseGet(() -> "text.autoconfig.fallingtree.option." + fieldName);
    }

    private Component[] getTooltips(String category, String fieldName, int count) {
        String tooltipKey = this.getFieldName(category, fieldName) + ".@Tooltip";
        LinkedList<CallSite> keys = new LinkedList<CallSite>();
        if (count <= 1) {
            keys.add((CallSite)((Object)tooltipKey));
        } else {
            for (int i = 0; i < count; ++i) {
                keys.add((CallSite)((Object)(tooltipKey + "[" + i + "]")));
            }
        }
        return (Component[])keys.stream().map(TranslatableComponent::new).toArray(Component[]::new);
    }

    public static Function<String, Optional<Component>> getMinecraftBlockIdCellError() {
        return value -> Optional.ofNullable(value).map(v -> MINECRAFT_ID_PATTERN.matcher((CharSequence)v).matches()).filter(v -> v == false).map(v -> new TranslatableComponent("text.autoconfig.fallingtree.error.invalidBlockResourceLocation"));
    }

    public static Function<String, Optional<Component>> getMinecraftItemIdCellError() {
        return value -> Optional.ofNullable(value).map(v -> MINECRAFT_ID_PATTERN.matcher((CharSequence)v).matches()).filter(v -> v == false).map(v -> new TranslatableComponent("text.autoconfig.fallingtree.error.invalidItemResourceLocation"));
    }
}

