/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree;

import fr.raksrinana.fallingtree.forge.tree.TreePart;
import fr.raksrinana.fallingtree.forge.utils.TreePartType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;

public class Tree {
    private final Level level;
    private final BlockPos hitPos;
    private final Set<TreePart> parts = new LinkedHashSet<TreePart>();
    private final Map<TreePartType, Integer> partCounts = new LinkedHashMap<TreePartType, Integer>();

    public void addPart(TreePart treePart) {
        this.parts.add(treePart);
        this.partCounts.compute(treePart.treePartType(), (key, value) -> {
            if (Objects.isNull(value)) {
                return 1;
            }
            return value + 1;
        });
    }

    public void removePartsHigherThan(int y, TreePartType partType) {
        this.parts.removeIf(part -> {
            if (part.treePartType() == partType && part.blockPos().m_123342_() > y) {
                this.decrementPartCount(partType);
                return true;
            }
            return false;
        });
    }

    public int getBreakableCount() {
        return Arrays.stream(TreePartType.values()).filter(TreePartType::isBreakable).mapToInt(this::getPartCount).sum();
    }

    private int getPartCount(TreePartType treePartType) {
        return this.partCounts.computeIfAbsent(treePartType, key -> 0);
    }

    public int getSize() {
        return this.partCounts.values().stream().mapToInt(i -> i).sum();
    }

    private void decrementPartCount(TreePartType partType) {
        this.partCounts.computeIfPresent(partType, (type, count) -> Math.max(0, count - 1));
    }

    public Optional<TreePart> getLastSequencePart() {
        return this.getParts().stream().max(Comparator.comparingInt(TreePart::sequence));
    }

    public Collection<TreePart> getLogs() {
        return this.getParts().stream().filter(part -> part.treePartType() == TreePartType.LOG).collect(Collectors.toSet());
    }

    public Collection<TreePart> getBreakableParts() {
        return this.getParts().stream().filter(part -> part.treePartType().isBreakable()).collect(Collectors.toSet());
    }

    public int getLogCount() {
        return this.getPartCount(TreePartType.LOG);
    }

    public Optional<BlockPos> getTopMostLog() {
        return this.getLogs().stream().map(TreePart::blockPos).max(Comparator.comparingInt(Vec3i::m_123342_));
    }

    private Optional<BlockPos> getTopMostPart() {
        return this.getParts().stream().map(TreePart::blockPos).max(Comparator.comparingInt(Vec3i::m_123342_));
    }

    public Collection<TreePart> getWarts() {
        return this.getParts().stream().filter(part -> part.treePartType() == TreePartType.NETHER_WART).collect(Collectors.toSet());
    }

    public Tree(Level level, BlockPos hitPos) {
        this.level = level;
        this.hitPos = hitPos;
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getHitPos() {
        return this.hitPos;
    }

    public Set<TreePart> getParts() {
        return this.parts;
    }
}

