/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree.breaking;

import fr.raksrinana.fallingtree.forge.FallingTree;
import fr.raksrinana.fallingtree.forge.FallingTreeBlockBreakEvent;
import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.tree.Tree;
import fr.raksrinana.fallingtree.forge.tree.TreePart;
import fr.raksrinana.fallingtree.forge.tree.breaking.BreakTreeTooBigException;
import fr.raksrinana.fallingtree.forge.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.forge.tree.breaking.ToolDamageHandler;
import fr.raksrinana.fallingtree.forge.utils.FallingTreeUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class InstantaneousTreeBreakingHandler
implements ITreeBreakingHandler {
    private static InstantaneousTreeBreakingHandler INSTANCE;

    @Override
    public void breakTree(BlockEvent.BreakEvent event, Tree tree) throws BreakTreeTooBigException {
        if (!this.destroyInstant(tree, event.getPlayer(), event.getPlayer().m_21120_(InteractionHand.MAIN_HAND)) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    private boolean destroyInstant(@Nonnull Tree tree, @Nonnull Player player, @Nonnull ItemStack tool) throws BreakTreeTooBigException {
        Level level = tree.getLevel();
        ToolDamageHandler toolHandler = new ToolDamageHandler(tool, Config.COMMON.getTools().getDamageMultiplicand(), Config.COMMON.getTools().isPreserve(), tree.getBreakableCount());
        if (toolHandler.getMaxBreakCount() <= 0) {
            FallingTree.logger.debug("Didn't break tree at {} as {}'s tool was about to break", (Object)tree.getHitPos(), (Object)player);
            FallingTreeUtils.notifyPlayer(player, (Component)new TranslatableComponent("chat.fallingtree.prevented_break_tool"));
            return false;
        }
        int brokenCount = tree.getBreakableParts().stream().sorted(Config.COMMON.getTrees().getBreakOrder().getComparator()).limit(toolHandler.getMaxBreakCount()).map(TreePart::blockPos).mapToInt(logBlockPos -> {
            boolean cancelled;
            BlockState logState = level.m_8055_(logBlockPos);
            if (!tree.getHitPos().equals(logBlockPos) && (cancelled = MinecraftForge.EVENT_BUS.post((Event)new FallingTreeBlockBreakEvent(level, (BlockPos)logBlockPos, logState, player)))) {
                return 0;
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)logState.m_60734_().m_5456_()));
            logState.m_60734_().m_6240_(level, player, logBlockPos, logState, level.m_7702_(logBlockPos), tool);
            level.m_7471_(logBlockPos, false);
            return 1;
        }).sum();
        int toolDamage = toolHandler.getActualDamage(brokenCount) - 1;
        if (toolDamage > 0) {
            tool.m_41622_(toolDamage, (LivingEntity)player, entity -> {});
        }
        if (brokenCount >= toolHandler.getMaxBreakCount()) {
            InstantaneousTreeBreakingHandler.forceBreakDecayLeaves(tree, level);
        }
        return true;
    }

    private static void forceBreakDecayLeaves(@Nonnull Tree tree, Level level) {
        int radius = Config.COMMON.getTrees().getLeavesBreakingForceRadius();
        if (radius > 0) {
            tree.getTopMostLog().ifPresent(topLog -> {
                BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
                for (int dx = -radius; dx < radius; ++dx) {
                    for (int dy = -radius; dy < radius; ++dy) {
                        for (int dz = -radius; dz < radius; ++dz) {
                            checkPos.m_122178_(topLog.m_123341_() + dx, topLog.m_123342_() + dy, topLog.m_123343_() + dz);
                            BlockState checkState = level.m_8055_((BlockPos)checkPos);
                            Block checkBlock = checkState.m_60734_();
                            if (!FallingTreeUtils.isLeafBlock(checkBlock)) continue;
                            Block.m_49950_((BlockState)checkState, (Level)level, (BlockPos)checkPos);
                            level.m_7471_((BlockPos)checkPos, false);
                        }
                    }
                }
            });
        }
    }

    public static InstantaneousTreeBreakingHandler getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new InstantaneousTreeBreakingHandler();
        }
        return INSTANCE;
    }
}

