/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree.breaking;

import fr.raksrinana.fallingtree.forge.FallingTree;
import fr.raksrinana.fallingtree.forge.FallingTreeBlockBreakEvent;
import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.tree.Tree;
import fr.raksrinana.fallingtree.forge.tree.TreePart;
import fr.raksrinana.fallingtree.forge.tree.breaking.BreakTreeTooBigException;
import fr.raksrinana.fallingtree.forge.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.forge.tree.breaking.ToolDamageHandler;
import fr.raksrinana.fallingtree.forge.utils.FallingTreeUtils;
import fr.raksrinana.fallingtree.forge.utils.TreePartType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class ShiftDownTreeBreakingHandler
implements ITreeBreakingHandler {
    private static ShiftDownTreeBreakingHandler INSTANCE;

    @Override
    public void breakTree(BlockEvent.BreakEvent event, Tree tree) throws BreakTreeTooBigException {
        this.destroyShift(tree, event.getPlayer(), event.getPlayer().m_21120_(InteractionHand.MAIN_HAND));
        if (event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    private boolean destroyShift(@Nonnull Tree tree, @Nonnull Player player, @Nonnull ItemStack tool) throws BreakTreeTooBigException {
        Optional<TreePart> treePartOptional = tree.getLastSequencePart();
        if (treePartOptional.isPresent()) {
            TreePart treePart = treePartOptional.get();
            Level level = tree.getLevel();
            if (treePart.treePartType() == TreePartType.NETHER_WART && Config.COMMON.getTrees().isInstantlyBreakWarts()) {
                return this.breakElements(tree, level, player, tool, tree.getWarts());
            }
            return this.breakElements(tree, level, player, tool, List.of(treePart));
        }
        return false;
    }

    private boolean breakElements(Tree tree, Level level, Player player, ItemStack tool, Collection<TreePart> parts) throws BreakTreeTooBigException {
        int count = parts.size();
        double damageMultiplicand = Config.COMMON.getTools().getDamageMultiplicand();
        ToolDamageHandler toolHandler = new ToolDamageHandler(tool, damageMultiplicand, Config.COMMON.getTools().isPreserve(), count);
        if (toolHandler.getMaxBreakCount() <= 0) {
            FallingTree.logger.debug("Didn't break tree at {} as {}'s tool was about to break", (Object)tree.getHitPos(), (Object)player);
            FallingTreeUtils.notifyPlayer(player, (Component)new TranslatableComponent("chat.fallingtree.prevented_break_tool"));
            return false;
        }
        int breakCount = parts.stream().mapToInt(wart -> this.breakPart((TreePart)wart, level, player, tool)).sum();
        int damage = toolHandler.getActualDamage(breakCount);
        if (Double.compare(damageMultiplicand, 0.0) > 0 && damage > 0) {
            tool.m_41622_(damage, (LivingEntity)player, entity -> {});
        }
        return true;
    }

    private int breakPart(TreePart treePart, Level level, Player player, ItemStack tool) {
        BlockState blockState;
        BlockPos blockPos = treePart.blockPos();
        if (MinecraftForge.EVENT_BUS.post((Event)new FallingTreeBlockBreakEvent(level, blockPos, blockState = level.m_8055_(blockPos), player))) {
            return 0;
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)blockState.m_60734_().m_5456_()));
        blockState.m_60734_().m_6240_(level, player, blockPos, blockState, level.m_7702_(blockPos), tool);
        level.m_7471_(blockPos, false);
        return 1;
    }

    public static ShiftDownTreeBreakingHandler getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new ShiftDownTreeBreakingHandler();
        }
        return INSTANCE;
    }
}

