/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree.builder.position;

import fr.raksrinana.fallingtree.forge.tree.builder.ToAnalyzePos;
import fr.raksrinana.fallingtree.forge.tree.builder.position.BasicPositionFetcher;
import fr.raksrinana.fallingtree.forge.tree.builder.position.IPositionFetcher;
import fr.raksrinana.fallingtree.forge.utils.FallingTreeUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class AbovePositionFetcher
implements IPositionFetcher {
    private static AbovePositionFetcher INSTANCE;
    private static AbovePositionFetcher SECOND_STEP_INSTANCE;
    private final Function<BlockPos, BlockPos> lowerPosProvider;
    private final Supplier<IPositionFetcher> positionFetcherSupplier;

    @Override
    public Collection<ToAnalyzePos> getPositions(Level level, BlockPos originPos, ToAnalyzePos parent) {
        BlockPos parentPos = parent.checkPos();
        Block parentBlock = level.m_8055_(parentPos).m_60734_();
        return BlockPos.m_121990_((BlockPos)parentPos.m_7494_().m_142127_().m_142126_(), (BlockPos)this.lowerPosProvider.apply(parentPos).m_142128_().m_142125_()).map(checkPos -> {
            Block checkBlock = level.m_8055_(checkPos).m_60734_();
            return new ToAnalyzePos(this.positionFetcherSupplier.get(), parentPos, parentBlock, checkPos.m_7949_(), checkBlock, FallingTreeUtils.getTreePart(checkBlock), parent.sequence() + 1);
        }).collect(Collectors.toList());
    }

    public static AbovePositionFetcher getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new AbovePositionFetcher(BlockPos::m_7494_, AbovePositionFetcher::getSecondStepInstance);
        }
        return INSTANCE;
    }

    private static AbovePositionFetcher getSecondStepInstance() {
        if (Objects.isNull(SECOND_STEP_INSTANCE)) {
            SECOND_STEP_INSTANCE = new AbovePositionFetcher(Function.identity(), BasicPositionFetcher::getInstance);
        }
        return SECOND_STEP_INSTANCE;
    }

    private AbovePositionFetcher(Function<BlockPos, BlockPos> lowerPosProvider, Supplier<IPositionFetcher> positionFetcherSupplier) {
        this.lowerPosProvider = lowerPosProvider;
        this.positionFetcherSupplier = positionFetcherSupplier;
    }
}

