// https://cadiboo.github.io/tutorials/1.14.4/forge/99.99-coremod/

function initializeCoreMod() {

    /*Class/Interface*/
    Opcodes = Java.type("org.objectweb.asm.Opcodes");
    /*Class*/
    ASMAPI = Java.type("net.minecraftforge.coremod.api.ASMAPI");

    /*Class*/
    InsnList = Java.type("org.objectweb.asm.tree.InsnList");
    /*Class*/
    LabelNode = Java.type("org.objectweb.asm.tree.LabelNode");

    /*Class*/
    FieldNode = Java.type("org.objectweb.asm.tree.FieldNode");
    /*Class*/
    MethodNode = Java.type("org.objectweb.asm.tree.MethodNode");

    /*Class*/
    AbstractInsnNode = Java.type("org.objectweb.asm.tree.AbstractInsnNode");
    /*Class*/
    InsnNode = Java.type("org.objectweb.asm.tree.InsnNode");
    /*Class*/
    VarInsnNode = Java.type("org.objectweb.asm.tree.VarInsnNode");
    /*Class*/
    FieldInsnNode = Java.type("org.objectweb.asm.tree.FieldInsnNode");
    /*Class*/
    MethodInsnNode = Java.type("org.objectweb.asm.tree.MethodInsnNode");
    /*Class*/
    JumpInsnNode = Java.type("org.objectweb.asm.tree.JumpInsnNode");
    /*Class*/
    TypeInsnNode = Java.type("org.objectweb.asm.tree.TypeInsnNode");

    var targetMethodName = ASMAPI.mapMethod("m_93028_");
    var targetClass = "net.minecraft.client.gui.Gui";
    var targetMethodSrg = "m_93028_";
    var targetMethodDesc = "(Lcom/mojang/blaze3d/vertex/PoseStack;)V";


    return {
        'Gui.renderEffects': {
            'target': {
                'type': 'METHOD',
                'class': targetClass,
                'methodName': targetMethodName,
                'methodDesc': targetMethodDesc
            },
            "transformer": function (methodNode) {
                var instList = new InsnList();
                var targetName = "isAmbient";
                var targetNameObf = "m_19571_";
                var j1 = 3;
                var k1 = 4;
                var i = 11;
                var j = 12;
                var mobEffect = 9;

                // add method for processing
                instList.add(new LabelNode());
                instList.add(new VarInsnNode(Opcodes.ILOAD, i));
                instList.add(new VarInsnNode(Opcodes.ILOAD, j));
                instList.add(new VarInsnNode(Opcodes.ILOAD, j1));
                instList.add(new VarInsnNode(Opcodes.ILOAD, k1));
                instList.add(new VarInsnNode(Opcodes.ALOAD, mobEffect));
                instList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, "journeymap/client/ui/minimap/Effect", "effectProcessor", "(IIIILnet/minecraft/world/effect/MobEffect;)[I", false));
                instList.add(new InsnNode(Opcodes.ICONST_0));
                instList.add(new InsnNode(Opcodes.IALOAD));
                instList.add(new VarInsnNode(Opcodes.ISTORE, i));

                // set l from returned array
                instList.add(new LabelNode());
                instList.add(new VarInsnNode(Opcodes.ILOAD, i));
                instList.add(new VarInsnNode(Opcodes.ILOAD, j));
                instList.add(new VarInsnNode(Opcodes.ILOAD, j1));
                instList.add(new VarInsnNode(Opcodes.ILOAD, k1));
                instList.add(new VarInsnNode(Opcodes.ALOAD, mobEffect));
                instList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, "journeymap/client/ui/minimap/Effect", "effectProcessor", "(IIIILnet/minecraft/world/effect/MobEffect;)[I", false));
                instList.add(new InsnNode(Opcodes.ICONST_1));
                instList.add(new InsnNode(Opcodes.IALOAD));
                instList.add(new VarInsnNode(Opcodes.ISTORE, j));

                // we want to add it to the end of the method, find the 18th label and insert.
                var instructions = methodNode.instructions;

                var lastLabelIndex;

                for (var index = 0; index < instructions.size(); ++index) {
                    // print(instructions.get(index) +" : "+
                    //     instructions.get(index).getType() +" : "+
                    //     instructions.get(index).owner +" : "+
                    //     instructions.get(index).name+" : "+
                    //     instructions.get(index).desc)

                    if (AbstractInsnNode.LABEL === instructions.get(index).getType()) {
                        lastLabelIndex = index;
                    }
                    if (Opcodes.INVOKEVIRTUAL === instructions.get(index).getOpcode()
                        && (instructions.get(index).name === targetName
                            || instructions.get(index).name === targetNameObf)) {
                        print("############ Journeymap Coremod Potion Effects Renderer: Injected ############")
                        instructions.insert(instructions.get(lastLabelIndex), instList);
                        break;
                    }
                }

                return methodNode;
            }
        }
    }

    function hasOptifine(instructions) {

        for (var i = 0; i < instructions.size(); ++i) {
            var instructionOwner = instructions.get(i).owner;
            if ('net/optifine/reflect/Reflector' == instructionOwner) {
                print('Found Optifine')
                return true;
            }
        }
        // print('Did not find Optifine')
        return false;
    }


    // INJECTED CODE
    /* void testCode() {
       int i; //ISTORE 4
       int j;//ISTORE 5
       int k; //ISTORE 11
       int l;//ISTORE 12
       MobEffect mobeffect = null;
       int[] ints = Effect.effectProcessor(k, l, i, j, mobeffect); //ASTORE 18
       k = ints[0];
       l = ints[1];
   }

    *    L4
    *     LINENUMBER 15 L4
    *     ILOAD 11
    *     ILOAD 12
    *     ILOAD 3
    *     ILOAD 4
    *     ALOAD 9
    *     INVOKESTATIC journeymap/client/ui/minimap/Effect.effectProcessor (IIIILnet/minecraft/world/effect/MobEffect;)[I
    *     ASTORE 18
    *    L5
    *     LINENUMBER 16 L5
    *     ALOAD 18
    *     ICONST_0
    *     IALOAD
    *     ISTORE 11
    *    L6
    *     LINENUMBER 17 L6
    *     ALOAD 18
    *     ICONST_1
    *     IALOAD
    *     ISTORE 12
    */
}