/*
 * Decompiled with CFR 0.152.
 */
package com.teamfractal.ore_tree.common.block.base;

import com.teamfractal.ore_tree.client.config.OTClientConfig;
import com.teamfractal.ore_tree.common.action.OreTreePlacement;
import com.teamfractal.ore_tree.common.config.OTCommonConfig;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OreSaplingBlock
extends BushBlock {
    private static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private final Item catalystItem;
    private final TagKey<Block> rootable;
    private final double randomTickValue;
    private final double randomCatalyzeValue;
    private final ResourceLocation treeNBTLocation;

    public OreSaplingBlock(Item catalystItem, TagKey<Block> rootable, double randomTickValue, double randomCatalyzeValue, ResourceLocation treeNBTLocation) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60977_().m_60910_().m_60918_(SoundType.f_56740_).m_60966_());
        this.catalystItem = catalystItem;
        this.randomTickValue = randomTickValue;
        this.randomCatalyzeValue = randomCatalyzeValue;
        this.treeNBTLocation = treeNBTLocation;
        this.rootable = rootable;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext p_48881_) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext cc) {
        return SHAPE;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public boolean m_6266_(BlockState groundState, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return groundState.m_204336_(this.rootable) || (Boolean)OTCommonConfig.CAN_PLANT_ON_DIRT.get() != false && groundState.m_204336_(BlockTags.f_144274_);
    }

    public boolean m_7898_(@Nonnull BlockState blockstate, @Nonnull LevelReader worldIn, BlockPos pos) {
        return this.m_6266_(worldIn.m_8055_(pos.m_7495_()), (BlockGetter)worldIn, pos.m_7495_());
    }

    @Nonnull
    public ItemStack m_7397_(@Nonnull BlockGetter p_52254_, @Nonnull BlockPos p_52255_, @Nonnull BlockState p_52256_) {
        return new ItemStack((ItemLike)this);
    }

    public void m_7455_(BlockState state, @Nonnull ServerLevel world, @Nonnull BlockPos pos, @Nonnull Random random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (random.nextDouble() <= this.randomTickValue && world.m_45517_(LightLayer.SKY, pos.m_7494_()) - world.m_7445_() >= 9) {
            if (i < 3) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                OreTreePlacement.tryPlace((Level)world, this.treeNBTLocation, pos);
            }
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult trace) {
        int i = (Integer)state.m_61143_((Property)AGE);
        Random random = level.f_46441_;
        if (player.m_21120_(hand).m_41720_() == this.catalystItem) {
            if (i < 3) {
                if (random.nextDouble() <= this.randomCatalyzeValue) {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + 0.5, 5, 0.0, 0.0, 0.0, 1.0);
                        serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                    }
                } else if (((Boolean)OTClientConfig.CATALYZE_FAILURE_PARTICLE_DISPLAY.get()).booleanValue() && level.f_46443_) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                }
                OreTreePlacement.consumeCatalyst(player, this.catalystItem.m_7968_());
            } else if (OreTreePlacement.tryPlace(level, this.treeNBTLocation, pos)) {
                OreTreePlacement.consumeCatalyst(player, this.catalystItem.m_7968_());
            }
        } else {
            return super.m_6227_(state, level, pos, player, hand, trace);
        }
        return InteractionResult.PASS;
    }
}

