/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeList;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PlayerVolumesScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_player_volumes.png");
    protected static final Component TITLE = new TranslatableComponent("gui.voicechat.adjust_volume.title");
    protected static final Component SEARCH_HINT = new TranslatableComponent("message.voicechat.search_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
    protected static final Component EMPTY_SEARCH = new TranslatableComponent("message.voicechat.search_empty").m_130940_(ChatFormatting.GRAY);
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 8;
    protected static final int SEARCH_HEIGHT = 16;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected AdjustVolumeList volumeList;
    protected EditBox searchBox;
    protected String lastSearch = "";
    protected int units;

    public PlayerVolumesScreen() {
        super(TITLE, 236, 0);
    }

    public void m_96624_() {
        super.m_96624_();
        this.searchBox.m_94120_();
        this.volumeList.tick();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = Mth.m_14167_((float)3.1111112f);
        this.units = Math.max(minUnits, (this.f_96544_ - 16 - 8 - this.guiTop * 2 - 16) / 18);
        this.ySize = 16 + this.units * 18 + 8;
        this.f_96541_.f_91068_.m_90926_(true);
        if (this.volumeList != null) {
            this.volumeList.m_93437_(this.f_96543_, this.f_96544_, this.guiTop + 16 + 16, this.guiTop + 16 + this.units * 18);
        } else {
            this.volumeList = new AdjustVolumeList(this.f_96543_, this.f_96544_, this.guiTop + 16 + 16, this.guiTop + 16 + this.units * 18, 36, this);
        }
        String string = this.searchBox != null ? this.searchBox.m_94155_() : "";
        this.searchBox = new EditBox(this.f_96547_, this.guiLeft + 28, this.guiTop + 16 + 6, 196, 16, SEARCH_HINT);
        this.searchBox.m_94199_(16);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(string);
        this.searchBox.m_94151_(this::checkSearchStringUpdate);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.volumeList);
    }

    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            this.m_93228_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        this.m_93228_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 8);
        this.m_93228_(poseStack, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.f_96547_.m_92889_(poseStack, TITLE, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)TITLE) / 2), (float)(this.guiTop + 5), 0x404040);
        if (!this.volumeList.isEmpty()) {
            this.volumeList.m_6305_(poseStack, mouseX, mouseY, delta);
        } else if (!this.searchBox.m_94155_().isEmpty()) {
            int n = this.f_96543_ / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.f_96547_);
            PlayerVolumesScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)EMPTY_SEARCH, (int)n, (int)(n2 - 9 / 2), (int)-1);
        }
        if (!this.searchBox.m_93696_() && this.searchBox.m_94155_().isEmpty()) {
            PlayerVolumesScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)SEARCH_HINT, (int)this.searchBox.f_93620_, (int)this.searchBox.f_93621_, (int)-1);
        } else {
            this.searchBox.m_6305_(poseStack, mouseX, mouseY, delta);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.searchBox.m_93696_()) {
            this.searchBox.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button) || this.volumeList.m_6375_(mouseX, mouseY, button);
    }

    private void checkSearchStringUpdate(String string) {
        if (!(string = string.toLowerCase(Locale.ROOT)).equals(this.lastSearch)) {
            this.volumeList.setFilter(string);
            this.lastSearch = string;
        }
    }
}

