/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class Utils {
    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static short[] bytesToShorts(byte[] bytes) {
        if (bytes.length % 2 != 0) {
            throw new IllegalArgumentException("Input bytes need to be divisible by 2");
        }
        short[] data = new short[bytes.length / 2];
        for (int i = 0; i < bytes.length; i += 2) {
            data[i / 2] = Utils.bytesToShort(bytes[i], bytes[i + 1]);
        }
        return data;
    }

    public static byte[] shortsToBytes(short[] shorts) {
        byte[] data = new byte[shorts.length * 2];
        for (int i = 0; i < shorts.length; ++i) {
            byte[] split = Utils.shortToBytes(shorts[i]);
            data[i * 2] = split[0];
            data[i * 2 + 1] = split[1];
        }
        return data;
    }

    public static float percentageToDB(float percentage) {
        return (float)(10.0 * Math.log(percentage));
    }

    public static short bytesToShort(byte b1, byte b2) {
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public static byte[] shortToBytes(short s) {
        return new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
    }

    public static short[] floatsToShorts(float[] floats) {
        short[] shorts = new short[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            shorts[i] = Float.valueOf(floats[i]).shortValue();
        }
        return shorts;
    }

    public static float[] shortsToFloats(short[] shorts) {
        float[] floats = new float[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            floats[i] = Short.valueOf(shorts[i]).floatValue();
        }
        return floats;
    }

    public static byte[] floatsToBytes(float[] floats) {
        byte[] bytes = new byte[floats.length * 2];
        for (int i = 0; i < floats.length; ++i) {
            short x = Float.valueOf(floats[i]).shortValue();
            bytes[i * 2] = (byte)(x & 0xFF);
            bytes[i * 2 + 1] = (byte)((x & 0xFF00) >> 8);
        }
        return bytes;
    }

    public static float[] bytesToFloats(byte[] bytes) {
        float[] floats = new float[bytes.length / 2];
        for (int i = 0; i < bytes.length / 2; ++i) {
            floats[i] = (bytes[i * 2 + 1] & 0x80) != 0 ? (float)(Short.MIN_VALUE + ((bytes[i * 2 + 1] & 0x7F) << 8) | bytes[i * 2] & 0xFF) : (float)(bytes[i * 2 + 1] << 8 & 0xFF00 | bytes[i * 2] & 0xFF);
        }
        return floats;
    }

    public static float normalizeAngle(float angle) {
        if ((angle %= 360.0f) <= -180.0f) {
            angle += 360.0f;
        } else if (angle > 180.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    public static float angle(Vec2 vec1, Vec2 vec2) {
        return (float)Math.toDegrees(Math.atan2(vec1.f_82470_ * vec2.f_82470_ + vec1.f_82471_ * vec2.f_82471_, vec1.f_82470_ * vec2.f_82471_ - vec1.f_82471_ * vec2.f_82470_));
    }

    private static double magnitude(Vec2 vec1) {
        return Math.sqrt(Math.pow(vec1.f_82470_, 2.0) + Math.pow(vec1.f_82471_, 2.0));
    }

    private static float multiply(Vec2 vec1, Vec2 vec2) {
        return vec1.f_82470_ * vec2.f_82470_ + vec1.f_82471_ * vec2.f_82471_;
    }

    private static Vec2 rotate(Vec2 vec, float angle) {
        return new Vec2(vec.f_82470_ * Mth.m_14089_((float)angle) - vec.f_82471_ * Mth.m_14031_((float)angle), vec.f_82470_ * Mth.m_14031_((float)angle) + vec.f_82471_ * Mth.m_14089_((float)angle));
    }

    public static double calculateAudioLevel(short[] samples, int offset, int length) {
        double rms = 0.0;
        for (int i = offset; i < length; ++i) {
            double sample = (double)samples[i] / 32767.0;
            rms += sample * sample;
        }
        int sampleCount = length / 2;
        rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        double db = rms > 0.0 ? Math.min(Math.max(20.0 * Math.log10(rms), -127.0), 0.0) : -127.0;
        return db;
    }

    public static double getHighestAudioLevel(short[] samples) {
        double highest = -127.0;
        for (int i = 0; i < samples.length; i += 100) {
            double level = Utils.calculateAudioLevel(samples, i, Math.min(i + 100, samples.length));
            if (!(level > highest)) continue;
            highest = level;
        }
        return highest;
    }

    public static int getActivationOffset(short[] samples, double activationLevel) {
        int highestPos = -1;
        for (int i = 0; i < samples.length; i += 100) {
            double level = Utils.calculateAudioLevel(samples, i, Math.min(i + 100, samples.length));
            if (!(level >= activationLevel)) continue;
            highestPos = i;
        }
        return highestPos;
    }

    public static double dbToPerc(double db) {
        return (db + 127.0) / 127.0;
    }

    public static double percToDb(double perc) {
        return perc * 127.0 - 127.0;
    }

    @Nullable
    public static <T> T createSafe(Supplier<T> supplier, @Nullable Consumer<Throwable> onError) {
        AtomicReference exception = new AtomicReference();
        AtomicReference obj = new AtomicReference();
        Thread t = new Thread(() -> {
            if (onError != null) {
                Thread.setDefaultUncaughtExceptionHandler((t1, e) -> exception.set(e));
            }
            obj.set(supplier.get());
        });
        t.start();
        try {
            t.join(1000L);
        }
        catch (InterruptedException e) {
            return null;
        }
        Throwable ex = (Throwable)exception.get();
        if (onError != null && ex != null) {
            onError.accept(ex);
        }
        return (T)obj.get();
    }

    @Nullable
    public static <T> T createSafe(Supplier<T> supplier) {
        return Utils.createSafe(supplier, null);
    }
}

