/*
 * Decompiled with CFR 0.152.
 */
package com.song.castle_in_the_sky.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.song.castle_in_the_sky.config.ConfigCommon;
import com.song.castle_in_the_sky.features.PieceGeneratorList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CastleStructure
extends StructureFeature<JigsawConfiguration> {
    public static final Holder<StructureTemplatePool> START = Pools.m_211103_((StructureTemplatePool)new StructureTemplatePool(new ResourceLocation("village/desert/town_centers"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210507_((String)"village/desert/town_centers/desert_meeting_point_1"), (Object)98)), StructureTemplatePool.Projection.RIGID));
    private static final Logger LOGGER = LogManager.getLogger();

    public CastleStructure(Codec<JigsawConfiguration> codec) {
        super(codec, context -> {
            if (!CastleStructure.isFeatureChunk((PieceGeneratorSupplier.Context<JigsawConfiguration>)context)) {
                return Optional.empty();
            }
            return CastleStructure.createPiecesGenerator((PieceGeneratorSupplier.Context<JigsawConfiguration>)context);
        }, PostPlacementProcessor.f_192427_);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ArrayList<PieceGenerator<JigsawConfiguration>> list = new ArrayList<PieceGenerator<JigsawConfiguration>>();
        BlockPos blockpos = context.f_197355_().m_151394_(((Integer)ConfigCommon.CASTLE_HEIGHT.get()).intValue());
        for (int shift1 = 0; shift1 < 3; ++shift1) {
            for (int shift2 = 0; shift2 < 3; ++shift2) {
                for (int shiftY = 0; shiftY < 3; ++shiftY) {
                    String xyz = String.format("%d%d%d", shift1, shiftY, shift2);
                    ((JigsawConfiguration)context.f_197356_()).f_67757_ = Holder.m_205709_((Object)((StructureTemplatePool)context.f_197360_().m_206191_(Registry.f_122884_).m_7745_(new ResourceLocation("castle_in_the_sky", "castle_in_the_sky/laputa" + xyz))));
                    Optional<PieceGenerator<JigsawConfiguration>> structurePiecesGenerator = CastleStructure.addPieces(context, PoolElementStructurePiece::new, blockpos.m_142082_(shift2 * 48, shiftY * 48, shift1 * 48), false, false);
                    structurePiecesGenerator.ifPresent(list::add);
                }
            }
        }
        return Optional.of(new PieceGeneratorList(list));
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockPos = context.f_197355_().m_45615_();
        return !blockPos.m_123314_(new Vec3i(0, 0, 0), (double)((Integer)ConfigCommon.CASTLE_SPAWN_PROOF.get()).intValue());
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> addPieces(PieceGeneratorSupplier.Context<JigsawConfiguration> p_210285_, JigsawPlacement.PieceFactory p_210286_, BlockPos p_210287_, boolean p_210288_, boolean p_210289_) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(p_210285_.f_197354_(), p_210285_.f_197355_().f_45578_, p_210285_.f_197355_().f_45579_);
        RegistryAccess registryaccess = p_210285_.f_197360_();
        JigsawConfiguration jigsawconfiguration = (JigsawConfiguration)p_210285_.f_197356_();
        ChunkGenerator chunkgenerator = p_210285_.f_197352_();
        StructureManager structuremanager = p_210285_.f_197359_();
        LevelHeightAccessor levelheightaccessor = p_210285_.f_197357_();
        Predicate predicate = p_210285_.f_197358_();
        StructureFeature.m_67096_();
        Registry registry = registryaccess.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.NONE;
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)jigsawconfiguration.m_204802_().m_203334_();
        StructurePoolElement structurepoolelement = structuretemplatepool.m_210585_((Random)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece poolelementstructurepiece = p_210286_.m_210300_(structuremanager, structurepoolelement, p_210287_, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_207470_(structuremanager, p_210287_, rotation));
        BoundingBox boundingbox = poolelementstructurepiece.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int k = p_210289_ ? p_210287_.m_123342_() + chunkgenerator.m_156174_(i, j, Heightmap.Types.WORLD_SURFACE_WG, levelheightaccessor) : p_210287_.m_123342_();
        if (!predicate.test(chunkgenerator.m_203495_(QuartPos.m_175400_((int)i), QuartPos.m_175400_((int)k), QuartPos.m_175400_((int)j)))) {
            return Optional.empty();
        }
        int l = boundingbox.m_162396_() + poolelementstructurepiece.m_72647_();
        poolelementstructurepiece.m_6324_(0, k - l, 0);
        return Optional.of((p_210282_, p_210283_) -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (jigsawconfiguration.m_67765_() > 0) {
                int i1 = 80;
                AABB aabb = new AABB((double)(i - 80), (double)(k - 80), (double)(j - 80), (double)(i + 80 + 1), (double)(k + 80 + 1), (double)(j + 80 + 1));
                JigsawPlacement.Placer jigsawplacement$placer = new JigsawPlacement.Placer(registry, jigsawconfiguration.m_67765_(), p_210286_, chunkgenerator, structuremanager, (List)list, (Random)worldgenrandom);
                jigsawplacement$placer.f_210321_.addLast(new JigsawPlacement.PieceState(poolelementstructurepiece, new MutableObject((Object)Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_)), 0));
                while (!jigsawplacement$placer.f_210321_.isEmpty()) {
                    JigsawPlacement.PieceState jigsawplacement$piecestate = (JigsawPlacement.PieceState)jigsawplacement$placer.f_210321_.removeFirst();
                    jigsawplacement$placer.m_210333_(jigsawplacement$piecestate.f_210307_, jigsawplacement$piecestate.f_210308_, jigsawplacement$piecestate.f_210309_, p_210288_, levelheightaccessor);
                }
                list.forEach(arg_0 -> ((StructurePiecesBuilder)p_210282_).m_142679_(arg_0));
            }
        });
    }
}

