/*
 * Decompiled with CFR 0.152.
 */
package com.song.castle_in_the_sky.items;

import com.song.castle_in_the_sky.CastleInTheSky;
import com.song.castle_in_the_sky.config.ConfigCommon;
import com.song.castle_in_the_sky.effects.EffectRegister;
import com.song.castle_in_the_sky.features.StructureRegister;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class LevitationStone
extends Item {
    public LevitationStone() {
        super(new Item.Properties().m_41491_(CastleInTheSky.ITEM_GROUP).m_41487_(1));
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (isSelected && this.isActive(itemStack)) {
            CompoundTag nbt;
            if (!world.m_5776_() && world instanceof ServerLevel && world.m_46467_() % 40L == 0L && entity instanceof LivingEntity) {
                if (((LivingEntity)entity).m_21023_((MobEffect)EffectRegister.SACRED_CASTLE_EFFECT.get())) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19620_, 100));
                } else {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100));
                }
            }
            if (world.m_5776_() && world.m_46472_().m_135782_().toString().equals("minecraft:overworld") && (nbt = itemStack.m_41737_("targetLaputa")) != null) {
                int posX = nbt.m_128451_("posX");
                int posY = nbt.m_128451_("posY");
                int posZ = nbt.m_128451_("posZ");
                BlockPos entityPos = entity.m_142538_();
                double dist = Math.sqrt(entityPos.m_123331_(new Vec3i(posX, posY, posZ)));
                double dx = (double)(posX - entityPos.m_123341_()) / dist;
                double dy = (double)(posY - entityPos.m_123342_() - 2) / dist;
                double dz = (double)(posZ - entityPos.m_123343_()) / dist;
                for (int i = 2; i < 50; ++i) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)i * dx + (double)entityPos.m_123341_(), (double)i * dy + (double)entityPos.m_123342_(), (double)i * dz + (double)entityPos.m_123343_(), 0.0, 0.0, 0.0);
                }
            }
        }
        super.m_6883_(itemStack, world, entity, itemSlot, isSelected);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerEntity, InteractionHand hand) {
        if (!world.m_5776_()) {
            BlockPos blockpos;
            CompoundTag nbt;
            int useDistance = (int)((Double)ConfigCommon.LEVITATION_STONE_USE_PERCENT.get() * (double)((Integer)ConfigCommon.CASTLE_SPAWN_PROOF.get()).intValue());
            if (playerEntity.m_142538_().m_123314_(new Vec3i(0, 0, 0), (double)useDistance)) {
                playerEntity.m_6352_((Component)new TranslatableComponent("info.castle_in_the_sky.too_close_to_spawn", new Object[]{ConfigCommon.CASTLE_SPAWN_PROOF.get(), useDistance}).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), playerEntity.m_142081_());
                return super.m_7203_(world, playerEntity, hand);
            }
            ItemStack itemStack = playerEntity.m_21120_(hand);
            nbt.m_128379_("active", !(nbt = itemStack.m_41698_("castle_in_the_sky")).m_128471_("active"));
            if (this.isActive(itemStack) && (blockpos = ((ServerLevel)world).m_207561_(StructureRegister.TAG_CASTLE_IN_THE_SKY, playerEntity.m_142538_(), 100, false)) != null) {
                CompoundTag nbt1 = itemStack.m_41698_("targetLaputa");
                nbt1.m_128405_("posX", blockpos.m_123341_() + 72);
                nbt1.m_128405_("posY", (Integer)ConfigCommon.CASTLE_HEIGHT.get() + 72);
                nbt1.m_128405_("posZ", blockpos.m_123343_() + 72);
            }
        }
        return super.m_7203_(world, playerEntity, hand);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level p_77624_2_, List<Component> iTextComponents, TooltipFlag iTooltipFlag) {
        super.m_7373_(itemStack, p_77624_2_, iTextComponents, iTooltipFlag);
        iTextComponents.add((Component)new TranslatableComponent("tooltip.castle_in_the_sky.levitation_stone.line1").m_130940_(ChatFormatting.GRAY));
        iTextComponents.add((Component)new TranslatableComponent("tooltip.castle_in_the_sky.levitation_stone.line2").m_130940_(ChatFormatting.GRAY));
        iTextComponents.add((Component)new TranslatableComponent("tooltip.castle_in_the_sky.levitation_stone.line3").m_130940_(ChatFormatting.GRAY));
        String s = this.isActive(itemStack) ? "ON" : "OFF";
        iTextComponents.add((Component)new TextComponent(s).m_130940_(ChatFormatting.GOLD));
    }

    public boolean isActive(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41698_("castle_in_the_sky");
        return nbt.m_128471_("active");
    }
}

