/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityUtils {
    private final List<String> ENTITY_CLASSES = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public String CURRENT_TARGET_NAME;
    public String CURRENT_ATTACKING_NAME;
    public String CURRENT_RIDING_NAME;
    public List<String> ENTITY_NAMES = Lists.newArrayList();
    public List<String> CURRENT_TARGET_TAGS = Lists.newArrayList();
    public List<String> CURRENT_ATTACKING_TAGS = Lists.newArrayList();
    public List<String> CURRENT_RIDING_TAGS = Lists.newArrayList();
    private Entity CURRENT_TARGET;
    private Entity CURRENT_ATTACKING;
    private Entity CURRENT_RIDING;
    private CompoundTag CURRENT_TARGET_TAG;
    private CompoundTag CURRENT_ATTACKING_TAG;
    private CompoundTag CURRENT_RIDING_TAG;
    private boolean allEntitiesEmpty = false;
    private boolean currentlyCleared = true;

    private void emptyData() {
        this.ENTITY_NAMES.clear();
        this.ENTITY_CLASSES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_TARGET = null;
        this.CURRENT_ATTACKING = null;
        this.CURRENT_RIDING = null;
        this.CURRENT_TARGET_NAME = null;
        this.CURRENT_ATTACKING_NAME = null;
        this.CURRENT_RIDING_NAME = null;
        this.CURRENT_TARGET_TAG = null;
        this.CURRENT_ATTACKING_TAG = null;
        this.CURRENT_RIDING_TAG = null;
        this.CURRENT_TARGET_TAGS.clear();
        this.CURRENT_ATTACKING_TAGS.clear();
        this.CURRENT_RIDING_TAGS.clear();
        this.allEntitiesEmpty = true;
        this.isInUse = false;
        this.currentlyCleared = true;
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePerEntity : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.ENTITY_NAMES.isEmpty() || this.ENTITY_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getEntities();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateEntityData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateEntityData() {
        boolean hasRidingChanged;
        String NEW_CURRENT_RIDING_NAME;
        String NEW_CURRENT_ATTACKING_NAME;
        String NEW_CURRENT_TARGET_NAME;
        Entity NEW_CURRENT_TARGET = CraftPresence.instance.f_91077_ != null && CraftPresence.instance.f_91077_.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)CraftPresence.instance.f_91077_).m_82443_() : null;
        LivingEntity NEW_CURRENT_ATTACKING = CraftPresence.player.m_21214_();
        Entity NEW_CURRENT_RIDING = CraftPresence.player.m_20202_();
        if (NEW_CURRENT_TARGET instanceof Player) {
            Player NEW_CURRENT_PLAYER_TARGET = (Player)NEW_CURRENT_TARGET;
            NEW_CURRENT_TARGET_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_TARGET.m_36316_().getId().toString());
        } else {
            String string = NEW_CURRENT_TARGET_NAME = NEW_CURRENT_TARGET != null ? StringUtils.stripColors(NEW_CURRENT_TARGET.m_5446_().getString()) : "";
        }
        if (NEW_CURRENT_ATTACKING instanceof Player) {
            Player NEW_CURRENT_PLAYER_ATTACKING = (Player)NEW_CURRENT_ATTACKING;
            NEW_CURRENT_ATTACKING_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_ATTACKING.m_36316_().getId().toString());
        } else {
            String string = NEW_CURRENT_ATTACKING_NAME = NEW_CURRENT_ATTACKING != null ? StringUtils.stripColors(NEW_CURRENT_ATTACKING.m_5446_().getString()) : "";
        }
        if (NEW_CURRENT_RIDING instanceof Player) {
            Player NEW_CURRENT_PLAYER_RIDING = (Player)NEW_CURRENT_RIDING;
            NEW_CURRENT_RIDING_NAME = StringUtils.stripColors(NEW_CURRENT_PLAYER_RIDING.m_36316_().getId().toString());
        } else {
            NEW_CURRENT_RIDING_NAME = NEW_CURRENT_RIDING != null ? StringUtils.stripColors(NEW_CURRENT_RIDING.m_5446_().getString()) : "";
        }
        boolean hasTargetChanged = NEW_CURRENT_TARGET != null && !NEW_CURRENT_TARGET.equals((Object)this.CURRENT_TARGET) || !NEW_CURRENT_TARGET_NAME.equals(this.CURRENT_TARGET_NAME) || NEW_CURRENT_TARGET == null && this.CURRENT_TARGET != null;
        boolean hasAttackingChanged = NEW_CURRENT_ATTACKING != null && !NEW_CURRENT_ATTACKING.equals((Object)this.CURRENT_ATTACKING) || !NEW_CURRENT_ATTACKING_NAME.equals(this.CURRENT_ATTACKING_NAME) || NEW_CURRENT_ATTACKING == null && this.CURRENT_ATTACKING != null;
        boolean bl = hasRidingChanged = NEW_CURRENT_RIDING != null && !NEW_CURRENT_RIDING.equals((Object)this.CURRENT_RIDING) || !NEW_CURRENT_RIDING_NAME.equals(this.CURRENT_RIDING_NAME) || NEW_CURRENT_RIDING == null && this.CURRENT_RIDING != null;
        if (hasTargetChanged) {
            ArrayList NEW_CURRENT_TARGET_TAGS;
            this.CURRENT_TARGET = NEW_CURRENT_TARGET;
            this.CURRENT_TARGET_TAG = this.CURRENT_TARGET != null ? this.CURRENT_TARGET.m_20240_(new CompoundTag()) : null;
            ArrayList arrayList = NEW_CURRENT_TARGET_TAGS = this.CURRENT_TARGET_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_TARGET_TAG.m_128431_()) : Lists.newArrayList();
            if (!NEW_CURRENT_TARGET_TAGS.equals(this.CURRENT_TARGET_TAGS)) {
                this.CURRENT_TARGET_TAGS = NEW_CURRENT_TARGET_TAGS;
            }
            this.CURRENT_TARGET_NAME = NEW_CURRENT_TARGET_NAME;
        }
        if (hasAttackingChanged) {
            ArrayList NEW_CURRENT_ATTACKING_TAGS;
            this.CURRENT_ATTACKING = NEW_CURRENT_ATTACKING;
            this.CURRENT_ATTACKING_TAG = this.CURRENT_ATTACKING != null ? this.CURRENT_ATTACKING.m_20240_(new CompoundTag()) : null;
            ArrayList arrayList = NEW_CURRENT_ATTACKING_TAGS = this.CURRENT_ATTACKING_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_ATTACKING_TAG.m_128431_()) : Lists.newArrayList();
            if (!NEW_CURRENT_ATTACKING_TAGS.equals(this.CURRENT_ATTACKING_TAGS)) {
                this.CURRENT_ATTACKING_TAGS = NEW_CURRENT_ATTACKING_TAGS;
            }
            this.CURRENT_ATTACKING_NAME = NEW_CURRENT_ATTACKING_NAME;
        }
        if (hasRidingChanged) {
            ArrayList NEW_CURRENT_RIDING_TAGS;
            this.CURRENT_RIDING = NEW_CURRENT_RIDING;
            this.CURRENT_RIDING_TAG = this.CURRENT_RIDING != null ? this.CURRENT_RIDING.m_20240_(new CompoundTag()) : null;
            ArrayList arrayList = NEW_CURRENT_RIDING_TAGS = this.CURRENT_RIDING_TAG != null ? Lists.newArrayList((Iterable)this.CURRENT_RIDING_TAG.m_128431_()) : Lists.newArrayList();
            if (!NEW_CURRENT_RIDING_TAGS.equals(this.CURRENT_RIDING_TAGS)) {
                this.CURRENT_RIDING_TAGS = NEW_CURRENT_RIDING_TAGS;
            }
            this.CURRENT_RIDING_NAME = NEW_CURRENT_RIDING_NAME;
        }
        if (hasTargetChanged || hasAttackingChanged || hasRidingChanged) {
            this.allEntitiesEmpty = this.CURRENT_TARGET == null && this.CURRENT_ATTACKING == null && this.CURRENT_RIDING == null;
            this.updateEntityPresence();
        }
    }

    public void updateEntityPresence() {
        String defaultEntityTargetMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String defaultEntityAttackingMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityAttackingMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String defaultEntityRidingMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String targetEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityTargetMessages, this.CURRENT_TARGET_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityTargetMessage);
        String attackingEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityAttackingMessages, this.CURRENT_ATTACKING_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityAttackingMessage);
        String ridingEntityMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.entityRidingMessages, this.CURRENT_RIDING_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultEntityRidingMessage);
        ArrayList entityTargetArgs = Lists.newArrayList();
        ArrayList entityAttackingArgs = Lists.newArrayList();
        ArrayList entityRidingArgs = Lists.newArrayList();
        entityTargetArgs.add(new Pair<String, String>("&entity&", this.CURRENT_TARGET_NAME));
        entityAttackingArgs.add(new Pair<String, String>("&entity&", this.CURRENT_ATTACKING_NAME));
        entityRidingArgs.add(new Pair<String, String>("&entity&", this.CURRENT_RIDING_NAME));
        if (!this.CURRENT_TARGET_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_TARGET_TAGS) {
                entityTargetArgs.add(new Pair<CallSite, String>((CallSite)((Object)("&" + tagName + "&")), this.CURRENT_TARGET_TAG.m_128423_(tagName).toString()));
            }
        }
        if (!this.CURRENT_ATTACKING_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_ATTACKING_TAGS) {
                entityAttackingArgs.add(new Pair<CallSite, String>((CallSite)((Object)("&" + tagName + "&")), this.CURRENT_ATTACKING_TAG.m_128423_(tagName).toString()));
            }
        }
        if (!this.CURRENT_RIDING_TAGS.isEmpty()) {
            for (String tagName : this.CURRENT_RIDING_TAGS) {
                entityRidingArgs.add(new Pair<CallSite, String>((CallSite)((Object)("&" + tagName + "&")), this.CURRENT_RIDING_TAG.m_128423_(tagName).toString()));
            }
        }
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            entityTargetArgs.addAll(CraftPresence.CLIENT.generalArgs);
            entityAttackingArgs.addAll(CraftPresence.CLIENT.generalArgs);
            entityRidingArgs.addAll(CraftPresence.CLIENT.generalArgs);
        }
        String CURRENT_TARGET_MESSAGE = StringUtils.sequentialReplaceAnyCase(targetEntityMessage, entityTargetArgs);
        String CURRENT_ATTACKING_MESSAGE = StringUtils.sequentialReplaceAnyCase(attackingEntityMessage, entityAttackingArgs);
        String CURRENT_RIDING_MESSAGE = StringUtils.sequentialReplaceAnyCase(ridingEntityMessage, entityRidingArgs);
        if (!this.allEntitiesEmpty) {
            CraftPresence.CLIENT.syncArgument("&TARGETENTITY&", CURRENT_TARGET_MESSAGE, false);
            CraftPresence.CLIENT.syncArgument("&ATTACKINGENTITY&", CURRENT_ATTACKING_MESSAGE, false);
            CraftPresence.CLIENT.syncArgument("&RIDINGENTITY&", CURRENT_RIDING_MESSAGE, false);
        } else if (!this.currentlyCleared) {
            CraftPresence.CLIENT.initArgument("&TARGETENTITY&", "&ATTACKINGENTITY&", "&RIDINGENTITY&");
        }
    }

    public List<String> getListFromName(String name) {
        return name.equalsIgnoreCase(this.CURRENT_TARGET_NAME) ? this.CURRENT_TARGET_TAGS : (name.equalsIgnoreCase(this.CURRENT_ATTACKING_NAME) ? this.CURRENT_ATTACKING_TAGS : (name.equalsIgnoreCase(this.CURRENT_RIDING_NAME) ? this.CURRENT_RIDING_TAGS : Lists.newArrayList()));
    }

    public String generatePlaceholderString(String name, boolean addExtraData, List<String> tags) {
        StringBuilder finalString = new StringBuilder();
        if (!tags.isEmpty()) {
            for (String tagName : tags) {
                String tagValue;
                finalString.append("\n - &").append(tagName).append("&");
                if (!addExtraData || StringUtils.isNullOrEmpty(tagValue = tags.equals(this.CURRENT_TARGET_TAGS) ? this.CURRENT_TARGET_TAG.m_128423_(tagName).toString() : (tags.equals(this.CURRENT_ATTACKING_TAGS) ? this.CURRENT_ATTACKING_TAG.m_128423_(tagName).toString() : (tags.equals(this.CURRENT_RIDING_TAGS) ? this.CURRENT_RIDING_TAG.m_128423_(tagName).toString() : null)))) continue;
                finalString.append(" (Value -> ").append(tagValue).append(")");
            }
        }
        return (!StringUtils.isNullOrEmpty(name) ? name : "None") + " " + (!StringUtils.isNullOrEmpty(finalString.toString()) ? finalString.toString() : "\\n - N/A");
    }

    public void getEntities() {
        String[] part;
        ArrayList defaultEntityTypes = Lists.newArrayList((Iterator)Registry.f_122826_.iterator());
        if (!defaultEntityTypes.isEmpty()) {
            for (EntityType entityLocation : defaultEntityTypes) {
                if (entityLocation == null) continue;
                String entityName = entityLocation.m_20676_().getString();
                Class<?> entityClass = entityLocation.getClass();
                if (!this.ENTITY_NAMES.contains(entityName)) {
                    this.ENTITY_NAMES.add(entityName);
                }
                if (this.ENTITY_CLASSES.contains(entityClass.getName())) continue;
                this.ENTITY_CLASSES.add(entityClass.getName());
            }
        }
        if (CraftPresence.SERVER.enabled) {
            for (PlayerInfo playerInfo : CraftPresence.SERVER.currentPlayerList) {
                String uuidString = playerInfo.m_105312_().getId().toString();
                if (StringUtils.isNullOrEmpty(uuidString) || this.ENTITY_NAMES.contains(uuidString)) continue;
                this.ENTITY_NAMES.add(uuidString);
            }
        }
        for (String entityTargetMessage : CraftPresence.CONFIG.entityTargetMessages) {
            if (StringUtils.isNullOrEmpty(entityTargetMessage) || StringUtils.isNullOrEmpty((part = entityTargetMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        for (String entityAttackingMessage : CraftPresence.CONFIG.entityAttackingMessages) {
            if (StringUtils.isNullOrEmpty(entityAttackingMessage) || StringUtils.isNullOrEmpty((part = entityAttackingMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        for (String entityRidingMessage : CraftPresence.CONFIG.entityRidingMessages) {
            if (StringUtils.isNullOrEmpty(entityRidingMessage) || StringUtils.isNullOrEmpty((part = entityRidingMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.ENTITY_NAMES.contains(part[0])) continue;
            this.ENTITY_NAMES.add(part[0]);
        }
        this.verifyEntities();
    }

    private void verifyEntities() {
    }
}

