/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;

public class PaginatedScreen
extends ExtendedScreen {
    private final Map<Integer, List<GuiEventListener>> paginatedControls = Maps.newHashMap();
    private final Map<Integer, List<ScrollableListControl>> paginatedLists = Maps.newHashMap();
    protected int startPage;
    protected int currentPage = this.startPage = 1;
    protected int maxPages = this.startPage;
    protected ExtendedButtonControl nextPageButton;
    protected ExtendedButtonControl previousPageButton;
    protected ExtendedButtonControl backButton;
    private Runnable onPageChange;

    public PaginatedScreen(Screen parentScreen) {
        super(parentScreen);
    }

    public PaginatedScreen(Screen parentScreen, boolean debugMode) {
        super(parentScreen, debugMode);
    }

    public PaginatedScreen(Screen parentScreen, boolean debugMode, boolean verboseMode) {
        super(parentScreen, debugMode, verboseMode);
    }

    @Override
    public void initializeUi() {
        this.backButton = this.addControl(new ExtendedButtonControl(this.f_96543_ / 2 - 90, this.f_96544_ - 30, 180, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), () -> CraftPresence.GUIS.openScreen(this.parentScreen), new String[0]));
        this.previousPageButton = this.addControl(new ExtendedButtonControl(this.backButton.getControlPosX() - 23, this.f_96544_ - 30, 20, 20, "<", () -> {
            if (this.currentPage > this.startPage) {
                --this.currentPage;
                if (this.onPageChange != null) {
                    this.onPageChange.run();
                }
            }
        }, new String[0]));
        this.nextPageButton = this.addControl(new ExtendedButtonControl(this.backButton.getControlPosX() + this.backButton.getControlWidth() + 3, this.f_96544_ - 30, 20, 20, ">", () -> {
            if (this.currentPage < this.maxPages) {
                ++this.currentPage;
                if (this.onPageChange != null) {
                    this.onPageChange.run();
                }
            }
        }, new String[0]));
        this.previousPageButton.setControlEnabled(this.currentPage > this.startPage);
        this.nextPageButton.setControlEnabled(this.currentPage < this.maxPages);
        super.initializeUi();
    }

    @Nonnull
    protected <T extends GuiEventListener & Widget> T addControl(@Nonnull T buttonIn, int renderTarget) {
        if (!this.paginatedControls.containsKey(renderTarget)) {
            this.paginatedControls.put(renderTarget, Lists.newArrayList((Object[])new GuiEventListener[]{buttonIn}));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            this.paginatedControls.get(renderTarget).add(buttonIn);
        }
        return super.addControl(buttonIn);
    }

    @Nonnull
    protected <T extends ScrollableListControl> T addList(@Nonnull T buttonIn, int renderTarget) {
        if (!this.paginatedLists.containsKey(renderTarget)) {
            this.paginatedLists.put(renderTarget, Lists.newArrayList((Object[])new ScrollableListControl[]{buttonIn}));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            this.paginatedLists.get(renderTarget).add(buttonIn);
        }
        return super.addList(buttonIn);
    }

    @Override
    public void preRender() {
        ArrayList defaultButtons = Lists.newArrayList((Object[])new GuiEventListener[]{this.previousPageButton, this.nextPageButton, this.backButton});
        List<GuiEventListener> elementsToRender = this.paginatedControls.getOrDefault(this.currentPage, defaultButtons);
        List<ScrollableListControl> listsToRender = this.paginatedLists.getOrDefault(this.currentPage, Lists.newArrayList());
        for (GuiEventListener extendedControl : this.extendedControls) {
            if (extendedControl instanceof ExtendedButtonControl) {
                ((ExtendedButtonControl)extendedControl).setControlVisible(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
                ((ExtendedButtonControl)extendedControl).setControlEnabled(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ((ExtendedTextControl)extendedControl).m_94194_(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
            ((ExtendedTextControl)extendedControl).m_94186_(elementsToRender.contains(extendedControl) || defaultButtons.contains(extendedControl));
        }
        for (ScrollableListControl listControl : this.extendedLists) {
            listControl.setVisible(listsToRender.contains((Object)listControl));
        }
        this.previousPageButton.setControlEnabled(this.currentPage > this.startPage);
        this.nextPageButton.setControlEnabled(this.currentPage < this.maxPages);
    }

    @Override
    public boolean m_7933_(int keyCode, int mouseX, int mouseY) {
        if (keyCode == 265 && this.currentPage > this.startPage) {
            --this.currentPage;
        }
        if (keyCode == 264 && this.currentPage < this.maxPages) {
            ++this.currentPage;
        }
        return super.m_7933_(keyCode, mouseX, mouseY);
    }

    public void renderString(String text, float xPos, float yPos, int color, int renderTarget) {
        if (renderTarget == this.currentPage) {
            this.getFontRenderer().m_92750_(this.currentMatrix, text, xPos, yPos, color);
        }
    }

    public void setOnPageChange(Runnable onPageChange) {
        this.onPageChange = onPageChange;
    }
}

