/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXDatagramSocketImpl;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AFUNIXSocketExtensions;
import org.newsclub.net.unix.AFUNIXSomeSocket;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.NativeUnixSocket;

public final class AFUNIXDatagramSocket
extends DatagramSocket
implements AFUNIXSomeSocket,
AFUNIXSocketExtensions {
    private static final InetSocketAddress WILDCARD_ADDRESS = new InetSocketAddress(0);
    private final AFUNIXDatagramSocketImpl impl;
    private final AncillaryDataSupport ancillaryDataSupport;
    private final AtomicBoolean created = new AtomicBoolean(false);
    private final AtomicBoolean deleteOnClose = new AtomicBoolean(true);
    private final AFUNIXDatagramChannel channel = new AFUNIXDatagramChannel(this);

    private AFUNIXDatagramSocket(AFUNIXDatagramSocketImpl impl) throws IOException {
        super(impl);
        this.impl = impl;
        this.ancillaryDataSupport = impl.ancillaryDataSupport;
    }

    public static AFUNIXDatagramSocket newInstance() throws IOException {
        return new AFUNIXDatagramSocket(new AFUNIXDatagramSocketImpl(null));
    }

    static AFUNIXDatagramSocket newInstance(FileDescriptor fdObj, int localPort, int remotePort) throws IOException {
        if (fdObj == null) {
            return AFUNIXDatagramSocket.newInstance();
        }
        if (!fdObj.valid()) {
            throw new SocketException("Invalid file descriptor");
        }
        int status = NativeUnixSocket.socketStatus(fdObj);
        if (status == -1) {
            throw new SocketException("Not a valid socket");
        }
        AFUNIXDatagramSocket socket = new AFUNIXDatagramSocket(new AFUNIXDatagramSocketImpl(fdObj));
        socket.getAFImpl().updatePorts(localPort, remotePort);
        switch (status) {
            case 2: {
                socket.internalDummyConnect();
                break;
            }
            case 1: {
                socket.internalDummyBind();
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Invalid socketStatus response: " + status);
            }
        }
        return socket;
    }

    @Override
    public void connect(InetAddress address, int port) {
        throw new IllegalArgumentException("Cannot connect to InetAddress");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peek(DatagramPacket p) throws IOException {
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.getAFImpl().peekData(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(DatagramPacket p) throws IOException {
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (!this.isBound()) {
                this.internalDummyBind();
            }
            this.getAFImpl().send(p);
        }
    }

    void internalDummyConnect() throws SocketException {
        super.connect(AFUNIXSocketAddress.INTERNAL_DUMMY_DONT_CONNECT);
    }

    void internalDummyBind() throws SocketException {
        this.bind(AFUNIXSocketAddress.INTERNAL_DUMMY_BIND);
    }

    @Override
    public synchronized void connect(SocketAddress addr) throws SocketException {
        if (!this.isBound()) {
            this.internalDummyBind();
        }
        this.internalDummyConnect();
        try {
            this.getAFImpl().connect(AFUNIXSocketAddress.preprocessSocketAddress(addr, null));
        }
        catch (SocketException e) {
            throw e;
        }
        catch (IOException e) {
            throw (SocketException)new SocketException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public synchronized AFUNIXSocketAddress getRemoteSocketAddress() {
        return this.getAFImpl().getRemoteSocketAddress();
    }

    @Override
    public boolean isConnected() {
        return super.isConnected() || this.impl.isConnected();
    }

    @Override
    public boolean isBound() {
        return super.isBound() || this.impl.isBound();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        InetAddress addr;
        if (this.isClosed()) {
            return;
        }
        this.getAFImpl().close();
        boolean wasBound = this.isBound();
        if (wasBound && this.deleteOnClose.get() && AFUNIXSocketAddress.isSupportedAddress(addr = this.getLocalAddress())) {
            try {
                AFUNIXSocketAddress socketAddress = AFUNIXSocketAddress.unwrap(addr, 0);
                if (socketAddress.hasFilename() && socketAddress.getFile().delete()) {
                    // empty if block
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
    }

    @Override
    public synchronized void bind(SocketAddress addr) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            if (addr == AFUNIXSocketAddress.INTERNAL_DUMMY_BIND) {
                return;
            }
            throw new SocketException("already bound");
        }
        super.bind(AFUNIXSocketAddress.INTERNAL_DUMMY_BIND);
        if (addr == null || WILDCARD_ADDRESS.equals(addr)) {
            return;
        }
        AFUNIXSocketAddress epoint = AFUNIXSocketAddress.preprocessSocketAddress(addr, null);
        try {
            this.getAFImpl().bind(epoint);
        }
        catch (SocketException e) {
            this.getAFImpl().close();
            throw e;
        }
    }

    @Override
    public AFUNIXSocketAddress getLocalSocketAddress() {
        if (this.isClosed()) {
            return null;
        }
        if (!this.isBound()) {
            return null;
        }
        try {
            return AFUNIXSocketAddress.unwrap(this.getLocalAddress(), this.getLocalPort());
        }
        catch (SocketException e) {
            return null;
        }
    }

    public boolean isDeleteOnClose() {
        return this.deleteOnClose.get();
    }

    public void setDeleteOnClose(boolean b) {
        this.deleteOnClose.set(b);
    }

    AFUNIXDatagramSocketImpl getAFImpl() {
        if (this.created.compareAndSet(false, true)) {
            try {
                this.getSoTimeout();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return this.impl;
    }

    @Override
    public int getAncillaryReceiveBufferSize() {
        return this.ancillaryDataSupport.getAncillaryReceiveBufferSize();
    }

    @Override
    public void setAncillaryReceiveBufferSize(int size) {
        this.ancillaryDataSupport.setAncillaryReceiveBufferSize(size);
    }

    @Override
    public void ensureAncillaryReceiveBufferSize(int minSize) {
        this.ancillaryDataSupport.ensureAncillaryReceiveBufferSize(minSize);
    }

    @Override
    public FileDescriptor[] getReceivedFileDescriptors() throws IOException {
        return this.ancillaryDataSupport.getReceivedFileDescriptors();
    }

    @Override
    public void clearReceivedFileDescriptors() {
        this.ancillaryDataSupport.clearReceivedFileDescriptors();
    }

    @Override
    public void setOutboundFileDescriptors(FileDescriptor ... fdescs) throws IOException {
        if (fdescs != null && fdescs.length > 0 && !this.isConnected()) {
            throw new SocketException("Not connected");
        }
        this.ancillaryDataSupport.setOutboundFileDescriptors(fdescs);
    }

    @Override
    public boolean hasOutboundFileDescriptors() {
        return this.ancillaryDataSupport.hasOutboundFileDescriptors();
    }

    @Override
    public AFUNIXSocketCredentials getPeerCredentials() throws IOException {
        if (this.isClosed() || !this.isConnected()) {
            throw new SocketException("Not connected");
        }
        return this.impl.getPeerCredentials();
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this.getAFImpl().isClosed();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFUNIXDatagramChannel getChannel() {
        return this.channel;
    }

    @Override
    public FileDescriptor getFileDescriptor() throws IOException {
        return this.getAFImpl().getFileDescriptor();
    }
}

