/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.newsclub.net.unix.AFUNIXInetAddress;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCore;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AFUNIXSocketImpl;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.NativeUnixSocket;

final class AFUNIXDatagramSocketImpl
extends DatagramSocketImpl {
    private final AFUNIXSocketCore core;
    final AncillaryDataSupport ancillaryDataSupport = new AncillaryDataSupport();
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final AtomicBoolean bound = new AtomicBoolean(false);
    private final AtomicInteger socketTimeout = new AtomicInteger(0);
    private int remotePort = 0;

    AFUNIXDatagramSocketImpl(FileDescriptor fd) throws IOException {
        this.core = new AFUNIXSocketCore(this, fd, this.ancillaryDataSupport);
        this.fd = this.core.fd;
    }

    @Override
    protected void create() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Already closed");
        }
        if (this.fd.valid()) {
            return;
        }
        try {
            NativeUnixSocket.createSocket(this.fd, 2);
        }
        catch (SocketException e) {
            throw e;
        }
        catch (IOException e) {
            throw (SocketException)new SocketException(e.getMessage()).initCause(e);
        }
    }

    @Override
    protected void close() {
        this.core.runCleaner();
    }

    @Override
    protected void connect(InetAddress address, int port) throws SocketException {
    }

    void connect(AFUNIXSocketAddress socketAddress) throws IOException {
        if (socketAddress == AFUNIXSocketAddress.INTERNAL_DUMMY_CONNECT) {
            return;
        }
        NativeUnixSocket.connect(socketAddress.getBytes(), this.fd, -1L);
        this.remotePort = socketAddress.getPort();
    }

    @Override
    protected void disconnect() {
        try {
            NativeUnixSocket.disconnect(this.fd);
            this.connected.set(false);
            this.remotePort = 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    AFUNIXSocketCore getCore() {
        return this.core;
    }

    @Override
    protected FileDescriptor getFileDescriptor() {
        return this.core.fd;
    }

    boolean isClosed() {
        return this.core.isClosed();
    }

    @Override
    protected void bind(int lport, InetAddress laddr) throws SocketException {
    }

    void bind(AFUNIXSocketAddress socketAddress) throws SocketException {
        if (socketAddress == AFUNIXSocketAddress.INTERNAL_DUMMY_BIND) {
            return;
        }
        try {
            NativeUnixSocket.bind(socketAddress.getBytes(), this.fd, 0);
            this.localPort = socketAddress.getPort();
        }
        catch (SocketException e) {
            throw e;
        }
        catch (IOException e) {
            throw (SocketException)new SocketException(e.getMessage()).initCause(e);
        }
    }

    @Override
    protected void receive(DatagramPacket p) throws IOException {
        this.recv(p, 0);
    }

    private void recv(DatagramPacket p, int options) throws IOException {
        ByteBuffer socketAddressBuffer;
        ByteBuffer datagramPacketBuffer;
        int len = p.getLength();
        FileDescriptor fdesc = this.core.validFdOrException();
        int count = NativeUnixSocket.receive(fdesc, datagramPacketBuffer = this.core.getThreadLocalDirectByteBuffer(len), 0, len = Math.min(len, datagramPacketBuffer.capacity()), socketAddressBuffer = AFUNIXSocketAddress.SOCKETADDRESS_BUFFER_TL.get(), options, this.ancillaryDataSupport, this.socketTimeout.get());
        if (count > len || count < 0) {
            throw new IllegalStateException();
        }
        datagramPacketBuffer.limit(count);
        datagramPacketBuffer.rewind();
        datagramPacketBuffer.get(p.getData(), p.getOffset(), count);
        p.setLength(count);
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofInternal(socketAddressBuffer);
        p.setAddress(addr == null ? null : addr.getInetAddress());
        p.setPort(this.remotePort);
    }

    @Override
    protected void send(DatagramPacket p) throws IOException {
        byte[] addrBytes;
        InetAddress addr = p.getAddress();
        ByteBuffer sendToBuf = null;
        if (addr != null && (addrBytes = AFUNIXInetAddress.unwrapAddress(addr)) != null) {
            sendToBuf = AFUNIXSocketAddress.SOCKETADDRESS_BUFFER_TL.get();
            NativeUnixSocket.bytesToSockAddrUn(sendToBuf, addrBytes);
        }
        FileDescriptor fdesc = this.core.validFdOrException();
        int len = p.getLength();
        ByteBuffer datagramPacketBuffer = this.core.getThreadLocalDirectByteBuffer(len);
        datagramPacketBuffer.clear();
        datagramPacketBuffer.put(p.getData(), p.getOffset(), p.getLength());
        NativeUnixSocket.send(fdesc, datagramPacketBuffer, 0, len, sendToBuf, 4, this.ancillaryDataSupport);
    }

    @Override
    protected int peek(InetAddress i) throws IOException {
        throw new SocketException("Unsupported operation");
    }

    @Override
    protected int peekData(DatagramPacket p) throws IOException {
        this.recv(p, 2);
        return 0;
    }

    @Override
    protected byte getTTL() throws IOException {
        return (byte)(this.getTimeToLive() & 0xFF);
    }

    @Override
    protected void setTTL(byte ttl) throws IOException {
    }

    @Override
    protected int getTimeToLive() throws IOException {
        return 0;
    }

    @Override
    protected void setTimeToLive(int ttl) throws IOException {
    }

    @Override
    protected void join(InetAddress inetaddr) throws IOException {
        throw new SocketException("Unsupported");
    }

    @Override
    protected void leave(InetAddress inetaddr) throws IOException {
        throw new SocketException("Unsupported");
    }

    @Override
    protected void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        throw new SocketException("Unsupported");
    }

    @Override
    protected void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        throw new SocketException("Unsupported");
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        FileDescriptor fdesc = this.core.validFdOrException();
        return AFUNIXSocketImpl.getOptionDefault(fdesc, optID, this.socketTimeout);
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        FileDescriptor fdesc = this.core.validFdOrException();
        AFUNIXSocketImpl.setOptionDefault(fdesc, optID, value, this.socketTimeout);
    }

    AFUNIXSocketCredentials getPeerCredentials() throws IOException {
        return NativeUnixSocket.peerCredentials(this.fd, new AFUNIXSocketCredentials());
    }

    AFUNIXSocketAddress receive(ByteBuffer dst) throws IOException {
        return this.core.receive(dst);
    }

    int send(ByteBuffer src, SocketAddress target) throws IOException {
        return this.core.write(src, target, 0);
    }

    int read(ByteBuffer dst, ByteBuffer socketAddressBuffer) throws IOException {
        return this.core.read(dst, socketAddressBuffer, 0);
    }

    int write(ByteBuffer src) throws IOException {
        return this.core.write(src);
    }

    boolean isConnected() {
        if (this.connected.get()) {
            return true;
        }
        if (this.isClosed()) {
            return false;
        }
        if (this.core.isConnected(false)) {
            this.connected.set(true);
            return true;
        }
        return false;
    }

    boolean isBound() {
        if (this.bound.get()) {
            return true;
        }
        if (this.isClosed()) {
            return false;
        }
        if (this.core.isConnected(true)) {
            this.bound.set(true);
            return true;
        }
        return false;
    }

    void updatePorts(int local, int remote) {
        this.localPort = local;
        this.remotePort = remote;
    }

    AFUNIXSocketAddress getLocalSocketAddress() {
        return AFUNIXSocketAddress.getSocketAddress(this.getFileDescriptor(), false, this.localPort);
    }

    AFUNIXSocketAddress getRemoteSocketAddress() {
        return AFUNIXSocketAddress.getSocketAddress(this.getFileDescriptor(), true, this.remotePort);
    }
}

