/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;

class AFUNIXInetAddress {
    private static final byte[] SERIALIZED_INET_ADDRESS_START = new byte[]{-84, -19, 0, 5, 115, 114, 0, 20, 106, 97, 118, 97, 46, 110, 101, 116, 46, 73, 110, 101, 116, 65, 100, 100, 114, 101, 115, 115, 45, -101, 87, -81, -97, -29, -21, -37, 3, 0, 3, 73, 0, 7, 97, 100, 100, 114, 101, 115, 115, 73, 0, 6, 102, 97, 109, 105, 108, 121, 76, 0, 8, 104, 111, 115, 116, 78, 97, 109, 101, 116, 0, 18, 76, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 59, 120, 112, 127, 0, 0, -81, 0, 0, 0, 1, 116, 0};
    private static final char PREFIX = '[';
    private static final String V1_SUFFIX = ".un.junixsocket";

    AFUNIXInetAddress() {
    }

    static final String createUnresolvedHostname(byte[] socketAddress) {
        StringBuilder sb = new StringBuilder(1 + socketAddress.length + V1_SUFFIX.length());
        sb.append('[');
        sb.append(new String(socketAddress, StandardCharsets.ISO_8859_1));
        sb.append(V1_SUFFIX);
        return sb.toString();
    }

    static final InetAddress wrapAddress(byte[] socketAddress) {
        InetAddress inetAddress;
        if (socketAddress == null || socketAddress.length == 0) {
            return null;
        }
        byte[] bytes = AFUNIXInetAddress.createUnresolvedHostname(socketAddress).getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 255) {
            throw new IllegalStateException("Address too long");
        }
        byte[] serializedData = new byte[SERIALIZED_INET_ADDRESS_START.length + 1 + bytes.length + 1];
        System.arraycopy(SERIALIZED_INET_ADDRESS_START, 0, serializedData, 0, SERIALIZED_INET_ADDRESS_START.length);
        serializedData[AFUNIXInetAddress.SERIALIZED_INET_ADDRESS_START.length] = (byte)bytes.length;
        System.arraycopy(bytes, 0, serializedData, SERIALIZED_INET_ADDRESS_START.length + 1, bytes.length);
        serializedData[serializedData.length - 1] = 120;
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(serializedData));
        try {
            inetAddress = (InetAddress)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        ois.close();
        return inetAddress;
    }

    static final byte[] unwrapAddress(InetAddress addr) throws SocketException {
        if (!AFUNIXInetAddress.isSupportedAddress(addr)) {
            throw new SocketException("Unsupported address");
        }
        String hostname = addr.getHostName();
        byte[] bytes = hostname.substring(1, hostname.length() - V1_SUFFIX.length()).getBytes(StandardCharsets.ISO_8859_1);
        return bytes;
    }

    static boolean isSupportedAddress(InetAddress addr) {
        return addr instanceof Inet4Address && addr.isLoopbackAddress() && addr.getHostName().endsWith(V1_SUFFIX);
    }
}

