/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.newsclub.net.unix.NativeUnixSocket;

class AncillaryDataSupport
implements Closeable {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    protected final Map<FileDescriptor, Integer> openReceivedFileDescriptors = Collections.synchronizedMap(new HashMap());
    private final List<FileDescriptor[]> receivedFileDescriptors = Collections.synchronizedList(new LinkedList());
    protected ByteBuffer ancillaryReceiveBuffer = EMPTY_BUFFER;
    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    int[] pendingFileDescriptors = null;

    AncillaryDataSupport() {
    }

    int getAncillaryReceiveBufferSize() {
        return this.ancillaryReceiveBuffer.capacity();
    }

    void setAncillaryReceiveBufferSize(int size) {
        if (size == this.ancillaryReceiveBuffer.capacity()) {
            return;
        }
        if (size <= 0) {
            this.ancillaryReceiveBuffer = EMPTY_BUFFER;
        } else {
            this.setAncillaryReceiveBufferSize0(Math.max(256, size));
        }
    }

    void setAncillaryReceiveBufferSize0(int size) {
        this.ancillaryReceiveBuffer = ByteBuffer.allocateDirect(size);
    }

    public final void ensureAncillaryReceiveBufferSize(int minSize) {
        if (minSize <= 0) {
            return;
        }
        if (this.ancillaryReceiveBuffer.capacity() < minSize) {
            this.setAncillaryReceiveBufferSize(minSize);
        }
    }

    void receiveFileDescriptors(int[] fds) throws IOException {
        if (fds == null || fds.length == 0) {
            return;
        }
        int fdsLength = fds.length;
        FileDescriptor[] descriptors = new FileDescriptor[fdsLength];
        for (int i = 0; i < fdsLength; ++i) {
            final FileDescriptor fdesc = new FileDescriptor();
            NativeUnixSocket.initFD(fdesc, fds[i]);
            descriptors[i] = fdesc;
            this.openReceivedFileDescriptors.put(fdesc, fds[i]);
            Closeable cleanup = new Closeable(){

                @Override
                public void close() throws IOException {
                    AncillaryDataSupport.this.openReceivedFileDescriptors.remove(fdesc);
                }
            };
            NativeUnixSocket.attachCloseable(fdesc, cleanup);
        }
        this.receivedFileDescriptors.add(descriptors);
    }

    final void clearReceivedFileDescriptors() {
        this.receivedFileDescriptors.clear();
    }

    FileDescriptor[] getReceivedFileDescriptors() {
        if (this.receivedFileDescriptors.isEmpty()) {
            return null;
        }
        ArrayList<FileDescriptor[]> copy = new ArrayList<FileDescriptor[]>(this.receivedFileDescriptors);
        if (copy.isEmpty()) {
            return null;
        }
        this.receivedFileDescriptors.removeAll(copy);
        int count = 0;
        for (FileDescriptor[] fds : copy) {
            count += fds.length;
        }
        if (count == 0) {
            return null;
        }
        FileDescriptor[] oneArray = new FileDescriptor[count];
        int offset = 0;
        for (FileDescriptor[] fds : copy) {
            System.arraycopy(fds, 0, oneArray, offset, fds.length);
            offset += fds.length;
        }
        return oneArray;
    }

    void setOutboundFileDescriptors(int[] fds) {
        this.pendingFileDescriptors = fds == null || fds.length == 0 ? null : fds;
    }

    boolean hasOutboundFileDescriptors() {
        return this.pendingFileDescriptors != null;
    }

    void setOutboundFileDescriptors(FileDescriptor ... fdescs) throws IOException {
        int[] fds;
        if (fdescs == null || fdescs.length == 0) {
            fds = null;
        } else {
            int numFdescs = fdescs.length;
            fds = new int[numFdescs];
            for (int i = 0; i < numFdescs; ++i) {
                FileDescriptor fdesc = fdescs[i];
                fds[i] = NativeUnixSocket.getFD(fdesc);
            }
        }
        this.setOutboundFileDescriptors(fds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<FileDescriptor, Integer> map = this.openReceivedFileDescriptors;
        synchronized (map) {
            for (FileDescriptor desc : this.openReceivedFileDescriptors.keySet()) {
                try {
                    NativeUnixSocket.close(desc);
                }
                catch (Exception exception) {}
            }
        }
    }
}

