/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.handler;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.config.ServerConfig;
import fuzs.pickupnotifier.network.message.S2CTakeItemMessage;
import fuzs.pickupnotifier.network.message.S2CTakeItemStackMessage;
import fuzs.puzzleslib.network.message.Message;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemPickupHandler {
    private ItemStack cachedStack = ItemStack.f_41583_;

    @SubscribeEvent
    public void onEntityItemPickup1(EntityItemPickupEvent evt) {
        if (((ServerConfig)PickUpNotifier.CONFIG.server()).backpackCompat && !evt.getItem().m_32055_().m_41619_() && !evt.getItem().m_146910_()) {
            this.cachedStack = evt.getItem().m_32055_().m_41777_();
        }
    }

    @SubscribeEvent
    public void onEntityItemPickup2(EntityItemPickupEvent evt) {
        ItemEntity item = evt.getItem();
        Player player = evt.getPlayer();
        ItemStack stack = item.m_32055_();
        if (((ServerConfig)PickUpNotifier.CONFIG.server()).backpackCompat && evt.isCanceled()) {
            if (!this.cachedStack.m_41619_()) {
                boolean sendTakeMessage = false;
                int takeAmount = this.cachedStack.m_41613_() - stack.m_41613_();
                if (takeAmount > 0) {
                    this.cachedStack.m_41764_(takeAmount);
                    sendTakeMessage = true;
                } else if (evt.getItem().m_146910_()) {
                    sendTakeMessage = true;
                }
                if (sendTakeMessage) {
                    PickUpNotifier.NETWORK.sendTo((Message)new S2CTakeItemStackMessage(this.cachedStack), (ServerPlayer)player);
                }
            }
            this.cachedStack = ItemStack.f_41583_;
        } else if (((ServerConfig)PickUpNotifier.CONFIG.server()).partialPickUps && !item.m_146910_() && !item.m_32063_() && (item.m_32056_() == null || item.lifespan - item.m_32059_() <= 200 || item.m_32056_().equals(player.m_142081_()))) {
            int itemAmount = 0;
            if (player.m_150109_().m_36062_() != -1) {
                itemAmount = stack.m_41613_();
            } else {
                int slotWithRemainingSpace = player.m_150109_().m_36050_(stack);
                if (slotWithRemainingSpace != -1) {
                    itemAmount = this.getSpaceAtIndex(player.m_150109_(), slotWithRemainingSpace, stack);
                }
            }
            if (itemAmount > 0) {
                PickUpNotifier.NETWORK.sendTo((Message)new S2CTakeItemMessage(item.m_142049_(), itemAmount), (ServerPlayer)player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerItemPickup(PlayerEvent.ItemPickupEvent evt) {
        if (!((ServerConfig)PickUpNotifier.CONFIG.server()).partialPickUps && !evt.getOriginalEntity().m_146910_()) {
            PickUpNotifier.NETWORK.sendTo((Message)new S2CTakeItemMessage(evt.getOriginalEntity().m_142049_(), evt.getStack().m_41613_()), (ServerPlayer)evt.getPlayer());
        }
    }

    private int getSpaceAtIndex(Inventory inventory, int slotIndex, ItemStack stack) {
        int itemCount = stack.m_41613_();
        ItemStack itemstack = inventory.m_8020_(slotIndex);
        int itemSpace = itemCount;
        if (itemCount > itemstack.m_41741_() - itemstack.m_41613_()) {
            itemSpace = itemstack.m_41741_() - itemstack.m_41613_();
        }
        if (itemSpace > inventory.m_6893_() - itemstack.m_41613_()) {
            itemSpace = inventory.m_6893_() - itemstack.m_41613_();
        }
        return itemSpace;
    }
}

