/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.crafting;

import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.crafting.AlienTradingRecipeItemStackBase;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeSerializer;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeTypes;
import net.mrscauthd.beyond_earth.registries.RecipeSerializersRegistry;
import net.mrscauthd.beyond_earth.utils.EnumUtils;
import org.apache.commons.lang3.tuple.Triple;

public class AlienTradingRecipeMap
extends AlienTradingRecipeItemStackBase {
    private ResourceLocation structureName;
    private MapDecoration.Type mapDecorationType;
    public static final TagKey<EntityType<?>> OXYGEN_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("beyond_earth", "entities/oxygen"));

    public AlienTradingRecipeMap(ResourceLocation id, JsonObject json) {
        super(id, json);
        JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        this.structureName = new ResourceLocation(GsonHelper.m_13906_((JsonObject)result, (String)"structureName"));
        this.mapDecorationType = EnumUtils.valueOfIgnoreCase(MapDecoration.Type.class, GsonHelper.m_13906_((JsonObject)result, (String)"mapDecorationType"));
    }

    public AlienTradingRecipeMap(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
        this.structureName = buffer.m_130281_();
        this.mapDecorationType = (MapDecoration.Type)buffer.m_130066_(MapDecoration.Type.class);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.m_130085_(this.structureName);
        buffer.m_130068_((Enum)this.mapDecorationType);
    }

    @Override
    public Triple<ItemStack, ItemStack, ItemStack> getTrade(Entity trader, Random rand) {
        Level level = trader.f_19853_;
        StructureFeature structure = (StructureFeature)ForgeRegistries.STRUCTURE_FEATURES.getValue(this.getStructureName());
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42573_);
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            BlockPos blockpos = serverWorld.m_207561_(TagKey.m_203882_((ResourceKey)Registry.f_122882_, (ResourceLocation)structure.getRegistryName()), trader.m_142538_(), 100, true);
            if (blockpos != null) {
                itemstack = MapItem.m_42886_((Level)level, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.getMapDecorationType());
            }
            MapItem.m_42850_((ServerLevel)serverWorld, (ItemStack)itemstack);
        }
        itemstack.m_41714_((Component)new TranslatableComponent("filled_map." + structure.getRegistryName().toString().toLowerCase(Locale.ROOT)));
        return Triple.of((Object)this.getCostA(), (Object)this.getCostB(), (Object)itemstack);
    }

    public ResourceLocation getStructureName() {
        return this.structureName;
    }

    public MapDecoration.Type getMapDecorationType() {
        return this.mapDecorationType;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersRegistry.RECIPE_SERIALIZER_ALIEN_TRADING_MAP.get();
    }

    public RecipeType<?> m_6671_() {
        return BeyondEarthRecipeTypes.ALIEN_TRADING_MAP;
    }

    public static class Serializer
    extends BeyondEarthRecipeSerializer<AlienTradingRecipeMap> {
        public AlienTradingRecipeMap fromJson(ResourceLocation id, JsonObject json) {
            return new AlienTradingRecipeMap(id, json);
        }

        public AlienTradingRecipeMap fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new AlienTradingRecipeMap(id, buffer);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlienTradingRecipeMap recipe) {
            recipe.write(buffer);
        }
    }
}

