/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.entities.renderer.globe;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.entities.renderer.globe.GlobeModel;
import net.mrscauthd.beyond_earth.globe.GlobeBlock;
import net.mrscauthd.beyond_earth.globe.GlobeTileEntity;
import net.mrscauthd.beyond_earth.registries.BlocksRegistry;
import net.mrscauthd.beyond_earth.registries.ItemsRegistry;

@OnlyIn(value=Dist.CLIENT)
public class GlobeRenderer<T extends GlobeTileEntity>
extends BlockEntityWithoutLevelRenderer
implements BlockEntityRenderer<GlobeTileEntity>,
BlockEntityRendererProvider<T> {
    public static final ResourceLocation EARTH_GLOBE = new ResourceLocation("beyond_earth", "textures/blocks/globes/earth_globe.png");
    public static final ResourceLocation MOON_GLOBE = new ResourceLocation("beyond_earth", "textures/blocks/globes/moon_globe.png");
    public static final ResourceLocation MARS_GLOBE = new ResourceLocation("beyond_earth", "textures/blocks/globes/mars_globe.png");
    public static final ResourceLocation MERCURY_GLOBE = new ResourceLocation("beyond_earth", "textures/blocks/globes/mercury_globe.png");
    public static final ResourceLocation VENUS_GLOBE = new ResourceLocation("beyond_earth", "textures/blocks/globes/venus_globe.png");
    public static final ResourceLocation GLACIO_GLOBE = new ResourceLocation("beyond_earth", "textures/blocks/globes/glacio_globe.png");
    private GlobeModel model;
    private GlobeModel itemModel;

    public GlobeRenderer(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
    }

    public void render(GlobeTileEntity p_112307_, float particleTicks, PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLight, int p_112312_) {
        if (!(p_112307_.m_58904_().m_8055_(p_112307_.m_58899_()).m_60734_() instanceof GlobeBlock)) {
            return;
        }
        BlockState blockstate = p_112307_.m_58900_();
        Direction direction = (Direction)blockstate.m_61143_((Property)GlobeBlock.FACING);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 1.5, 0.5);
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(direction.m_122435_()));
        this.model.setupAnim(p_112307_, particleTicks);
        VertexConsumer vertexBuilder = blockstate.m_60713_((Block)BlocksRegistry.EARTH_GLOBE_BLOCK.get()) ? buffer.m_6299_(RenderType.m_110464_((ResourceLocation)EARTH_GLOBE)) : (blockstate.m_60713_((Block)BlocksRegistry.MOON_GLOBE_BLOCK.get()) ? buffer.m_6299_(RenderType.m_110464_((ResourceLocation)MOON_GLOBE)) : (blockstate.m_60713_((Block)BlocksRegistry.MARS_GLOBE_BLOCK.get()) ? buffer.m_6299_(RenderType.m_110464_((ResourceLocation)MARS_GLOBE)) : (blockstate.m_60713_((Block)BlocksRegistry.MERCURY_GLOBE_BLOCK.get()) ? buffer.m_6299_(RenderType.m_110464_((ResourceLocation)MERCURY_GLOBE)) : (blockstate.m_60713_((Block)BlocksRegistry.VENUS_GLOBE_BLOCK.get()) ? buffer.m_6299_(RenderType.m_110464_((ResourceLocation)VENUS_GLOBE)) : buffer.m_6299_(RenderType.m_110464_((ResourceLocation)GLACIO_GLOBE))))));
        this.model.m_7695_(matrixStackIn, vertexBuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }

    public void m_108829_(ItemStack p_108830_, ItemTransforms.TransformType p_108831_, PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLight, int p_108835_) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 1.5, 0.5);
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        VertexConsumer vertexBuilder = p_108830_.m_150930_((Item)ItemsRegistry.EARTH_GLOBE_ITEM.get()) ? buffer.m_6299_(RenderType.m_110464_((ResourceLocation)EARTH_GLOBE)) : (p_108830_.m_150930_((Item)ItemsRegistry.MOON_GLOBE_ITEM.get()) ? buffer.m_6299_(RenderType.m_110464_((ResourceLocation)MOON_GLOBE)) : (p_108830_.m_150930_((Item)ItemsRegistry.MARS_GLOBE_ITEM.get()) ? buffer.m_6299_(RenderType.m_110464_((ResourceLocation)MARS_GLOBE)) : (p_108830_.m_150930_((Item)ItemsRegistry.MERCURY_GLOBE_ITEM.get()) ? buffer.m_6299_(RenderType.m_110464_((ResourceLocation)MERCURY_GLOBE)) : (p_108830_.m_150930_((Item)ItemsRegistry.VENUS_GLOBE_ITEM.get()) ? buffer.m_6299_(RenderType.m_110464_((ResourceLocation)VENUS_GLOBE)) : buffer.m_6299_(RenderType.m_110464_((ResourceLocation)GLACIO_GLOBE))))));
        if (this.itemModel == null) {
            this.itemModel = new GlobeModel(mc.m_167973_().m_171103_(GlobeModel.LAYER_LOCATION));
        }
        if (level != null && !mc.m_91104_()) {
            this.itemModel.globe.m_171324_((String)"planet").f_104204_ = ((float)level.m_46467_() + mc.m_91296_()) / -20.0f;
        }
        this.itemModel.m_7695_(matrixStackIn, vertexBuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }

    public BlockEntityRenderer<T> m_173570_(BlockEntityRendererProvider.Context p_173571_) {
        this.model = new GlobeModel(p_173571_.m_173582_(GlobeModel.LAYER_LOCATION));
        return this::render;
    }
}

