/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.events;

import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.events.forgeevents.LivingGravityEvent;

public class Gravity {
    public static void gravity(LivingEntity entity, GravityType type, Level world) {
        float moon = 0.03f;
        float mars = 0.04f;
        float mercury = 0.03f;
        float venus = 0.04f;
        float orbit = 0.02f;
        if (Methods.isWorld(world, Methods.moon)) {
            Gravity.gravityMath(type, entity, moon);
        } else if (Methods.isWorld(world, Methods.mars)) {
            Gravity.gravityMath(type, entity, mars);
        } else if (Methods.isWorld(world, Methods.glacio)) {
            Gravity.gravityMath(type, entity, mars);
        } else if (Methods.isWorld(world, Methods.mercury)) {
            Gravity.gravityMath(type, entity, mercury);
        } else if (Methods.isWorld(world, Methods.venus)) {
            Gravity.gravityMath(type, entity, venus);
        } else if (Methods.isOrbitWorld(world)) {
            Gravity.gravityMath(type, entity, orbit);
        }
    }

    public static boolean playerGravityCheck(Player player) {
        return !player.m_150110_().f_35935_ && !player.m_21255_() && !player.m_20069_() && !player.m_20077_() && !player.m_20068_() && !player.m_21023_(MobEffects.f_19591_) && !player.m_21023_(MobEffects.f_19620_);
    }

    public static boolean livingGravityCheck(LivingEntity entity) {
        return !(entity instanceof Player) && !entity.m_21255_() && !entity.m_20069_() && !entity.m_20077_() && !entity.m_20068_() && !Methods.isVehicle((Entity)entity) && !entity.m_21023_(MobEffects.f_19591_) && !entity.m_21023_(MobEffects.f_19620_);
    }

    public static void gravityMath(GravityType type, LivingEntity entity, float gravity) {
        if (!Gravity.checkType(type, entity)) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingGravityEvent(entity, gravity, type))) {
            return;
        }
        entity.m_20334_(entity.m_20184_().m_7096_(), entity.m_20184_().m_7098_() / 0.98 + 0.08 - (double)gravity, entity.m_20184_().m_7094_());
    }

    public static boolean checkType(GravityType type, LivingEntity entity) {
        return type == GravityType.PLAYER && Gravity.playerGravityCheck((Player)entity) || type == GravityType.LIVING && Gravity.livingGravityCheck(entity);
    }

    public static enum GravityType {
        PLAYER,
        LIVING;

    }
}

