/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.globe;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.mrscauthd.beyond_earth.registries.BlockEntitiesRegistry;

public class GlobeTileEntity
extends BlockEntity {
    private float rotationalInertia = 0.0f;
    private float yaw = 0.0f;
    private float yaw0 = 0.0f;

    public GlobeTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.GLOBE_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag p_155245_) {
        super.m_142466_(p_155245_);
        this.rotationalInertia = p_155245_.m_128457_("inertia");
        this.yaw = p_155245_.m_128457_("yaw");
        this.yaw0 = p_155245_.m_128457_("yaw0");
    }

    public void m_183515_(CompoundTag p_187471_) {
        super.m_183515_(p_187471_);
        p_187471_.m_128350_("inertia", this.rotationalInertia);
        p_187471_.m_128350_("yaw", this.yaw);
        p_187471_.m_128350_("yaw0", this.yaw0);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        super.m_6596_();
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer p : serverLevel.m_142572_().m_6846_().m_11314_()) {
                p.f_8906_.m_141995_(this.m_183216_());
            }
        }
    }

    public void tick() {
        if (this.getRotationalInertia() > 0.0f) {
            this.setRotationalInertia(this.getRotationalInertia() - 0.0075f);
            if (this.getRotationalInertia() < 0.0f) {
                this.setRotationalInertia(0.0f);
            }
            this.setYaw0(this.getYaw());
            this.setYaw(this.getYaw() - this.getRotationalInertia());
            if (this.getRotationalInertia() == 0.0f && !this.f_58857_.f_46443_) {
                this.m_6596_();
            }
        }
    }

    public float getRotationalInertia() {
        return this.rotationalInertia;
    }

    public void setRotationalInertia(float value) {
        this.rotationalInertia = value;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float value) {
        this.yaw = value;
    }

    public float getYaw0() {
        return this.yaw0;
    }

    public void setYaw0(float value) {
        this.yaw0 = value;
    }
}

