/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.guis.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.mrscauthd.beyond_earth.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.fluids.FluidUtil2;
import net.mrscauthd.beyond_earth.utils.Rectangle2d;

public class GuiHelper {
    public static final ResourceLocation FIRE_PATH = new ResourceLocation("beyond_earth", "textures/fire_on.png");
    public static final int FIRE_WIDTH = 14;
    public static final int FIRE_HEIGHT = 14;
    public static final ResourceLocation ARROW_PATH = new ResourceLocation("beyond_earth", "textures/animated_arrow_full.png");
    public static final int ARROW_WIDTH = 24;
    public static final int ARROW_HEIGHT = 17;
    public static final ResourceLocation OXYGEN_CONTENT_PATH = new ResourceLocation("beyond_earth", "textures/oxygen.png");
    public static final ResourceLocation OXYGEN_TANK_PATH = new ResourceLocation("beyond_earth", "textures/fluid_tank_fore.png");
    public static final int OXYGEN_TANK_WIDTH = 14;
    public static final int OXYGEN_TANK_HEIGHT = 48;
    public static final ResourceLocation ENERGY_PATH = new ResourceLocation("beyond_earth", "textures/energy_full.png");
    public static final int ENERGY_WIDTH = 24;
    public static final int ENERGY_HEIGHT = 48;
    public static final int FUEL_WIDTH = 48;
    public static final int FUEL_HEIGHT = 48;
    public static final ResourceLocation FLUID_TANK_PATH = new ResourceLocation("beyond_earth", "textures/fluid_tank_fore.png");
    public static final int FLUID_TANK_WIDTH = 14;
    public static final int FLUID_TANK_HEIGHT = 48;

    public static boolean isHover(Rectangle2d bounds, double x, double y) {
        int left = bounds.getX();
        int right = left + bounds.getWidth();
        int top = bounds.getY();
        int bottom = top + bounds.getHeight();
        return (double)left <= x && x < (double)right && (double)top <= y && y < (double)bottom;
    }

    public static void drawArrow(PoseStack matrixStack, int left, int top, double ratio) {
        GuiHelper.drawHorizontal(matrixStack, left, top, 24, 17, ARROW_PATH, ratio);
    }

    public static Rectangle2d getArrowBounds(int left, int top) {
        return new Rectangle2d(left, top, 24, 17);
    }

    public static void drawFire(PoseStack matrixStack, int left, int top, double ratio) {
        GuiHelper.drawVertical(matrixStack, left, top, 14, 14, FIRE_PATH, ratio);
    }

    public static Rectangle2d getFireBounds(int left, int top) {
        return new Rectangle2d(left, top, 14, 14);
    }

    public static void drawOxygenTank(PoseStack matrixStack, int left, int top, IOxygenStorage oxygenStorage) {
        GuiHelper.drawOxygenTank(matrixStack, left, top, oxygenStorage.getOxygenStoredRatio());
    }

    public static void drawOxygenTank(PoseStack matrixStack, int left, int top, double ratio) {
        int maxHeight = 48;
        int scaledHeight = (int)Math.ceil((double)maxHeight * ratio);
        int offset = maxHeight - scaledHeight;
        RenderSystem.m_157456_((int)0, (ResourceLocation)OXYGEN_CONTENT_PATH);
        GuiHelper.drawTiledSprite(matrixStack, left, top + offset, 14, scaledHeight, 16, 16, 0.0f, 1.0f, 0.0f, 1.0f);
        GuiHelper.drawFluidTankOverlay(matrixStack, left, top);
    }

    public static Rectangle2d getOxygenTankBounds(int left, int top) {
        return new Rectangle2d(left, top, 14, 48);
    }

    public static void drawEnergy(PoseStack matrixStack, int left, int top, IEnergyStorage energyStorage) {
        GuiHelper.drawEnergy(matrixStack, left, top, (double)energyStorage.getEnergyStored() / (double)energyStorage.getMaxEnergyStored());
    }

    public static void drawEnergy(PoseStack matrixStack, int left, int top, double ratio) {
        GuiHelper.drawVertical(matrixStack, left, top, 24, 48, ENERGY_PATH, ratio);
    }

    public static void drawFuel(PoseStack matrixStack, int left, int top, double ratio) {
        ResourceLocation full = new ResourceLocation("beyond_earth", "textures/rocket_fuel_bar_full.png");
        GuiHelper.drawVertical(matrixStack, left, top, 48, 48, full, ratio);
    }

    public static Rectangle2d getEnergyBounds(int left, int top) {
        return new Rectangle2d(left, top, 24, 48);
    }

    public static Rectangle2d getBounds(int left, int top, int width, int height) {
        return new Rectangle2d(left, top, width, height);
    }

    public static void drawFluidTank(PoseStack matrixStack, int left, int top, IFluidTank tank) {
        GuiHelper.drawFluidTank(matrixStack, left, top, tank.getFluid(), tank.getCapacity());
    }

    public static void drawFluidTank(PoseStack matrixStack, int left, int top, FluidStack stack, int capacity) {
        if (stack != null && !stack.isEmpty() && capacity > 0) {
            int maxHeight = 48;
            int scaledHeight = (int)Math.ceil((double)maxHeight * ((double)stack.getAmount() / (double)capacity));
            int offset = maxHeight - scaledHeight;
            GuiHelper.drawFluid(matrixStack, left, top + offset, 14, scaledHeight, stack);
        }
        GuiHelper.drawFluidTankOverlay(matrixStack, left, top);
    }

    public static void drawFluidTankOverlay(PoseStack matrixStack, int left, int top) {
        GuiHelper.drawVertical(matrixStack, left, top, 14, 48, FLUID_TANK_PATH, 1.0);
    }

    public static void drawFluid(PoseStack matrixStack, int left, int top, int width, int height, FluidStack stack) {
        Fluid fluid = FluidUtil2.getFluid(stack);
        if (fluid == Fluids.f_76191_) {
            return;
        }
        TextureAtlasSprite fluidStillSprite = GuiHelper.getStillFluidSprite(stack);
        FluidAttributes attributes = fluid.getAttributes();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        GuiHelper.setGLColorFromInt(attributes.getColor(stack));
        GuiHelper.drawTiledSprite(matrixStack, left, top, width, height, fluidStillSprite, 16, 16);
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawRocketFluidTank(PoseStack matrixStack, int left, int top, FluidStack stack, int capacity) {
        if (stack != null && !stack.isEmpty() && capacity > 0) {
            int maxHeight = 46;
            int scaledHeight = (int)Math.ceil((double)maxHeight * ((double)stack.getAmount() / (double)capacity));
            int offset = maxHeight - scaledHeight;
            GuiHelper.drawFluid(matrixStack, left, top + offset, 46, scaledHeight, stack);
        }
    }

    public static void drawFluidHorizontal(PoseStack matrixStack, int left, int top, int width, int height, FluidStack stack, int capacity) {
        Fluid fluid = FluidUtil2.getFluid(stack);
        if (fluid == Fluids.f_76191_) {
            return;
        }
        double ratio = (double)stack.getAmount() / (double)capacity;
        GuiHelper.drawFluid(matrixStack, left, top, (int)Math.ceil((double)width * ratio), height, stack);
    }

    public static void drawFluidVertical(PoseStack matrixStack, int left, int top, int width, int height, FluidStack stack, int capacity) {
        Fluid fluid = FluidUtil2.getFluid(stack);
        if (fluid == Fluids.f_76191_) {
            return;
        }
        double ratio = (double)stack.getAmount() / (double)capacity;
        int scaledHeight = (int)Math.ceil((double)height * ratio);
        int offset = height - scaledHeight;
        GuiHelper.drawFluid(matrixStack, left, top + offset, scaledHeight, height, stack);
    }

    public static void drawTiledSprite(PoseStack matrixStack, int left, int top, int width, int height, TextureAtlasSprite sprite, int tileWidth, int tileHeight) {
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        GuiHelper.drawTiledSprite(matrixStack, left, top, width, height, tileWidth, tileHeight, uMin, uMax, vMin, vMax);
    }

    public static void drawTiledSprite(PoseStack matrixStack, int left, int top, int width, int height, int tileWidth, int tileHeight, float uMin, float uMax, float vMin, float vMax) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        int xTileCount = width / tileWidth;
        int xRemainder = width - xTileCount * tileWidth;
        int yTileCount = height / tileWidth;
        int yRemainder = height - yTileCount * tileWidth;
        int yStart = top + height;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int tiledWidth = xTile == xTileCount ? xRemainder : tileWidth;
                int tiledHeight = yTile == yTileCount ? yRemainder : tileWidth;
                int x = left + xTile * tileWidth;
                int y = yStart - (yTile + 1) * tileHeight;
                if (tiledWidth <= 0 || tiledHeight <= 0) continue;
                int maskRight = tileWidth - tiledWidth;
                int maskTop = tileHeight - tiledHeight;
                GuiHelper.drawTextureWithMasking(matrix, x, y, tileWidth, tileHeight, maskTop, maskRight, 0.0f, uMin, uMax, vMin, vMax);
            }
        }
    }

    public static void drawTextureWithMasking(Matrix4f matrix, float left, float top, float tileWidth, float tileHeight, int maskTop, int maskRight, float zLevel, float uMin, float uMax, float vMin, float vMax) {
        uMax -= (float)maskRight / tileWidth * (uMax - uMin);
        vMax -= (float)maskTop / tileHeight * (vMax - vMin);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix, left, top + tileHeight, zLevel).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, left + tileWidth - (float)maskRight, top + tileHeight, zLevel).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, left + tileWidth - (float)maskRight, top + (float)maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_85982_(matrix, left, top + (float)maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static TextureAtlasSprite getStillFluidSprite(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(stack);
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    public static Rectangle2d getFluidTankBounds(int left, int top) {
        return new Rectangle2d(left, top, 14, 48);
    }

    public static Rectangle2d getRocketFluidTankBounds(int left, int top) {
        return new Rectangle2d(left, top, 48, 48);
    }

    public static void drawVertical(PoseStack matrixStack, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)left, (int)(top + remainHeight), (float)0.0f, (float)remainHeight, (int)width, (int)ratioHeight, (int)width, (int)height);
    }

    public static void drawVerticalReverse(PoseStack matrixStack, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)width, (int)remainHeight, (int)width, (int)height);
    }

    public static void drawHorizontal(PoseStack matrixStack, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioWidth = (int)Math.ceil((double)width * ratio);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)ratioWidth, (int)height, (int)width, (int)height);
    }

    public static void drawHorizontalReverse(PoseStack matrixStack, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioWidth = (int)Math.ceil((double)width * ratio);
        int remainWidth = width - ratioWidth;
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)(left + ratioWidth), (int)top, (float)ratioWidth, (float)0.0f, (int)remainWidth, (int)height, (int)width, (int)height);
    }

    public static void innerBlit(Matrix4f matrix, float x1, float x2, float y1, float y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, x1, y2, (float)blitOffset).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, x2, y2, (float)blitOffset).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, x2, y1, (float)blitOffset).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_85982_(matrix, x1, y1, (float)blitOffset).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public static void blit(PoseStack matrixStack, float x, float y, float width, float height, float uOffset, float vOffset, float uWidth, float vHeight, int textureWidth, int textureHeight) {
        GuiHelper.innerBlit(matrixStack, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    private static void innerBlit(PoseStack matrixStack, float x1, float x2, float y1, float y2, int blitOffset, float uWidth, float vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        GuiHelper.innerBlit(matrixStack.m_85850_().m_85861_(), x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + vHeight) / (float)textureHeight);
    }

    public static void blit(PoseStack matrixStack, float x, float y, float uOffset, float vOffset, float width, float height, int textureWidth, int textureHeight) {
        GuiHelper.blit(matrixStack, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    private GuiHelper() {
    }
}

