/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.machines.tile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.mrscauthd.beyond_earth.guis.screens.coalgenerator.CoalGeneratorGui;
import net.mrscauthd.beyond_earth.machines.tile.GeneratorBlockEntity;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystemFuelGeneratingRecipe;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystemRegistry;
import net.mrscauthd.beyond_earth.registries.BlockEntitiesRegistry;

public class CoalGeneratorBlockEntity
extends GeneratorBlockEntity {
    public static final int SLOT_FUEL = 0;
    public static final int ENERGY_PER_TICK = 2;
    private PowerSystemFuelGeneratingRecipe powerSystemGenerating;

    public CoalGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.COAL_GENERATOR_BLOCK_ENTITY.get(), pos, state);
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new CoalGeneratorGui.GuiContainer(id, inventory, this);
    }

    @Override
    public int getMaxGeneration() {
        return 2;
    }

    protected int getGenerationInTick() {
        return this.getMaxGeneration();
    }

    @Override
    protected boolean canGenerateEnergy() {
        return true;
    }

    @Override
    protected void generateEnergy() {
        this.generateEnergy(this.getGenerationInTick());
    }

    @Override
    protected List<Direction> getEjectDirections() {
        List<Direction> list = super.getEjectDirections();
        list.add(Direction.UP);
        list.add(Direction.DOWN);
        return list;
    }

    @Override
    protected void createPowerSystems(PowerSystemRegistry map) {
        super.createPowerSystems(map);
        this.powerSystemGenerating = new PowerSystemFuelGeneratingRecipe(this, this.getFuelSlot());
        map.put(this.powerSystemGenerating);
    }

    public PowerSystemFuelGeneratingRecipe getPowerSystemGenerating() {
        return this.powerSystemGenerating;
    }

    public int getFuelSlot() {
        return 0;
    }
}

