/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.capabilities.oxygen.CapabilityOxygen;
import net.mrscauthd.beyond_earth.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.entities.IRocketEntity;
import net.mrscauthd.beyond_earth.entities.LanderEntity;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.guis.helper.GuiHelper;
import net.mrscauthd.beyond_earth.registries.ItemsRegistry;

@Mod.EventBusSubscriber(modid="beyond_earth", value={Dist.CLIENT})
public class Overlays {
    private static boolean check = false;
    private static float counter = 0.0f;
    private static final ResourceLocation warning = new ResourceLocation("beyond_earth", "textures/overlay/warning.png");
    private static final ResourceLocation timerN1 = new ResourceLocation("beyond_earth", "textures/timer/timer1.png");
    private static final ResourceLocation timerN2 = new ResourceLocation("beyond_earth", "textures/timer/timer2.png");
    private static final ResourceLocation timerN3 = new ResourceLocation("beyond_earth", "textures/timer/timer3.png");
    private static final ResourceLocation timerN4 = new ResourceLocation("beyond_earth", "textures/timer/timer4.png");
    private static final ResourceLocation timerN5 = new ResourceLocation("beyond_earth", "textures/timer/timer5.png");
    private static final ResourceLocation timerN6 = new ResourceLocation("beyond_earth", "textures/timer/timer6.png");
    private static final ResourceLocation timerN7 = new ResourceLocation("beyond_earth", "textures/timer/timer7.png");
    private static final ResourceLocation timerN8 = new ResourceLocation("beyond_earth", "textures/timer/timer8.png");
    private static final ResourceLocation timerN9 = new ResourceLocation("beyond_earth", "textures/timer/timer9.png");
    private static final ResourceLocation timerN10 = new ResourceLocation("beyond_earth", "textures/timer/timer10.png");
    private static final ResourceLocation oxygen_tank_empty = new ResourceLocation("beyond_earth", "textures/overlay/oxygen_tank_empty.png");
    private static final ResourceLocation oxygen_tank_full = new ResourceLocation("beyond_earth", "textures/overlay/oxygen_tank_full.png");
    private static final ResourceLocation moon = new ResourceLocation("beyond_earth", "textures/planet_bar/rocket_y_main_moon.png");
    private static final ResourceLocation mars = new ResourceLocation("beyond_earth", "textures/planet_bar/rocket_y_main_mars.png");
    private static final ResourceLocation mercury = new ResourceLocation("beyond_earth", "textures/planet_bar/rocket_y_main_mercury.png");
    private static final ResourceLocation venus = new ResourceLocation("beyond_earth", "textures/planet_bar/rocket_y_main_venus.png");
    private static final ResourceLocation glacio = new ResourceLocation("beyond_earth", "textures/planet_bar/rocket_y_main_glacio.png");
    private static final ResourceLocation earth = new ResourceLocation("beyond_earth", "textures/planet_bar/rocket_y_main_earth.png");
    private static final ResourceLocation orbit = new ResourceLocation("beyond_earth", "textures/planet_bar/rocket_y_main_orbit.png");
    private static final ResourceLocation rocketY = new ResourceLocation("beyond_earth", "textures/planet_bar/rocket_y.png");
    public static IIngameOverlay WARNING = new IIngameOverlay(){

        public void render(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
            Entity vehicle = Minecraft.m_91087_().f_91074_.m_20202_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)counter, (float)counter, (float)counter, (float)counter);
            RenderSystem.m_157456_((int)0, (ResourceLocation)warning);
            ForgeIngameGui.m_93133_((PoseStack)mStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            double speed = (double)Math.round(100.0 * vehicle.m_20184_().m_7098_()) / 100.0;
            TranslatableComponent message = new TranslatableComponent("message.beyond_earth.speed", new Object[]{speed});
            Minecraft.m_91087_().f_91062_.m_92889_(mStack, (Component)message, (float)(width / 2 - 29), (float)(height / 2) / 2.3f, -3407872);
        }
    };
    public static IIngameOverlay ROCKET_TIMER = new IIngameOverlay(){

        public void render(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
            Entity vehicle = Minecraft.m_91087_().f_91074_.m_20202_();
            int timer = 0;
            if (vehicle instanceof IRocketEntity) {
                timer = (Integer)vehicle.m_20088_().m_135370_(IRocketEntity.START_TIMER);
            }
            int timerWidth = width / 2 - 31;
            int timerHeight = height / 2 / 2;
            if (timer > -1 && timer < 20) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)timerN10);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 20 && timer < 40) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)timerN9);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 40 && timer < 60) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)timerN8);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 60 && timer < 80) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)timerN7);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 80 && timer < 100) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)timerN6);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 100 && timer < 120) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)timerN5);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 120 && timer < 140) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)timerN4);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 140 && timer < 160) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)timerN3);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 160 && timer < 180) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)timerN2);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 180 && timer < 200) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)timerN1);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            }
        }
    };
    public static IIngameOverlay OXYGEN_TANK = new IIngameOverlay(){

        public void render(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            IOxygenStorage oxygenStorage = (IOxygenStorage)chest.getCapability(CapabilityOxygen.OXYGEN).orElse(null);
            double oxygenStoredRatio = oxygenStorage != null ? oxygenStorage.getOxygenStoredRatio() : 0.0;
            int x = 5;
            int y = 5;
            int textureWidth = 62;
            int textureHeight = 52;
            GuiHelper.drawVerticalReverse(mStack, x, y, textureWidth, textureHeight, oxygen_tank_empty, oxygenStoredRatio);
            GuiHelper.drawVertical(mStack, x, y, textureWidth, textureHeight, oxygen_tank_full, oxygenStoredRatio);
            if (oxygenStorage != null) {
                MutableComponent text = GaugeTextHelper.getPercentText(GaugeValueHelper.getOxygen(oxygenStorage)).build();
                int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text);
                Minecraft.m_91087_().f_91062_.m_92763_(mStack, (Component)text, (float)(x + (textureWidth - textWidth) / 2), (float)(y + textureHeight + 3), 0xFFFFFF);
            }
        }
    };
    public static IIngameOverlay ROCKET_HEIGHT = new IIngameOverlay(){

        public void render(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            float yHeight = (float)player.m_20186_() / 5.3f;
            if (yHeight < 0.0f) {
                yHeight = 0.0f;
            } else if (yHeight > 113.0f) {
                yHeight = 113.0f;
            }
            ResourceLocation planet = Methods.isWorld((Level)world, Methods.moon) ? moon : (Methods.isWorld((Level)world, Methods.mars) ? mars : (Methods.isWorld((Level)world, Methods.mercury) ? mercury : (Methods.isWorld((Level)world, Methods.venus) ? venus : (Methods.isWorld((Level)world, Methods.glacio) ? glacio : (Methods.isOrbitWorld((Level)world) ? orbit : earth)))));
            RenderSystem.m_157456_((int)0, (ResourceLocation)planet);
            ForgeIngameGui.m_93133_((PoseStack)mStack, (int)0, (int)(height / 2 - 64), (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
            RenderSystem.m_157456_((int)0, (ResourceLocation)rocketY);
            GuiHelper.blit(mStack, 4.0f, (float)(height / 2 + 51) - yHeight, 0.0f, 0.0f, 8.0f, 11.0f, 8, 11);
        }
    };

    @SubscribeEvent
    public static void overlayEnableOrDisable(RenderGameOverlayEvent.PostLayer event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Item chestItem = player.m_6844_(EquipmentSlot.CHEST).m_41720_();
        if (player.m_20202_() instanceof LanderEntity && !player.m_20202_().m_20096_() && !player.m_204029_(FluidTags.f_13131_)) {
            OverlayRegistry.enableOverlay((IIngameOverlay)WARNING, (boolean)true);
        } else {
            OverlayRegistry.enableOverlay((IIngameOverlay)WARNING, (boolean)false);
        }
        if (Methods.isRocket(player.m_20202_())) {
            OverlayRegistry.enableOverlay((IIngameOverlay)ROCKET_TIMER, (boolean)true);
        } else {
            OverlayRegistry.enableOverlay((IIngameOverlay)ROCKET_TIMER, (boolean)false);
        }
        if (chestItem == ItemsRegistry.SPACE_SUIT.get() || chestItem == ItemsRegistry.NETHERITE_SPACE_SUIT.get()) {
            OverlayRegistry.enableOverlay((IIngameOverlay)OXYGEN_TANK, (boolean)true);
        } else {
            OverlayRegistry.enableOverlay((IIngameOverlay)OXYGEN_TANK, (boolean)false);
        }
        if (Methods.isRocket(player.m_20202_()) || player.m_20202_() instanceof LanderEntity) {
            OverlayRegistry.enableOverlay((IIngameOverlay)ROCKET_HEIGHT, (boolean)true);
        } else {
            OverlayRegistry.enableOverlay((IIngameOverlay)ROCKET_HEIGHT, (boolean)false);
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (check) {
                if ((counter += 0.1f) > 1.0f) {
                    check = false;
                }
            } else if ((double)(counter -= 0.1f) < 0.2) {
                check = true;
            }
        }
    }
}

