/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.skyrenderers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ICloudRenderHandler;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.client.IWeatherParticleRenderHandler;
import net.minecraftforge.client.IWeatherRenderHandler;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.mrscauthd.beyond_earth.registries.ParticlesRegistry;

@Mod.EventBusSubscriber(modid="beyond_earth", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class VenusSky {
    private static final float[] rainSizeX = new float[1024];
    private static final float[] rainSizeZ = new float[1024];
    private static int rainSoundTime;
    @Nullable
    private static CloudStatus prevCloudsType;
    @Nullable
    private static VertexBuffer cloudBuffer;
    private static boolean generateClouds;
    private static int prevCloudX;
    private static int prevCloudY;
    private static int prevCloudZ;
    private static Vec3 prevCloudColor;
    private static final ResourceLocation DIM_RENDER_INFO;
    private static final ResourceLocation CLOUD_TEXTURE;
    private static final ResourceLocation RAIN_TEXTURE;
    private static final ResourceLocation SUN_TEXTURE;
    private static final ResourceLocation EARTH_TEXTURE;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientSetup(FMLClientSetupEvent event) {
        DimensionSpecialEffects.f_108857_.put((Object)DIM_RENDER_INFO, (Object)new DimensionSpecialEffects(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false){

            public Vec3 m_5927_(Vec3 p_108878_, float p_108879_) {
                return p_108878_.m_82542_((double)p_108879_ * 0.867058823529 + 0.03, (double)p_108879_ * 0.770980392157 + 0.03, (double)p_108879_ * 0.494901960784 + 0.06);
            }

            public boolean m_5781_(int p_108874_, int p_108875_) {
                return true;
            }

            public ISkyRenderHandler getSkyRenderHandler() {
                return new ISkyRenderHandler(){

                    public void render(int ticks, float p_181412_, PoseStack p_181410_, ClientLevel level, Minecraft minecraft) {
                        Camera camera = minecraft.f_91063_.m_109153_();
                        FogType fogtype = camera.m_167685_();
                        if (fogtype != FogType.POWDER_SNOW && fogtype != FogType.LAVA) {
                            LivingEntity livingentity;
                            Entity entity = camera.m_90592_();
                            if (entity instanceof LivingEntity && (livingentity = (LivingEntity)entity).m_21023_(MobEffects.f_19610_)) {
                                return;
                            }
                            Matrix4f matrix4f = RenderSystem.m_157192_();
                            Matrix4f starMatrix4f = RenderSystem.m_157192_();
                            RenderSystem.m_69472_();
                            Vec3 vec3 = level.m_171660_(minecraft.f_91063_.m_109153_().m_90583_(), p_181412_);
                            float f = (float)vec3.f_82479_;
                            float f1 = (float)vec3.f_82480_;
                            float f2 = (float)vec3.f_82481_;
                            FogRenderer.m_109036_();
                            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                            RenderSystem.m_69458_((boolean)false);
                            RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
                            ShaderInstance shaderinstance = RenderSystem.m_157196_();
                            minecraft.f_91060_.f_109472_.m_166867_(p_181410_.m_85850_().m_85861_(), matrix4f, shaderinstance);
                            RenderSystem.m_69478_();
                            RenderSystem.m_69453_();
                            float[] afloat = level.m_104583_().m_7518_(level.m_46942_(p_181412_), p_181412_);
                            if (afloat != null) {
                                RenderSystem.m_157427_(GameRenderer::m_172811_);
                                RenderSystem.m_69472_();
                                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                                p_181410_.m_85836_();
                                p_181410_.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                                float f3 = Mth.m_14031_((float)level.m_46490_(p_181412_)) < 0.0f ? 180.0f : 0.0f;
                                p_181410_.m_85845_(Vector3f.f_122227_.m_122240_(f3));
                                p_181410_.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                                float f4 = afloat[0];
                                float f5 = afloat[1];
                                float f6 = afloat[2];
                                matrix4f = p_181410_.m_85850_().m_85861_();
                                bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                                bufferbuilder.m_85982_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3]).m_5752_();
                                for (int j = 0; j <= 16; ++j) {
                                    float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                                    float f8 = Mth.m_14031_((float)f7);
                                    float f9 = Mth.m_14089_((float)f7);
                                    bufferbuilder.m_85982_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
                                }
                                bufferbuilder.m_85721_();
                                BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
                                p_181410_.m_85849_();
                            }
                            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                            p_181410_.m_85836_();
                            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            RenderSystem.m_69493_();
                            p_181410_.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                            p_181410_.m_85845_(Vector3f.f_122223_.m_122240_(level.m_46942_(p_181412_) * 360.0f));
                            Matrix4f matrix4f1 = p_181410_.m_85850_().m_85861_();
                            RenderSystem.m_157427_(GameRenderer::m_172817_);
                            float f12 = 20.0f;
                            RenderSystem.m_157456_((int)0, (ResourceLocation)SUN_TEXTURE);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                            bufferbuilder.m_85982_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
                            bufferbuilder.m_85721_();
                            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
                            p_181410_.m_85845_(Vector3f.f_122225_.m_122240_(-130.0f));
                            p_181410_.m_85845_(Vector3f.f_122227_.m_122240_(210.0f));
                            RenderSystem.m_157456_((int)0, (ResourceLocation)EARTH_TEXTURE);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                            bufferbuilder.m_85982_(matrix4f1, -2.0f, -100.0f, 2.0f).m_7421_(0.0f, 0.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, 2.0f, -100.0f, 2.0f).m_7421_(1.0f, 0.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, 2.0f, -100.0f, -2.0f).m_7421_(1.0f, 1.0f).m_5752_();
                            bufferbuilder.m_85982_(matrix4f1, -2.0f, -100.0f, -2.0f).m_7421_(0.0f, 1.0f).m_5752_();
                            bufferbuilder.m_85721_();
                            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
                            RenderSystem.m_69472_();
                            float f10 = level.m_104811_(p_181412_) * 1.0f - level.m_46722_(p_181412_);
                            if (f10 > 0.0f) {
                                RenderSystem.m_157429_((float)f10, (float)f10, (float)f10, (float)f10);
                                FogRenderer.m_109017_();
                                Minecraft.m_91087_().f_91060_.f_109471_.m_166867_(p_181410_.m_85850_().m_85861_(), starMatrix4f, GameRenderer.m_172808_());
                            }
                            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            RenderSystem.m_69461_();
                            p_181410_.m_85849_();
                            RenderSystem.m_69472_();
                            RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            double d0 = minecraft.f_91074_.m_20299_((float)p_181412_).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level);
                            if (d0 < 0.0) {
                                p_181410_.m_85836_();
                                p_181410_.m_85837_(0.0, 12.0, 0.0);
                                minecraft.f_91060_.f_109473_.m_166867_(p_181410_.m_85850_().m_85861_(), matrix4f, shaderinstance);
                                p_181410_.m_85849_();
                            }
                            if (level.m_104583_().m_108882_()) {
                                RenderSystem.m_157429_((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f), (float)1.0f);
                            } else {
                                RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
                            }
                            RenderSystem.m_69493_();
                            RenderSystem.m_69458_((boolean)true);
                        }
                    }
                };
            }

            public ICloudRenderHandler getCloudRenderHandler() {
                return new ICloudRenderHandler(){

                    public void render(int ticks, float p_172957_, PoseStack p_172955_, ClientLevel level, Minecraft minecraft, double p_172958_, double p_172959_, double p_172960_) {
                        float f = level.m_104583_().m_108871_();
                        if (!Float.isNaN(f)) {
                            RenderSystem.m_69464_();
                            RenderSystem.m_69478_();
                            RenderSystem.m_69482_();
                            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                            RenderSystem.m_69458_((boolean)true);
                            float f1 = 12.0f;
                            float f2 = 4.0f;
                            double d0 = 2.0E-4;
                            double d1 = ((float)ticks + p_172957_) * 0.03f;
                            double d2 = (p_172958_ + d1) / 12.0;
                            double d3 = f - (float)p_172959_ + 0.33f;
                            double d4 = p_172960_ / 12.0 + (double)0.33f;
                            d2 -= (double)(Mth.m_14107_((double)(d2 / 2048.0)) * 2048);
                            d4 -= (double)(Mth.m_14107_((double)(d4 / 2048.0)) * 2048);
                            float f3 = (float)(d2 - (double)Mth.m_14107_((double)d2));
                            float f4 = (float)(d3 / 4.0 - (double)Mth.m_14107_((double)(d3 / 4.0))) * 4.0f;
                            float f5 = (float)(d4 - (double)Mth.m_14107_((double)d4));
                            Vec3 vec3 = level.m_104808_(p_172957_);
                            int i = (int)Math.floor(d2);
                            int j = (int)Math.floor(d3 / 4.0);
                            int k = (int)Math.floor(d4);
                            if (i != prevCloudX || j != prevCloudY || k != prevCloudZ || minecraft.f_91066_.m_92174_() != prevCloudsType || prevCloudColor.m_82557_(vec3) > 2.0E-4) {
                                prevCloudX = i;
                                prevCloudY = j;
                                prevCloudZ = k;
                                prevCloudColor = vec3;
                                prevCloudsType = minecraft.f_91066_.m_92174_();
                                generateClouds = true;
                            }
                            if (generateClouds) {
                                generateClouds = false;
                                BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                                if (cloudBuffer != null) {
                                    cloudBuffer.close();
                                }
                                cloudBuffer = new VertexBuffer();
                                this.buildClouds(bufferbuilder, d2, d3, d4, vec3);
                                bufferbuilder.m_85721_();
                                cloudBuffer.m_85925_(bufferbuilder);
                            }
                            RenderSystem.m_157427_(GameRenderer::m_172838_);
                            RenderSystem.m_157456_((int)0, (ResourceLocation)CLOUD_TEXTURE);
                            FogRenderer.m_109036_();
                            p_172955_.m_85836_();
                            p_172955_.m_85841_(12.0f, 1.0f, 12.0f);
                            p_172955_.m_85837_((double)(-f3), (double)f4, (double)(-f5));
                            if (cloudBuffer != null) {
                                int i1;
                                for (int l = i1 = prevCloudsType == CloudStatus.FANCY ? 0 : 1; l < 2; ++l) {
                                    if (l == 0) {
                                        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                                    } else {
                                        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                                    }
                                    ShaderInstance shaderinstance = RenderSystem.m_157196_();
                                    cloudBuffer.m_166867_(p_172955_.m_85850_().m_85861_(), RenderSystem.m_157192_(), shaderinstance);
                                }
                            }
                            p_172955_.m_85849_();
                            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            RenderSystem.m_69481_();
                            RenderSystem.m_69461_();
                        }
                    }

                    private void buildClouds(BufferBuilder p_109579_, double p_109580_, double p_109581_, double p_109582_, Vec3 p_109583_) {
                        float f = 4.0f;
                        float f1 = 0.00390625f;
                        int i = 8;
                        int j = 4;
                        float f2 = 9.765625E-4f;
                        float f3 = (float)Mth.m_14107_((double)p_109580_) * 0.00390625f;
                        float f4 = (float)Mth.m_14107_((double)p_109582_) * 0.00390625f;
                        float f5 = (float)p_109583_.f_82479_;
                        float f6 = (float)p_109583_.f_82480_;
                        float f7 = (float)p_109583_.f_82481_;
                        float f8 = f5 * 0.9f;
                        float f9 = f6 * 0.9f;
                        float f10 = f7 * 0.9f;
                        float f11 = f5 * 0.7f;
                        float f12 = f6 * 0.7f;
                        float f13 = f7 * 0.7f;
                        float f14 = f5 * 0.8f;
                        float f15 = f6 * 0.8f;
                        float f16 = f7 * 0.8f;
                        RenderSystem.m_157427_(GameRenderer::m_172838_);
                        p_109579_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
                        float f17 = (float)Math.floor(p_109581_ / 4.0) * 4.0f;
                        if (prevCloudsType == CloudStatus.FANCY) {
                            for (int k = -3; k <= 4; ++k) {
                                for (int l = -3; l <= 4; ++l) {
                                    float f18 = k * 8;
                                    float f19 = l * 8;
                                    if (f17 > -5.0f) {
                                        p_109579_.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                        p_109579_.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                        p_109579_.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                        p_109579_.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                    }
                                    if (f17 <= 5.0f) {
                                        p_109579_.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 8.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                                        p_109579_.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 8.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                                        p_109579_.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                                        p_109579_.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                                    }
                                    if (k > -1) {
                                        for (int i1 = 0; i1 < 8; ++i1) {
                                            p_109579_.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                            p_109579_.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                            p_109579_.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                            p_109579_.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                                        }
                                    }
                                    if (k <= 1) {
                                        for (int j2 = 0; j2 < 8; ++j2) {
                                            p_109579_.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                            p_109579_.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                            p_109579_.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                            p_109579_.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                                        }
                                    }
                                    if (l > -1) {
                                        for (int k2 = 0; k2 < 8; ++k2) {
                                            p_109579_.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                            p_109579_.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                            p_109579_.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                            p_109579_.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                                        }
                                    }
                                    if (l > 1) continue;
                                    for (int l2 = 0; l2 < 8; ++l2) {
                                        p_109579_.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                                        p_109579_.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                                        p_109579_.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                                        p_109579_.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                                    }
                                }
                            }
                        } else {
                            boolean j1 = true;
                            int k1 = 32;
                            for (int l1 = -32; l1 < 32; l1 += 32) {
                                for (int i2 = -32; i2 < 32; i2 += 32) {
                                    p_109579_.m_5483_((double)(l1 + 0), (double)f17, (double)(i2 + 32)).m_7421_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                    p_109579_.m_5483_((double)(l1 + 32), (double)f17, (double)(i2 + 32)).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                    p_109579_.m_5483_((double)(l1 + 32), (double)f17, (double)(i2 + 0)).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                    p_109579_.m_5483_((double)(l1 + 0), (double)f17, (double)(i2 + 0)).m_7421_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                                }
                            }
                        }
                    }
                };
            }

            public IWeatherRenderHandler getWeatherRenderHandler() {
                return new IWeatherRenderHandler(){

                    public void render(int ticks, float p_109705_, ClientLevel world, Minecraft minecraft, LightTexture p_109704_, double p_109706_, double p_109707_, double p_109708_) {
                        for (int i = 0; i < 32; ++i) {
                            for (int j = 0; j < 32; ++j) {
                                float f = j - 16;
                                float f1 = i - 16;
                                float f2 = Mth.m_14116_((float)(f * f + f1 * f1));
                                VenusSky.rainSizeX[i << 5 | j] = -f1 / f2;
                                VenusSky.rainSizeZ[i << 5 | j] = f / f2;
                            }
                        }
                        float f = minecraft.f_91073_.m_46722_(p_109705_);
                        if (!(f <= 0.0f)) {
                            p_109704_.m_109896_();
                            ClientLevel level = minecraft.f_91073_;
                            int i = Mth.m_14107_((double)p_109706_);
                            int j = Mth.m_14107_((double)p_109707_);
                            int k = Mth.m_14107_((double)p_109708_);
                            Tesselator tesselator = Tesselator.m_85913_();
                            BufferBuilder bufferbuilder = tesselator.m_85915_();
                            RenderSystem.m_69464_();
                            RenderSystem.m_69478_();
                            RenderSystem.m_69453_();
                            RenderSystem.m_69482_();
                            int l = 5;
                            if (Minecraft.m_91405_()) {
                                l = 10;
                            }
                            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
                            int i1 = -1;
                            float f1 = (float)ticks + p_109705_;
                            RenderSystem.m_157427_(GameRenderer::m_172829_);
                            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                            for (int j1 = k - l; j1 <= k + l; ++j1) {
                                for (int k1 = i - l; k1 <= i + l; ++k1) {
                                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                                    double d0 = (double)rainSizeX[l1] * 0.5;
                                    double d1 = (double)rainSizeZ[l1] * 0.5;
                                    blockpos$mutableblockpos.m_122169_((double)k1, p_109707_, (double)j1);
                                    Biome biome = (Biome)level.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_();
                                    if (biome.m_47530_() == Biome.Precipitation.NONE) continue;
                                    int i2 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, k1, j1);
                                    int j2 = j - l;
                                    int k2 = j + l;
                                    if (j2 < i2) {
                                        j2 = i2;
                                    }
                                    if (k2 < i2) {
                                        k2 = i2;
                                    }
                                    int l2 = i2;
                                    if (i2 < j) {
                                        l2 = j;
                                    }
                                    if (j2 == k2) continue;
                                    Random random = new Random(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761);
                                    blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                                    if (!biome.m_198906_((BlockPos)blockpos$mutableblockpos)) continue;
                                    if (i1 != 0) {
                                        if (i1 >= 0) {
                                            tesselator.m_85914_();
                                        }
                                        i1 = 0;
                                        RenderSystem.m_157456_((int)0, (ResourceLocation)RAIN_TEXTURE);
                                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                                    }
                                    int i3 = ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                                    float f2 = -((float)i3 + p_109705_) / 32.0f * (3.0f + random.nextFloat());
                                    double d2 = (double)k1 + 0.5 - p_109706_;
                                    double d4 = (double)j1 + 0.5 - p_109708_;
                                    float f3 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                                    float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                                    blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                                    LevelRenderer cfr_ignored_0 = minecraft.f_91060_;
                                    int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                                    bufferbuilder.m_5483_((double)k1 - p_109706_ - d0 + 0.5, (double)k2 - p_109707_, (double)j1 - p_109708_ - d1 + 0.5).m_7421_(0.0f, (float)j2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                                    bufferbuilder.m_5483_((double)k1 - p_109706_ + d0 + 0.5, (double)k2 - p_109707_, (double)j1 - p_109708_ + d1 + 0.5).m_7421_(1.0f, (float)j2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                                    bufferbuilder.m_5483_((double)k1 - p_109706_ + d0 + 0.5, (double)j2 - p_109707_, (double)j1 - p_109708_ + d1 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                                    bufferbuilder.m_5483_((double)k1 - p_109706_ - d0 + 0.5, (double)j2 - p_109707_, (double)j1 - p_109708_ - d1 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                                }
                            }
                            if (i1 >= 0) {
                                tesselator.m_85914_();
                            }
                            RenderSystem.m_69481_();
                            RenderSystem.m_69461_();
                            p_109704_.m_109891_();
                        }
                    }
                };
            }

            public IWeatherParticleRenderHandler getWeatherParticleRenderHandler() {
                return new IWeatherParticleRenderHandler(){

                    public void render(int ticks, ClientLevel world, Minecraft minecraft, Camera p_109694_) {
                        float f = minecraft.f_91073_.m_46722_(1.0f) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
                        if (!(f <= 0.0f)) {
                            Random random = new Random((long)ticks * 312987231L);
                            ClientLevel levelreader = minecraft.f_91073_;
                            BlockPos blockpos = new BlockPos(p_109694_.m_90583_());
                            BlockPos blockpos1 = null;
                            int i = (int)(100.0f * f * f) / (minecraft.f_91066_.f_92073_ == ParticleStatus.DECREASED ? 2 : 1);
                            for (int j = 0; j < i; ++j) {
                                int k = random.nextInt(21) - 10;
                                int l = random.nextInt(21) - 10;
                                BlockPos blockpos2 = levelreader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos.m_142082_(k, 0, l));
                                Biome biome = (Biome)levelreader.m_204166_(blockpos2).m_203334_();
                                if (blockpos2.m_123342_() <= levelreader.m_141937_() || blockpos2.m_123342_() > blockpos.m_123342_() + 10 || blockpos2.m_123342_() < blockpos.m_123342_() - 10 || biome.m_47530_() != Biome.Precipitation.RAIN || !biome.m_198906_(blockpos2)) continue;
                                blockpos1 = blockpos2.m_7495_();
                                if (minecraft.f_91066_.f_92073_ == ParticleStatus.MINIMAL) break;
                                double d0 = random.nextDouble();
                                double d1 = random.nextDouble();
                                BlockState blockstate = levelreader.m_8055_(blockpos1);
                                FluidState fluidstate = levelreader.m_6425_(blockpos1);
                                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)levelreader, blockpos1);
                                double d2 = voxelshape.m_83290_(Direction.Axis.Y, d0, d1);
                                double d3 = fluidstate.m_76155_((BlockGetter)levelreader, blockpos1);
                                double d4 = Math.max(d2, d3);
                                SimpleParticleType particleoptions = !fluidstate.m_205070_(FluidTags.f_13132_) && !blockstate.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockstate) ? (ParticleOptions)ParticlesRegistry.VENUS_RAIN_PARTICLE.get() : ParticleTypes.f_123762_;
                                minecraft.f_91073_.m_7106_((ParticleOptions)particleoptions, (double)blockpos1.m_123341_() + d0, (double)blockpos1.m_123342_() + d4, (double)blockpos1.m_123343_() + d1, 0.0, 0.0, 0.0);
                            }
                            if (blockpos1 != null && random.nextInt(3) < rainSoundTime++) {
                                rainSoundTime = 0;
                                if (blockpos1.m_123342_() > blockpos.m_123342_() + 1 && levelreader.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos).m_123342_() > Mth.m_14143_((float)blockpos.m_123342_())) {
                                    minecraft.f_91073_.m_104677_(blockpos1, SoundEvents.f_12542_, SoundSource.WEATHER, 0.1f, 0.5f, false);
                                } else {
                                    minecraft.f_91073_.m_104677_(blockpos1, SoundEvents.f_12541_, SoundSource.WEATHER, 0.2f, 1.0f, false);
                                }
                            }
                        }
                    }
                };
            }
        });
    }

    static {
        generateClouds = true;
        prevCloudX = Integer.MIN_VALUE;
        prevCloudY = Integer.MIN_VALUE;
        prevCloudZ = Integer.MIN_VALUE;
        prevCloudColor = Vec3.f_82478_;
        DIM_RENDER_INFO = new ResourceLocation("beyond_earth", "venus");
        CLOUD_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/clouds.png");
        RAIN_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/rain.png");
        SUN_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/red_sun.png");
        EARTH_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/earth.png");
    }
}

