/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.skyrenderers.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;

public class StarHelper {
    public static VertexBuffer createStars(VertexBuffer starBuffer, float scale, int amountFast, int amountFancy, boolean amountDefault) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        if (starBuffer != null) {
            starBuffer.close();
        }
        starBuffer = new VertexBuffer();
        StarHelper.drawStars(bufferbuilder, scale, amountFast, amountFancy, amountDefault);
        bufferbuilder.m_85721_();
        starBuffer.m_85925_(bufferbuilder);
        return starBuffer;
    }

    private static void drawStars(BufferBuilder p_109555_, float scale, int amountFast, int amountFancy, boolean amountDefault) {
        Random random = new Random(10842L);
        p_109555_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        GraphicsStatus graphicsMode = Minecraft.m_91087_().f_91066_.f_92115_;
        int stars = 1500;
        if (!amountDefault) {
            stars = graphicsMode == GraphicsStatus.FANCY || graphicsMode == GraphicsStatus.FABULOUS ? amountFancy : amountFast;
        }
        for (int i = 0; i < stars; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = scale + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                p_109555_.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
    }
}

