/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.biome_dictionary;

import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public interface IBiomeFilter<T> {
    public boolean passesFilter(Holder<Biome> var1);

    public List<Holder<Biome>> getAllValues();

    public List<T> getData();

    public void add(T var1);

    public static class IncludeExcludeBiomeFilter
    implements HolderSetBiomeFilter<Holder<Biome>> {
        private final HolderSet<Biome> included;
        private final HolderSet<Biome> excluded;

        public IncludeExcludeBiomeFilter(HolderSet<Biome> included, HolderSet<Biome> excluded) {
            this.included = included;
            this.excluded = excluded;
        }

        public boolean m_203333_(Holder<Biome> biome) {
            return this.included.m_203333_(biome) && !this.excluded.m_203333_(biome);
        }

        @Override
        public List<Holder<Biome>> getAllValues() {
            return this.included.m_203614_().filter(holder -> !this.excluded.m_203333_(holder)).collect(Collectors.toList());
        }

        @Override
        public List<Holder<Biome>> getData() {
            return List.of();
        }

        @Override
        public void add(Holder<Biome> object) {
        }

        public String toString() {
            return String.format("IncludeExcludeBiomeFilter[included = %s, excluded = %s]", this.included, this.excluded);
        }

        public HolderSet<Biome> getIncluded() {
            return this.included;
        }

        public HolderSet<Biome> getExcluded() {
            return this.excluded;
        }
    }

    public static class ForgeTypeFilter
    implements HolderSetBiomeFilter<BiomeDictionary.Type> {
        private final List<BiomeDictionary.Type> types;

        public ForgeTypeFilter(List<BiomeDictionary.Type> types) {
            this.types = new ArrayList<BiomeDictionary.Type>(types);
        }

        public boolean m_203333_(Holder<Biome> biome) {
            Optional keyOp = biome.m_203543_();
            if (keyOp.isPresent()) {
                ResourceKey key = (ResourceKey)keyOp.get();
                return this.types.stream().anyMatch(forgeType -> BiomeDictionary.hasType((ResourceKey)key, (BiomeDictionary.Type)forgeType));
            }
            return false;
        }

        @Override
        public List<Holder<Biome>> getAllValues() {
            return this.types.stream().map(BiomeDictionary::getBiomes).flatMap(Collection::stream).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).getHolder(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }

        @Override
        public void add(BiomeDictionary.Type object) {
            this.types.add(object);
        }

        @Override
        public List<BiomeDictionary.Type> getData() {
            return List.copyOf(this.types);
        }

        public String toString() {
            return String.format("ForgeTypeFilter[%s]", this.getAllValues());
        }
    }

    public static class BiomeTypeFilter
    implements HolderSetBiomeFilter<BiomeType> {
        private final List<BiomeType> biomeTypes;

        public BiomeTypeFilter(List<BiomeType> biomeTypes) {
            this.biomeTypes = new ArrayList<BiomeType>(biomeTypes);
        }

        public boolean m_203333_(Holder<Biome> biome) {
            return this.biomeTypes.stream().anyMatch(biomeType -> biomeType.m_203333_(biome));
        }

        @Override
        public List<Holder<Biome>> getAllValues() {
            return this.biomeTypes.stream().flatMap(HolderSetBiomeFilter::m_203614_).collect(Collectors.toList());
        }

        @Override
        public void add(BiomeType object) {
            this.biomeTypes.add(object);
        }

        @Override
        public List<BiomeType> getData() {
            return List.copyOf(this.biomeTypes);
        }

        public String toString() {
            return String.format("BiomeTypeFilter[%s]", this.getAllValues());
        }
    }

    public static class BiomeFilter
    implements HolderSetBiomeFilter<Holder<Biome>> {
        private final LinkedHashSet<Holder<Biome>> biomes;

        public BiomeFilter(List<Holder<Biome>> biomes) {
            this.biomes = new LinkedHashSet<Holder<Biome>>(biomes);
        }

        public boolean m_203333_(Holder<Biome> biome) {
            return this.biomes.contains(biome);
        }

        @Override
        public List<Holder<Biome>> getAllValues() {
            return List.copyOf(this.biomes);
        }

        @Override
        public void add(Holder<Biome> object) {
            this.biomes.add(object);
        }

        @Override
        public List<Holder<Biome>> getData() {
            return List.copyOf(this.biomes);
        }

        @Override
        public Stream<Holder<Biome>> m_203614_() {
            return this.biomes.stream();
        }

        @Override
        public int m_203632_() {
            return this.biomes.size();
        }

        public String toString() {
            return String.format("BiomeFilter[%s]", this.getAllValues());
        }
    }

    public static interface HolderSetBiomeFilter<T>
    extends IBiomeFilter<T>,
    HolderSet<Biome> {
        default public Stream<Holder<Biome>> m_203614_() {
            return this.getAllValues().stream();
        }

        default public int m_203632_() {
            return this.getAllValues().size();
        }

        default public Either<TagKey<Biome>, List<Holder<Biome>>> m_203440_() {
            return Either.right(this.getAllValues());
        }

        default public Optional<Holder<Biome>> m_203450_(Random rand) {
            return Util.m_203747_(this.getAllValues(), (Random)rand);
        }

        default public Holder<Biome> m_203662_(int index) {
            return this.getAllValues().get(index);
        }

        default public boolean m_207277_(Registry<Biome> registry) {
            return true;
        }

        default public Iterator<Holder<Biome>> iterator() {
            return this.getAllValues().iterator();
        }

        @Override
        default public boolean passesFilter(Holder<Biome> biome) {
            return this.m_203333_(biome);
        }
    }
}

