/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.registry.RegistryHelper;
import com.legacy.structure_gel.api.registry.registrar.base.IForgeRegistrar;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.IForgeRegistry;

public class BiomeRegistrar
implements IForgeRegistrar<BiomeRegistrar, Biome> {
    private final ResourceLocation registryName;
    private final Lazy<ResourceKey<Biome>> biomeKey;
    private final Supplier<Biome> biomeSupplier;
    @Nullable
    private Holder<Biome> biome;

    public BiomeRegistrar(ResourceLocation registryName, Supplier<Biome> biomeSupplier) {
        this.registryName = registryName;
        this.biomeKey = Lazy.of(() -> ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)this.registryName));
        this.biomeSupplier = biomeSupplier;
    }

    public BiomeRegistrar(ResourceLocation registryName, Biome biome) {
        this(registryName, () -> biome);
    }

    public ResourceLocation getName() {
        return this.registryName;
    }

    public Holder<Biome> getBiome() {
        return this.biome;
    }

    public ResourceKey<Biome> getKey() {
        return (ResourceKey)this.biomeKey.get();
    }

    @Override
    public BiomeRegistrar handleForge(IForgeRegistry<Biome> registry) {
        ResourceKey<Biome> key = this.getKey();
        RegistryHelper.register(registry, key.m_135782_(), this.biomeSupplier.get());
        this.biome = (Holder)registry.getHolder(key).get();
        return this;
    }
}

