/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.animation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class LegSolver {
    public final Leg[] legs;

    public LegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(LivingEntity entity, float scale) {
        this.update(entity, entity.f_20883_, scale);
    }

    public final void update(LivingEntity entity, float yaw, float scale) {
        double sideTheta = (double)yaw / 57.29577951308232;
        double sideX = Math.cos(sideTheta) * (double)scale;
        double sideZ = Math.sin(sideTheta) * (double)scale;
        double forwardTheta = sideTheta + 1.5707963267948966;
        double forwardX = Math.cos(forwardTheta) * (double)scale;
        double forwardZ = Math.sin(forwardTheta) * (double)scale;
        for (Leg leg : this.legs) {
            leg.update(entity, sideX, sideZ, forwardX, forwardZ, scale);
        }
    }

    public static final class Leg {
        public final float forward;
        public final float side;
        private final float range;
        private float height;
        private float prevHeight;
        private boolean isWing;

        public Leg(float forward, float side, float range, boolean isWing) {
            this.forward = forward;
            this.side = side;
            this.range = range;
            this.isWing = isWing;
        }

        public final float getHeight(float delta) {
            return this.prevHeight + (this.height - this.prevHeight) * delta;
        }

        public void update(LivingEntity entity, double sideX, double sideZ, double forwardX, double forwardZ, float scale) {
            this.prevHeight = this.height;
            double posY = entity.m_20186_();
            float settledHeight = this.settle(entity, entity.m_20185_() + sideX * (double)this.side + forwardX * (double)this.forward, posY, entity.m_20189_() + sideZ * (double)this.side + forwardZ * (double)this.forward, this.height);
            this.height = Mth.m_14036_((float)settledHeight, (float)(-this.range * scale), (float)(this.range * scale));
        }

        private float settle(LivingEntity entity, double x, double y, double z, float height) {
            BlockPos pos = new BlockPos(x, y + 0.001, z);
            float dist = this.getDistance(entity.f_19853_, pos);
            dist = (double)(1.0f - dist) < 0.001 ? this.getDistance(entity.f_19853_, pos.m_7495_()) + (float)y % 1.0f : (float)((double)dist - (1.0 - y % 1.0));
            if (entity.m_20096_() && height <= dist) {
                return height == dist ? height : Math.min(height + this.getFallSpeed(), dist);
            }
            if (height > 0.0f) {
                return Math.max(height - this.getRiseSpeed(), dist);
            }
            return height;
        }

        private float getDistance(Level world, BlockPos pos) {
            BlockState state = world.m_8055_(pos);
            AABB aabb = state.m_60816_((BlockGetter)world, pos).m_83263_(Direction.UP).m_83215_();
            return aabb == null ? 1.0f : 1.0f - Math.min((float)aabb.f_82292_, 1.0f);
        }

        protected float getFallSpeed() {
            return 0.25f;
        }

        protected float getRiseSpeed() {
            return 0.25f;
        }
    }
}

