/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api;

import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IApiService;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiSide.ClientOnly
@ApiStatus.NonExtendable
public interface IWailaConfig {
    public static IWailaConfig get() {
        return IApiService.INSTANCE.getConfig();
    }

    public General getGeneral();

    public Overlay getOverlay();

    public Formatter getFormatter();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.20")
    public Formatting getFormatting();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.20")
    public static interface Formatting {
        public String formatModName(Object var1);

        public String formatBlockName(Object var1);

        public String formatFluidName(Object var1);

        public String formatEntityName(Object var1);

        public String formatRegistryName(Object var1);
    }

    public static interface Formatter {
        public TextComponent modName(Object var1);

        public TextComponent blockName(Object var1);

        public TextComponent fluidName(Object var1);

        public TextComponent entityName(Object var1);

        public TextComponent registryName(Object var1);
    }

    public static interface Overlay {
        public Position getPosition();

        public float getScale();

        public Color getColor();

        public static interface Color {
            public int getAlpha();

            public int getBackgroundColor();

            public int getGradientStart();

            public int getGradientEnd();

            public int getFontColor();
        }

        public static interface Position {
            public int getX();

            public int getY();

            public Align getAlign();

            public Align getAnchor();

            public boolean isBossBarsOverlap();

            public static interface Align {
                public X getX();

                public Y getY();

                public static enum Y {
                    TOP(0.0),
                    MIDDLE(0.5),
                    BOTTOM(1.0);

                    public final double multiplier;

                    private Y(double multiplier) {
                        this.multiplier = multiplier;
                    }
                }

                public static enum X {
                    LEFT(0.0),
                    CENTER(0.5),
                    RIGHT(1.0);

                    public final double multiplier;

                    private X(double multiplier) {
                        this.multiplier = multiplier;
                    }
                }
            }
        }
    }

    public static interface General {
        public boolean isDisplayTooltip();

        public boolean isShiftForDetails();

        public DisplayMode getDisplayMode();

        public boolean isHideFromPlayerList();

        public boolean isHideFromDebug();

        public boolean isEnableTextToSpeech();

        public int getRateLimit();

        public int getMaxHealthForRender();

        public int getMaxHeartsPerLine();

        public static enum DisplayMode {
            HOLD_KEY,
            TOGGLE;

        }
    }
}

